/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.schedule;

import java.io.Closeable;
import java.io.IOException;
import org.apache.iotdb.commons.utils.ErrorHandlingCommonUtils;
import org.apache.iotdb.db.queryengine.exception.MemoryNotEnoughException;
import org.apache.iotdb.db.queryengine.execution.schedule.ITaskScheduler;
import org.apache.iotdb.db.queryengine.execution.schedule.ThreadProducer;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.IndexedBlockingQueue;
import org.apache.iotdb.db.queryengine.execution.schedule.task.DriverTask;
import org.apache.iotdb.db.utils.SetThreadName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDriverThread
extends Thread
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDriverThread.class);
    private final IndexedBlockingQueue<DriverTask> queue;
    private final ThreadProducer producer;
    protected final ITaskScheduler scheduler;
    private volatile boolean closed;

    protected AbstractDriverThread(String workerId, ThreadGroup tg, IndexedBlockingQueue<DriverTask> queue, ITaskScheduler scheduler, ThreadProducer producer) {
        super(tg, workerId);
        this.queue = queue;
        this.scheduler = scheduler;
        this.closed = false;
        this.producer = producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.closed) {
                DriverTask next;
                if (Thread.currentThread().isInterrupted()) return;
                try {
                    next = this.queue.poll();
                }
                catch (InterruptedException e) {
                    logger.warn("Executor {} failed to poll driver task from queue", (Object)this.getName());
                    Thread.currentThread().interrupt();
                    return;
                }
                if (next == null) {
                    logger.error("DriverTask should never be null");
                    continue;
                }
                try (SetThreadName driverTaskName = new SetThreadName(next.getDriverTaskId().getFullId());){
                    this.execute(next);
                }
                catch (Exception e) {
                    try (SetThreadName driverTaskName2 = new SetThreadName(next.getDriver().getDriverTaskId().getFullId());){
                        logger.warn("[ExecuteFailed]", (Throwable)e);
                        next.setAbortCause(this.getAbortCause(e));
                        this.scheduler.toAborted(next);
                    }
                }
                finally {
                    if (!Thread.interrupted() || !this.closed) continue;
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
        finally {
            if (!this.closed) {
                logger.warn("Executor {} exits because it's interrupted. We will produce another thread to replace.", (Object)this.getName());
                this.producer.produce(this.getName(), this.getThreadGroup(), this.queue, this.producer);
            } else {
                logger.info("Executor {} exits because it is closed.", (Object)this.getName());
            }
        }
    }

    protected abstract void execute(DriverTask var1) throws InterruptedException;

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    private String getAbortCause(Exception e) {
        Throwable rootCause = ErrorHandlingCommonUtils.getRootCause((Throwable)e);
        if (rootCause instanceof MemoryNotEnoughException) {
            return "Memory is not enough to execute the query task.";
        }
        return "internal error scheduled";
    }
}

