/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.ICacheStats;

class CacheStats
implements ICacheStats {
    private static final double MEMORY_THRESHOLD_RATIO = 0.8;
    private final long memoryThreshold;
    private final Supplier<Long> memoryComputation;
    private final Supplier<Long> entriesComputation;
    private final AtomicLong requestCount = new AtomicLong(0L);
    private final AtomicLong hitCount = new AtomicLong(0L);

    CacheStats(long memoryCapacity, Supplier<Long> memoryComputation, Supplier<Long> entriesComputation) {
        this.memoryThreshold = (long)((double)memoryCapacity * 0.8);
        this.memoryComputation = memoryComputation;
        this.entriesComputation = entriesComputation;
    }

    long getExceedMemory() {
        return this.memoryUsage() - this.memoryThreshold;
    }

    void recordHit(int num) {
        if (this.requestCount.get() < 0L) {
            this.requestCount.set(0L);
            this.hitCount.set(0L);
        }
        this.requestCount.getAndAdd(num);
        this.hitCount.getAndAdd(num);
    }

    void recordMiss(int num) {
        if (this.requestCount.get() < 0L) {
            this.requestCount.set(0L);
            this.hitCount.set(0L);
        }
        this.requestCount.getAndAdd(num);
    }

    @Override
    public long requestCount() {
        return this.requestCount.get();
    }

    @Override
    public long hitCount() {
        return this.hitCount.get();
    }

    @Override
    public double hitRate() {
        long hitCount = this.hitCount.get();
        if (hitCount == 0L) {
            return 0.0;
        }
        long requestCount = this.requestCount.get();
        if (requestCount == 0L) {
            return 0.0;
        }
        return (double)hitCount * 1.0 / (double)requestCount;
    }

    @Override
    public long memoryUsage() {
        return this.memoryComputation.get();
    }

    @Override
    public long capacity() {
        return this.memoryThreshold;
    }

    @Override
    public long entriesCount() {
        return this.entriesComputation.get();
    }
}

