/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.Random;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheLinkedList;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryManager;

class LRUCacheEntryManager<SK, V>
implements ICacheEntryManager<SK, V> {
    private static final int SLOT_NUM = 128;
    private final LRULinkedList[] lruLinkedLists = new LRULinkedList[128];
    private final Random idxGenerator = new Random();

    LRUCacheEntryManager() {
    }

    @Override
    public void access(CacheEntry<SK, V> cacheEntry) {
        this.getBelongedList(cacheEntry).moveToHead(cacheEntry);
    }

    @Override
    public void put(CacheEntry<SK, V> cacheEntry) {
        this.getBelongedList(cacheEntry).add(cacheEntry);
    }

    @Override
    public CacheEntry<SK, V> evict() {
        int startIndex = this.idxGenerator.nextInt(128);
        for (int i = 0; i < 128; ++i) {
            CacheEntry cacheEntry;
            LRULinkedList lruLinkedList;
            if (startIndex == 128) {
                startIndex = 0;
            }
            if ((lruLinkedList = this.lruLinkedLists[startIndex]) != null && (cacheEntry = lruLinkedList.evict()) != null) {
                return cacheEntry;
            }
            ++startIndex;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        LRULinkedList[] lRULinkedListArray = this.lruLinkedLists;
        synchronized (this.lruLinkedLists) {
            for (int i = 0; i < 128; ++i) {
                this.lruLinkedLists[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LRULinkedList getBelongedList(CacheEntry<SK, V> cacheEntry) {
        int slotIndex = cacheEntry.hashCode() % 128;
        slotIndex = slotIndex < 0 ? slotIndex + 128 : slotIndex;
        LRULinkedList lruLinkedList = this.lruLinkedLists[slotIndex];
        if (lruLinkedList != null) return lruLinkedList;
        LRULinkedList[] lRULinkedListArray = this.lruLinkedLists;
        synchronized (this.lruLinkedLists) {
            lruLinkedList = this.lruLinkedLists[slotIndex];
            if (lruLinkedList != null) return lruLinkedList;
            this.lruLinkedLists[slotIndex] = lruLinkedList = new LRULinkedList();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return lruLinkedList;
        }
    }

    private static class LRULinkedList<SK, V>
    extends CacheLinkedList<SK, V> {
        private LRULinkedList() {
        }

        synchronized void moveToHead(CacheEntry<SK, V> cacheEntry) {
            if (cacheEntry.isInvalidated.get()) {
                return;
            }
            cacheEntry.pre.next = cacheEntry.next;
            cacheEntry.next.pre = cacheEntry.pre;
            cacheEntry.next = this.head.next;
            cacheEntry.pre = this.head;
            this.head.next.pre = cacheEntry;
            this.head.next = cacheEntry;
        }
    }
}

