/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.SchemaDirCreationFailureException;
import org.apache.iotdb.db.exception.metadata.SchemaQuotaExceededException;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.schemaengine.metric.ISchemaRegionMetric;
import org.apache.iotdb.db.schemaengine.metric.SchemaRegionCachedMetric;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.rescon.DataNodeSchemaQuotaManager;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegionParams;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegionPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionPlanVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionUtils;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.FakeCRC32Deserializer;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.FakeCRC32Serializer;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.MLogDescriptionReader;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.MLogDescriptionWriter;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.SchemaLogReader;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.SchemaLogWriter;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.visitor.SchemaRegionPlanDeserializer;
import org.apache.iotdb.db.schemaengine.schemaregion.logfile.visitor.SchemaRegionPlanSerializer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.MTreeBelowSGCachedImpl;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.ReleaseFlushMonitor;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowDevicesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowNodesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.INodeSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.iotdb.db.schemaengine.schemaregion.tag.TagManager;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.filter.FilterContainsVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IActivateTemplateInClusterPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IAutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IChangeAliasPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IChangeTagOffsetPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IDeactivateTemplatePlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IDeleteTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IPreDeactivateTemplatePlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IPreDeleteTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IRollbackPreDeactivateTemplatePlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IRollbackPreDeleteTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.SchemaRegionWritePlanFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.impl.CreateAlignedTimeSeriesPlanImpl;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.impl.CreateTimeSeriesPlanImpl;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.view.IAlterLogicalViewPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.view.ICreateLogicalViewPlan;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SchemaRegion(mode="PBTree")
public class SchemaRegionPBTreeImpl
implements ISchemaRegion {
    private static final Logger logger = LoggerFactory.getLogger(SchemaRegionPBTreeImpl.class);
    protected static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private boolean isRecovering = true;
    private volatile boolean initialized = false;
    private boolean isClearing = false;
    private final String storageGroupDirPath;
    private final String schemaRegionDirPath;
    private final String storageGroupFullPath;
    private final SchemaRegionId schemaRegionId;
    private boolean usingMLog = true;
    private SchemaLogWriter<ISchemaRegionPlan> logWriter;
    private MLogDescriptionWriter logDescriptionWriter;
    private final CachedSchemaRegionStatistics regionStatistics;
    private final SchemaRegionCachedMetric metric;
    private final DataNodeSchemaQuotaManager schemaQuotaManager = DataNodeSchemaQuotaManager.getInstance();
    private MTreeBelowSGCachedImpl mtree;
    private TagManager tagManager;

    public SchemaRegionPBTreeImpl(ISchemaRegionParams schemaRegionParams) throws MetadataException {
        this.storageGroupFullPath = schemaRegionParams.getDatabase().getFullPath();
        this.schemaRegionId = schemaRegionParams.getSchemaRegionId();
        this.storageGroupDirPath = config.getSchemaDir() + File.separator + this.storageGroupFullPath;
        this.schemaRegionDirPath = this.storageGroupDirPath + File.separator + this.schemaRegionId.getId();
        this.regionStatistics = new CachedSchemaRegionStatistics(this.schemaRegionId.getId(), schemaRegionParams.getSchemaEngineStatistics());
        this.metric = new SchemaRegionCachedMetric(this.regionStatistics, schemaRegionParams.getDatabase().getFullPath());
        this.init();
    }

    @Override
    public synchronized void init() throws MetadataException {
        if (this.initialized) {
            return;
        }
        if (config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            long memCost = config.getSchemaRatisConsensusLogAppenderBufferSizeMax();
            if (!SystemInfo.getInstance().addDirectBufferMemoryCost(memCost)) {
                throw new MetadataException("Total allocated memory for direct buffer will be " + (SystemInfo.getInstance().getDirectBufferMemoryCost() + memCost) + ", which is greater than limit mem cost: " + SystemInfo.getInstance().getTotalDirectBufferMemorySizeLimit());
            }
        }
        this.initDir();
        try {
            this.isRecovering = true;
            this.tagManager = new TagManager(this.schemaRegionDirPath, this.regionStatistics);
            this.mtree = new MTreeBelowSGCachedImpl(new PartialPath(this.storageGroupFullPath), this.tagManager::readTags, this.tagManager::readAttributes, this::flushCallback, this.measurementInitProcess(), this.deviceInitProcess(), this.schemaRegionId.getId(), this.regionStatistics, this.metric);
            if (!config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                this.usingMLog = true;
                this.initMLog();
            } else {
                this.usingMLog = false;
            }
            this.isRecovering = false;
        }
        catch (IOException e) {
            logger.error("Cannot recover all MTree from {} file, we try to recover as possible as we can", (Object)this.storageGroupFullPath, (Object)e);
        }
        this.initialized = true;
    }

    private Consumer<IMeasurementMNode<ICachedMNode>> measurementInitProcess() {
        return measurementMNode -> {
            if (measurementMNode.isLogicalView()) {
                this.regionStatistics.addView(1L);
            } else {
                this.regionStatistics.addMeasurement(1L);
            }
            if (measurementMNode.getOffset() == -1L) {
                return;
            }
            try {
                this.tagManager.recoverIndex(measurementMNode.getOffset(), (IMeasurementMNode<?>)measurementMNode);
            }
            catch (IOException e) {
                logger.error("Failed to recover tagIndex for {} in schemaRegion {}.", (Object)(this.storageGroupFullPath + "." + measurementMNode.getFullPath()), (Object)this.schemaRegionId);
            }
        };
    }

    private Consumer<IDeviceMNode<ICachedMNode>> deviceInitProcess() {
        return deviceMNode -> {
            this.regionStatistics.addDevice();
            if (deviceMNode.getSchemaTemplateIdWithState() >= 0) {
                this.regionStatistics.activateTemplate(deviceMNode.getSchemaTemplateId());
            }
        };
    }

    private void flushCallback() {
        if (this.usingMLog && !this.isRecovering) {
            try {
                this.logDescriptionWriter.updateCheckPoint(this.logWriter.position());
                this.regionStatistics.setMlogCheckPoint(this.logWriter.position());
            }
            catch (IOException e) {
                logger.warn("Update {} failed because {}", new Object[]{"mlog.description", e.getMessage(), e});
            }
        }
    }

    private void initDir() throws SchemaDirCreationFailureException {
        File schemaRegionFolder;
        File sgSchemaFolder = SystemFileFactory.INSTANCE.getFile(this.storageGroupDirPath);
        if (!sgSchemaFolder.exists()) {
            if (sgSchemaFolder.mkdirs()) {
                logger.info("create database schema folder {}", (Object)this.storageGroupDirPath);
            } else if (!sgSchemaFolder.exists()) {
                logger.error("create database schema folder {} failed.", (Object)this.storageGroupDirPath);
                throw new SchemaDirCreationFailureException(this.storageGroupDirPath);
            }
        }
        if (!(schemaRegionFolder = SystemFileFactory.INSTANCE.getFile(this.schemaRegionDirPath)).exists()) {
            if (schemaRegionFolder.mkdirs()) {
                logger.info("create schema region folder {}", (Object)this.schemaRegionDirPath);
            } else if (!schemaRegionFolder.exists()) {
                logger.error("create schema region folder {} failed.", (Object)this.schemaRegionDirPath);
                throw new SchemaDirCreationFailureException(this.schemaRegionDirPath);
            }
        }
    }

    private void initMLog() throws IOException {
        this.initFromLog();
        this.logWriter = new SchemaLogWriter<ISchemaRegionPlan>(this.schemaRegionDirPath, "mlog.bin", new FakeCRC32Serializer<ISchemaRegionPlan>(new SchemaRegionPlanSerializer()), config.getSyncMlogPeriodInMs() == 0L);
        this.logDescriptionWriter = new MLogDescriptionWriter(this.schemaRegionDirPath, "mlog.description");
    }

    public void writeToMLog(ISchemaRegionPlan schemaRegionPlan) throws IOException {
        if (this.usingMLog && !this.isRecovering) {
            this.logWriter.write(schemaRegionPlan);
            this.regionStatistics.setMlogLength(this.logWriter.position());
        }
    }

    @Override
    public void forceMlog() {
        if (!this.initialized) {
            return;
        }
        if (this.usingMLog) {
            try {
                SchemaLogWriter<ISchemaRegionPlan> logWriter = this.logWriter;
                if (logWriter != null) {
                    logWriter.force();
                }
            }
            catch (IOException e) {
                logger.error("Cannot force {} mlog to the schema region", (Object)this.schemaRegionId, (Object)e);
            }
        }
    }

    @Override
    public MemSchemaRegionStatistics getSchemaRegionStatistics() {
        return this.regionStatistics;
    }

    @Override
    public ISchemaRegionMetric getSchemaRegionMetric() {
        return this.metric;
    }

    private void initFromLog() throws IOException {
        File logFile = SystemFileFactory.INSTANCE.getFile(this.schemaRegionDirPath + File.separator + "mlog.bin");
        File logDescriptionFile = SystemFileFactory.INSTANCE.getFile(this.schemaRegionDirPath + File.separator + "mlog.description");
        long time = System.currentTimeMillis();
        if (logFile.exists()) {
            long mLogOffset = 0L;
            try {
                MLogDescriptionReader mLogDescriptionReader = new MLogDescriptionReader(this.schemaRegionDirPath, "mlog.description");
                mLogOffset = mLogDescriptionReader.readCheckPoint();
                logger.info("MLog recovery check point: {}", (Object)mLogOffset);
            }
            catch (IOException e) {
                logger.warn("Can not get check point in MLogDescription file because {}, use default value 0.", (Object)e.getMessage());
            }
            try (SchemaLogReader<ISchemaRegionPlan> mLogReader = new SchemaLogReader<ISchemaRegionPlan>(this.schemaRegionDirPath, "mlog.bin", new FakeCRC32Deserializer<ISchemaRegionPlan>(new SchemaRegionPlanDeserializer()));){
                this.applyMLog(mLogReader, mLogOffset);
                logger.debug("spend {} ms to deserialize {} mtree from mlog.bin", (Object)(System.currentTimeMillis() - time), (Object)this.storageGroupFullPath);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("Failed to parse " + this.storageGroupFullPath + " mlog.bin for err:" + e);
            }
        }
    }

    private void applyMLog(SchemaLogReader<ISchemaRegionPlan> mLogReader, long offset) {
        RecoverPlanOperator recoverPlanOperator = new RecoverPlanOperator();
        try {
            mLogReader.skip(offset);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (mLogReader.hasNext()) {
            ISchemaRegionPlan plan = mLogReader.next();
            RecoverOperationResult operationResult = plan.accept(recoverPlanOperator, this);
            if (!operationResult.isFailed()) continue;
            logger.error("Can not operate cmd {} for err:", (Object)plan.getPlanType().name(), (Object)operationResult.getException());
        }
        if (mLogReader.isFileCorrupted()) {
            throw new IllegalStateException("The mlog.bin has been corrupted. Please remove it or fix it, and then restart IoTDB");
        }
    }

    @Override
    public synchronized void clear() {
        this.isClearing = true;
        try {
            if (this.mtree != null) {
                this.mtree.clear();
            }
            this.regionStatistics.clear();
            if (this.logWriter != null) {
                this.logWriter.close();
                this.logWriter = null;
            }
            if (this.logDescriptionWriter != null) {
                this.logDescriptionWriter.close();
                this.logDescriptionWriter = null;
            }
            this.tagManager.clear();
            this.isRecovering = true;
            this.initialized = false;
        }
        catch (IOException e) {
            logger.error("Cannot close metadata log writer, because:", (Throwable)e);
        }
        this.isClearing = false;
    }

    @Override
    public String getDatabaseFullPath() {
        return this.storageGroupFullPath;
    }

    @Override
    public SchemaRegionId getSchemaRegionId() {
        return this.schemaRegionId;
    }

    @Override
    public synchronized void deleteSchemaRegion() throws MetadataException {
        this.clear();
        SchemaRegionUtils.deleteSchemaRegionFolder(this.schemaRegionDirPath, logger);
        if (config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            SystemInfo.getInstance().decreaseDirectBufferMemoryCost(config.getSchemaRatisConsensusLogAppenderBufferSizeMax());
        }
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        if (!this.initialized) {
            logger.warn("Failed to create snapshot of schemaRegion {}, because the schemaRegion has not been initialized.", (Object)this.schemaRegionId);
            return false;
        }
        logger.info("Start create snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        boolean isSuccess = true;
        long startTime = System.currentTimeMillis();
        long mtreeSnapshotStartTime = System.currentTimeMillis();
        isSuccess = isSuccess && this.mtree.createSnapshot(snapshotDir);
        logger.info("MTree snapshot creation of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - mtreeSnapshotStartTime));
        long tagSnapshotStartTime = System.currentTimeMillis();
        isSuccess = isSuccess && this.tagManager.createSnapshot(snapshotDir);
        logger.info("Tag snapshot creation of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - tagSnapshotStartTime));
        logger.info("Snapshot creation of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - startTime));
        logger.info("Successfully create snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        return isSuccess;
    }

    @Override
    public void loadSnapshot(File latestSnapshotRootDir) {
        this.clear();
        logger.info("Start loading snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        long startTime = System.currentTimeMillis();
        try {
            this.usingMLog = false;
            this.isRecovering = true;
            long tagSnapshotStartTime = System.currentTimeMillis();
            this.tagManager = TagManager.loadFromSnapshot(latestSnapshotRootDir, this.schemaRegionDirPath, this.regionStatistics);
            logger.info("Tag snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - tagSnapshotStartTime));
            long mtreeSnapshotStartTime = System.currentTimeMillis();
            this.mtree = MTreeBelowSGCachedImpl.loadFromSnapshot(latestSnapshotRootDir, this.storageGroupFullPath, this.schemaRegionId.getId(), this.regionStatistics, this.metric, this.measurementInitProcess(), this.deviceInitProcess(), this.tagManager::readTags, this.tagManager::readAttributes, this::flushCallback);
            logger.info("MTree snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - mtreeSnapshotStartTime));
            this.isRecovering = false;
            this.initialized = true;
            logger.info("Snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - startTime));
            logger.info("Successfully load snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        }
        catch (IOException | MetadataException e) {
            logger.error("Failed to load snapshot for schemaRegion {}  due to {}. Use empty schemaRegion", new Object[]{this.schemaRegionId, e.getMessage(), e});
            try {
                this.initialized = false;
                this.isRecovering = true;
                this.init();
            }
            catch (MetadataException metadataException) {
                logger.error("Error occurred during initializing schemaRegion {}", (Object)this.schemaRegionId, (Object)metadataException);
            }
        }
    }

    public void createTimeSeries(ICreateTimeSeriesPlan plan) throws MetadataException {
        this.createTimeSeries(plan, -1L);
    }

    public void recoverTimeSeries(ICreateTimeSeriesPlan plan, long offset) throws MetadataException {
        boolean done = false;
        while (!done) {
            try {
                this.createTimeSeries(plan, offset);
                done = true;
            }
            catch (AliasAlreadyExistException | PathAlreadyExistException e) {
                done = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTimeSeries(ICreateTimeSeriesPlan plan, long offset) throws MetadataException {
        while (!this.regionStatistics.isAllowToCreateNewSeries()) {
            ReleaseFlushMonitor.getInstance().waitIfReleasing();
        }
        PartialPath path = plan.getPath();
        try {
            SchemaUtils.checkDataTypeWithEncoding(plan.getDataType(), plan.getEncoding());
            TSDataType type = plan.getDataType();
            IMeasurementMNode<ICachedMNode> leafMNode = this.mtree.createTimeSeriesWithPinnedReturn(path, type, plan.getEncoding(), plan.getCompressor(), plan.getProps(), plan.getAlias(), plan instanceof CreateTimeSeriesPlanImpl && ((CreateTimeSeriesPlanImpl)plan).isWithMerge(), plan instanceof CreateTimeSeriesPlanImpl ? ((CreateTimeSeriesPlanImpl)plan).getAligned() : null);
            try {
                if (Objects.isNull(leafMNode)) {
                    this.upsertAliasAndTagsAndAttributes(plan.getAlias(), plan.getTags(), plan.getAttributes(), path);
                    return;
                }
                this.regionStatistics.addMeasurement(1L);
                if (offset != -1L && this.isRecovering) {
                    this.tagManager.recoverIndex(offset, leafMNode);
                    this.mtree.pinMNode((ICachedMNode)leafMNode.getAsMNode());
                } else if (plan.getTags() != null) {
                    this.tagManager.addIndex(plan.getTags(), leafMNode);
                    this.mtree.pinMNode((ICachedMNode)leafMNode.getAsMNode());
                }
                if (!this.isRecovering) {
                    if (plan.getTags() != null && !plan.getTags().isEmpty() || plan.getAttributes() != null && !plan.getAttributes().isEmpty()) {
                        offset = this.tagManager.writeTagFile(plan.getTags(), plan.getAttributes());
                    }
                    plan.setTagOffset(offset);
                    this.writeToMLog(plan);
                }
                if (offset != -1L) {
                    long finalOffset = offset;
                    this.mtree.updateMNode((ICachedMNode)leafMNode.getAsMNode(), o -> o.getAsMeasurementMNode().setOffset(finalOffset));
                }
            }
            finally {
                if (Objects.nonNull(leafMNode)) {
                    this.mtree.unPinMNode((ICachedMNode)leafMNode.getAsMNode());
                }
            }
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    public void createAlignedTimeSeries(PartialPath prefixPath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws MetadataException {
        this.createAlignedTimeSeries(SchemaRegionWritePlanFactory.getCreateAlignedTimeSeriesPlan(prefixPath, measurements, dataTypes, encodings, compressors, null, null, null));
    }

    public void recoverAlignedTimeSeries(ICreateAlignedTimeSeriesPlan plan) throws MetadataException {
        this.createAlignedTimeSeries(plan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createAlignedTimeSeries(ICreateAlignedTimeSeriesPlan plan) throws MetadataException {
        while (!this.regionStatistics.isAllowToCreateNewSeries()) {
            ReleaseFlushMonitor.getInstance().waitIfReleasing();
        }
        try {
            PartialPath prefixPath = plan.getDevicePath();
            List<String> measurements = plan.getMeasurements();
            List<TSDataType> dataTypes = plan.getDataTypes();
            List<TSEncoding> encodings = plan.getEncodings();
            List<CompressionType> compressors = plan.getCompressors();
            List<String> aliasList = plan.getAliasList();
            List<Map<String, String>> tagsList = plan.getTagsList();
            List<Map<String, String>> attributesList = plan.getAttributesList();
            for (int i = 0; i < measurements.size(); ++i) {
                SchemaUtils.checkDataTypeWithEncoding(dataTypes.get(i), encodings.get(i));
            }
            HashSet<Integer> existingMeasurementIndexes = new HashSet<Integer>();
            List<IMeasurementMNode<ICachedMNode>> measurementMNodeList = this.mtree.createAlignedTimeSeries(prefixPath, measurements, dataTypes, encodings, compressors, aliasList, plan instanceof CreateAlignedTimeSeriesPlanImpl && ((CreateAlignedTimeSeriesPlanImpl)plan).isWithMerge(), existingMeasurementIndexes, plan instanceof CreateAlignedTimeSeriesPlanImpl ? ((CreateAlignedTimeSeriesPlanImpl)plan).getAligned() : null);
            try {
                int i;
                this.regionStatistics.addMeasurement(measurementMNodeList.size());
                List<Long> tagOffsets = plan.getTagOffsets();
                for (i = measurements.size() - 1; i >= 0 && !existingMeasurementIndexes.isEmpty(); --i) {
                    if (!existingMeasurementIndexes.remove(i)) continue;
                    this.upsertAliasAndTagsAndAttributes(Objects.nonNull(aliasList) ? aliasList.remove(i) : null, Objects.nonNull(tagsList) ? tagsList.remove(i) : null, Objects.nonNull(attributesList) ? attributesList.remove(i) : null, prefixPath.concatNode(measurements.get(i)));
                    if (Objects.nonNull(tagOffsets) && !tagOffsets.isEmpty()) {
                        tagOffsets.remove(i);
                    }
                    measurements.remove(i);
                    dataTypes.remove(i);
                    encodings.remove(i);
                    compressors.remove(i);
                }
                if (measurementMNodeList.isEmpty()) {
                    return;
                }
                for (i = 0; i < measurements.size(); ++i) {
                    if (tagOffsets != null && !plan.getTagOffsets().isEmpty() && this.isRecovering) {
                        if (tagOffsets.get(i) == -1L) continue;
                        this.tagManager.recoverIndex(plan.getTagOffsets().get(i), measurementMNodeList.get(i));
                        this.mtree.pinMNode((ICachedMNode)measurementMNodeList.get(i).getAsMNode());
                        continue;
                    }
                    if (tagsList == null || tagsList.isEmpty() || tagsList.get(i) == null) continue;
                    this.tagManager.addIndex(tagsList.get(i), measurementMNodeList.get(i));
                    this.mtree.pinMNode((ICachedMNode)measurementMNodeList.get(i).getAsMNode());
                }
                tagOffsets = new ArrayList<Long>();
                if (!this.isRecovering) {
                    if (tagsList != null && !tagsList.isEmpty() || attributesList != null && !attributesList.isEmpty()) {
                        for (int i2 = 0; i2 < measurements.size(); ++i2) {
                            Map<String, String> attributes;
                            Map<String, String> tags = tagsList == null ? null : tagsList.get(i2);
                            Map<String, String> map = attributes = attributesList == null ? null : attributesList.get(i2);
                            if (tags == null && attributes == null) {
                                tagOffsets.add(-1L);
                                continue;
                            }
                            tagOffsets.add(this.tagManager.writeTagFile(tags, attributes));
                        }
                    } else {
                        for (i = 0; i < measurements.size(); ++i) {
                            tagOffsets.add(-1L);
                        }
                    }
                    plan.setTagOffsets(tagOffsets);
                    this.writeToMLog(plan);
                }
                tagOffsets = plan.getTagOffsets();
                for (int i3 = 0; i3 < measurements.size(); ++i3) {
                    if (tagOffsets.get(i3) == -1L) continue;
                    long offset = tagOffsets.get(i3);
                    this.mtree.updateMNode((ICachedMNode)measurementMNodeList.get(i3).getAsMNode(), o -> o.getAsMeasurementMNode().setOffset(offset));
                }
            }
            finally {
                for (IMeasurementMNode<ICachedMNode> measurementMNode : measurementMNodeList) {
                    this.mtree.unPinMNode((ICachedMNode)measurementMNode.getAsMNode());
                }
            }
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public Map<Integer, MetadataException> checkMeasurementExistence(PartialPath devicePath, List<String> measurementList, List<String> aliasList) {
        try {
            return this.mtree.checkMeasurementExistence(devicePath, measurementList, aliasList);
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    @Override
    public void checkSchemaQuota(PartialPath devicePath, int timeSeriesNum) throws SchemaQuotaExceededException {
        if (!this.mtree.checkDeviceNodeExists(devicePath)) {
            this.schemaQuotaManager.check(timeSeriesNum, 1);
        } else {
            this.schemaQuotaManager.check(timeSeriesNum, 0);
        }
    }

    @Override
    public Pair<Long, Boolean> constructSchemaBlackList(PathPatternTree patternTree) throws MetadataException {
        long preDeletedNum = 0L;
        AtomicBoolean isAllLogicalView = new AtomicBoolean(true);
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            List<PartialPath> paths = this.mtree.constructSchemaBlackList(pathPattern, isAllLogicalView);
            preDeletedNum += (long)paths.size();
            for (PartialPath path : paths) {
                try {
                    this.writeToMLog(SchemaRegionWritePlanFactory.getPreDeleteTimeSeriesPlan(path));
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
        }
        return new Pair((Object)preDeletedNum, (Object)isAllLogicalView.get());
    }

    private void recoverPreDeleteTimeseries(PartialPath path) throws MetadataException {
        this.mtree.constructSchemaBlackList(path, new AtomicBoolean(true));
    }

    @Override
    public void rollbackSchemaBlackList(PathPatternTree patternTree) throws MetadataException {
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            List<PartialPath> paths = this.mtree.rollbackSchemaBlackList(pathPattern);
            for (PartialPath path : paths) {
                try {
                    this.writeToMLog(SchemaRegionWritePlanFactory.getRollbackPreDeleteTimeSeriesPlan(path));
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
        }
    }

    @Override
    public Set<PartialPath> fetchSchemaBlackList(PathPatternTree patternTree) throws MetadataException {
        HashSet<PartialPath> deviceBasedPathPatternSet = new HashSet<PartialPath>();
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            for (PartialPath devicePath : this.mtree.getDevicesOfPreDeletedTimeseries(pathPattern)) {
                deviceBasedPathPatternSet.addAll(pathPattern.alterPrefixPath(devicePath));
            }
        }
        return deviceBasedPathPatternSet;
    }

    @Override
    public void deleteTimeseriesInBlackList(PathPatternTree patternTree) throws MetadataException {
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            for (PartialPath path : this.mtree.getPreDeletedTimeseries(pathPattern)) {
                try {
                    this.deleteSingleTimeseriesInBlackList(path);
                    this.writeToMLog(SchemaRegionWritePlanFactory.getDeleteTimeSeriesPlan(Collections.singletonList(path)));
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
        }
    }

    @Override
    public void createLogicalView(ICreateLogicalViewPlan plan) throws MetadataException {
        while (!this.regionStatistics.isAllowToCreateNewSeries()) {
            ReleaseFlushMonitor.getInstance().waitIfReleasing();
        }
        try {
            List<PartialPath> pathList = plan.getViewPathList();
            Map<PartialPath, ViewExpression> viewPathToSourceMap = plan.getViewPathToSourceExpressionMap();
            for (PartialPath path : pathList) {
                ViewExpression viewExpression = viewPathToSourceMap.get(path);
                this.mtree.createLogicalView(path, viewExpression);
                if (!this.isRecovering) {
                    this.writeToMLog(SchemaRegionWritePlanFactory.getCreateLogicalViewPlan(path, viewExpression));
                }
                this.regionStatistics.addView(1L);
            }
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public long constructLogicalViewBlackList(PathPatternTree patternTree) throws MetadataException {
        long preDeletedNum = 0L;
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            List<PartialPath> paths = this.mtree.constructLogicalViewBlackList(pathPattern);
            preDeletedNum += (long)paths.size();
            for (PartialPath path : paths) {
                try {
                    this.writeToMLog(SchemaRegionWritePlanFactory.getPreDeleteLogicalViewPlan(path));
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
        }
        return preDeletedNum;
    }

    @Override
    public void rollbackLogicalViewBlackList(PathPatternTree patternTree) throws MetadataException {
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            List<PartialPath> paths = this.mtree.rollbackLogicalViewBlackList(pathPattern);
            for (PartialPath path : paths) {
                try {
                    this.writeToMLog(SchemaRegionWritePlanFactory.getRollbackPreDeleteLogicalViewPlan(path));
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
        }
    }

    @Override
    public void deleteLogicalView(PathPatternTree patternTree) throws MetadataException {
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            for (PartialPath path : this.mtree.getPreDeletedLogicalView(pathPattern)) {
                try {
                    this.deleteSingleTimeseriesInBlackList(path);
                    this.writeToMLog(SchemaRegionWritePlanFactory.getDeleteLogicalViewPlan(path));
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
        }
    }

    @Override
    public void alterLogicalView(IAlterLogicalViewPlan alterLogicalViewPlan) throws MetadataException {
        this.mtree.alterLogicalView(alterLogicalViewPlan.getViewPath(), alterLogicalViewPlan.getSourceExpression());
        if (!this.isRecovering) {
            try {
                this.writeToMLog(alterLogicalViewPlan);
            }
            catch (IOException e) {
                throw new MetadataException((Throwable)e);
            }
        }
    }

    private void deleteSingleTimeseriesInBlackList(PartialPath path) throws MetadataException, IOException {
        IMeasurementMNode<ICachedMNode> measurementMNode = this.mtree.deleteTimeseries(path);
        this.removeFromTagInvertedIndex(measurementMNode);
        if (measurementMNode.isLogicalView()) {
            this.regionStatistics.deleteView(1L);
        } else {
            this.regionStatistics.deleteMeasurement(1L);
        }
    }

    private void recoverRollbackPreDeleteTimeseries(PartialPath path) throws MetadataException {
        this.mtree.rollbackSchemaBlackList(path);
    }

    private void deleteOneTimeseriesUpdateStatistics(PartialPath path) throws MetadataException, IOException {
        IMeasurementMNode<ICachedMNode> measurementMNode = this.mtree.deleteTimeseries(path);
        this.removeFromTagInvertedIndex(measurementMNode);
        if (measurementMNode.isLogicalView()) {
            this.regionStatistics.deleteView(1L);
        } else {
            this.regionStatistics.deleteMeasurement(1L);
        }
    }

    private ICachedMNode getDeviceNodeWithAutoCreate(PartialPath path) throws IOException, MetadataException {
        ICachedMNode node = this.mtree.getDeviceNodeWithAutoCreating(path);
        this.writeToMLog(SchemaRegionWritePlanFactory.getAutoCreateDeviceMNodePlan(node.getPartialPath()));
        return node;
    }

    private void autoCreateDeviceMNode(IAutoCreateDeviceMNodePlan plan) throws MetadataException {
        ICachedMNode node = this.mtree.getDeviceNodeWithAutoCreating(plan.getPath());
        this.mtree.unPinMNode(node);
        try {
            this.writeToMLog(plan);
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeasurementPath fetchMeasurementPath(PartialPath fullPath) throws MetadataException {
        IMeasurementMNode<ICachedMNode> node = this.mtree.getMeasurementMNode(fullPath);
        try {
            MeasurementPath res = new MeasurementPath(node.getPartialPath(), node.getSchema());
            res.setUnderAlignedEntity(Boolean.valueOf(((ICachedMNode)node.getParent()).getAsDeviceMNode().isAligned()));
            MeasurementPath measurementPath = res;
            return measurementPath;
        }
        finally {
            this.mtree.unPinMNode((ICachedMNode)node.getAsMNode());
        }
    }

    @Override
    public ClusterSchemaTree fetchSeriesSchema(PathPatternTree patternTree, Map<Integer, Template> templateMap, boolean withTags, boolean withAttributes, boolean withTemplate, boolean withAliasForcete) throws MetadataException {
        if (patternTree.isContainWildcard()) {
            ClusterSchemaTree schemaTree = new ClusterSchemaTree();
            for (PartialPath path : patternTree.getAllPathPatterns()) {
                schemaTree.mergeSchemaTree(this.mtree.fetchSchema(path, templateMap, withTags, withAttributes, withTemplate, withAliasForcete));
            }
            return schemaTree;
        }
        return this.mtree.fetchSchemaWithoutWildcard(patternTree, templateMap, withTags, withAttributes, withTemplate);
    }

    @Override
    public ClusterSchemaTree fetchDeviceSchema(PathPatternTree patternTree, PathPatternTree authorityScope) throws MetadataException {
        return this.mtree.fetchDeviceSchema(patternTree, authorityScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeOffset(PartialPath path, long offset) throws MetadataException {
        block6: {
            IMeasurementMNode<ICachedMNode> measurementMNode = this.mtree.getMeasurementMNode(path);
            try {
                this.mtree.updateMNode((ICachedMNode)measurementMNode.getAsMNode(), o -> o.getAsMeasurementMNode().setOffset(offset));
                if (!this.isRecovering) break block6;
                try {
                    if (this.tagManager.recoverIndex(offset, measurementMNode)) {
                        this.mtree.pinMNode((ICachedMNode)measurementMNode.getAsMNode());
                    }
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
            finally {
                this.mtree.unPinMNode((ICachedMNode)measurementMNode.getAsMNode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upsertAliasAndTagsAndAttributes(String alias, Map<String, String> tagsMap, Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        this.upsertAlias(alias, fullPath);
        while (tagsMap != null && !this.regionStatistics.isAllowToCreateNewSeries()) {
            ReleaseFlushMonitor.getInstance().waitIfReleasing();
        }
        IMeasurementMNode<ICachedMNode> leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (tagsMap == null && attributesMap == null) {
                return;
            }
            if (leafMNode.getOffset() < 0L) {
                long offset = this.tagManager.writeTagFile(tagsMap, attributesMap);
                this.writeToMLog(SchemaRegionWritePlanFactory.getChangeTagOffsetPlan(fullPath, offset));
                this.mtree.updateMNode((ICachedMNode)leafMNode.getAsMNode(), o -> o.getAsMeasurementMNode().setOffset(offset));
                if (tagsMap != null && !tagsMap.isEmpty()) {
                    this.tagManager.addIndex(tagsMap, leafMNode);
                    this.mtree.pinMNode((ICachedMNode)leafMNode.getAsMNode());
                }
                return;
            }
            this.tagManager.updateTagsAndAttributes(tagsMap, attributesMap, leafMNode);
        }
        finally {
            this.mtree.unPinMNode((ICachedMNode)leafMNode.getAsMNode());
        }
    }

    private void upsertAlias(String alias, PartialPath fullPath) throws MetadataException, IOException {
        if (alias != null) {
            while (!this.regionStatistics.isAllowToCreateNewSeries()) {
                ReleaseFlushMonitor.getInstance().waitIfReleasing();
            }
            if (this.mtree.changeAlias(alias, fullPath)) {
                this.writeToMLog(SchemaRegionWritePlanFactory.getChangeAliasPlan(fullPath, alias));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAttributes(Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode<ICachedMNode> leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (leafMNode.getOffset() < 0L) {
                long offset = this.tagManager.writeTagFile(Collections.emptyMap(), attributesMap);
                this.writeToMLog(SchemaRegionWritePlanFactory.getChangeTagOffsetPlan(fullPath, offset));
                this.mtree.updateMNode((ICachedMNode)leafMNode.getAsMNode(), o -> o.getAsMeasurementMNode().setOffset(offset));
                return;
            }
            this.tagManager.addAttributes(attributesMap, fullPath, leafMNode);
        }
        finally {
            this.mtree.unPinMNode((ICachedMNode)leafMNode.getAsMNode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTags(Map<String, String> tagsMap, PartialPath fullPath) throws MetadataException, IOException {
        while (!this.regionStatistics.isAllowToCreateNewSeries()) {
            ReleaseFlushMonitor.getInstance().waitIfReleasing();
        }
        IMeasurementMNode<ICachedMNode> leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (leafMNode.getOffset() < 0L) {
                long offset = this.tagManager.writeTagFile(tagsMap, Collections.emptyMap());
                this.writeToMLog(SchemaRegionWritePlanFactory.getChangeTagOffsetPlan(fullPath, offset));
                this.mtree.updateMNode((ICachedMNode)leafMNode.getAsMNode(), o -> o.getAsMeasurementMNode().setOffset(offset));
                this.tagManager.addIndex(tagsMap, leafMNode);
                this.mtree.pinMNode((ICachedMNode)leafMNode.getAsMNode());
                return;
            }
            this.tagManager.addTags(tagsMap, fullPath, leafMNode);
        }
        finally {
            this.mtree.unPinMNode((ICachedMNode)leafMNode.getAsMNode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTagsOrAttributes(Set<String> keySet, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode<ICachedMNode> leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (leafMNode.getOffset() != -1L) {
                this.tagManager.dropTagsOrAttributes(keySet, fullPath, leafMNode);
                this.mtree.unPinMNode((ICachedMNode)leafMNode.getAsMNode());
            }
        }
        finally {
            this.mtree.unPinMNode((ICachedMNode)leafMNode.getAsMNode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTagsOrAttributesValue(Map<String, String> alterMap, PartialPath fullPath) throws MetadataException, IOException {
        while (!this.regionStatistics.isAllowToCreateNewSeries()) {
            ReleaseFlushMonitor.getInstance().waitIfReleasing();
        }
        IMeasurementMNode<ICachedMNode> leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (leafMNode.getOffset() < 0L) {
                throw new MetadataException(String.format("TimeSeries [%s] does not have any tag/attribute.", fullPath));
            }
            this.tagManager.setTagsOrAttributesValue(alterMap, fullPath, leafMNode);
        }
        finally {
            this.mtree.unPinMNode((ICachedMNode)leafMNode.getAsMNode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameTagOrAttributeKey(String oldKey, String newKey, PartialPath fullPath) throws MetadataException, IOException {
        while (!this.regionStatistics.isAllowToCreateNewSeries()) {
            ReleaseFlushMonitor.getInstance().waitIfReleasing();
        }
        IMeasurementMNode<ICachedMNode> leafMNode = this.mtree.getMeasurementMNode(fullPath);
        try {
            if (leafMNode.getOffset() < 0L) {
                throw new MetadataException(String.format("TimeSeries [%s] does not have [%s] tag/attribute.", fullPath, oldKey), true);
            }
            this.tagManager.renameTagOrAttributeKey(oldKey, newKey, fullPath, leafMNode);
        }
        finally {
            this.mtree.unPinMNode((ICachedMNode)leafMNode.getAsMNode());
        }
    }

    private void removeFromTagInvertedIndex(IMeasurementMNode<ICachedMNode> node) throws IOException {
        this.tagManager.removeFromTagInvertedIndex(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateSchemaTemplate(IActivateTemplateInClusterPlan plan, Template template) throws MetadataException {
        while (!this.regionStatistics.isAllowToCreateNewSeries()) {
            ReleaseFlushMonitor.getInstance().waitIfReleasing();
        }
        try {
            ICachedMNode deviceNode = this.getDeviceNodeWithAutoCreate(plan.getActivatePath());
            try {
                plan.setAligned(template.isDirectAligned());
                this.mtree.activateTemplate(plan.getActivatePath(), template);
                this.writeToMLog(plan);
            }
            finally {
                this.mtree.unPinMNode(deviceNode);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new MetadataException((Throwable)e);
        }
    }

    private void recoverActivatingSchemaTemplate(IActivateTemplateInClusterPlan plan) throws MetadataException {
        this.mtree.activateTemplateWithoutCheck(plan.getActivatePath(), plan.getTemplateId(), plan.isAligned());
    }

    @Override
    public long constructSchemaBlackListWithTemplate(IPreDeactivateTemplatePlan plan) throws MetadataException {
        Map<PartialPath, List<Integer>> resultTemplateSetInfo = this.mtree.constructSchemaBlackListWithTemplate(plan.getTemplateSetInfo());
        try {
            this.writeToMLog(SchemaRegionWritePlanFactory.getPreDeactivateTemplatePlan(resultTemplateSetInfo));
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
        return resultTemplateSetInfo.size();
    }

    @Override
    public void rollbackSchemaBlackListWithTemplate(IRollbackPreDeactivateTemplatePlan plan) throws MetadataException {
        Map<PartialPath, List<Integer>> resultTemplateSetInfo = this.mtree.rollbackSchemaBlackListWithTemplate(plan.getTemplateSetInfo());
        try {
            this.writeToMLog(SchemaRegionWritePlanFactory.getRollbackPreDeactivateTemplatePlan(resultTemplateSetInfo));
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public void deactivateTemplateInBlackList(IDeactivateTemplatePlan plan) throws MetadataException {
        Map<PartialPath, List<Integer>> resultTemplateSetInfo = this.mtree.deactivateTemplateInBlackList(plan.getTemplateSetInfo());
        try {
            this.writeToMLog(SchemaRegionWritePlanFactory.getDeactivateTemplatePlan(resultTemplateSetInfo));
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public long countPathsUsingTemplate(int templateId, PathPatternTree patternTree) throws MetadataException {
        long result = 0L;
        for (PartialPath pathPattern : patternTree.getAllPathPatterns()) {
            result += this.mtree.countPathsUsingTemplate(pathPattern, templateId);
        }
        return result;
    }

    @Override
    public int fillLastQueryMap(PartialPath pattern, Map<PartialPath, Map<String, TimeValuePair>> mapToFill) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ISchemaReader<IDeviceSchemaInfo> getDeviceReader(IShowDevicesPlan showDevicesPlan) throws MetadataException {
        return this.mtree.getDeviceReader(showDevicesPlan);
    }

    @Override
    public ISchemaReader<ITimeSeriesSchemaInfo> getTimeSeriesReader(IShowTimeSeriesPlan showTimeSeriesPlan) throws MetadataException {
        if (showTimeSeriesPlan.getSchemaFilter() != null && new FilterContainsVisitor().process(showTimeSeriesPlan.getSchemaFilter(), SchemaFilterType.TAGS_FILTER)) {
            return this.tagManager.getTimeSeriesReaderWithIndex(showTimeSeriesPlan);
        }
        return this.mtree.getTimeSeriesReader(showTimeSeriesPlan, offset -> {
            try {
                return this.tagManager.readTagFile((long)offset);
            }
            catch (IOException e) {
                logger.error("Failed to read tag and attribute info because {}", (Object)e.getMessage(), (Object)e);
                return new Pair(Collections.emptyMap(), Collections.emptyMap());
            }
        });
    }

    @Override
    public ISchemaReader<INodeSchemaInfo> getNodeReader(IShowNodesPlan showNodesPlan) throws MetadataException {
        return this.mtree.getNodeReader(showNodesPlan);
    }

    private class RecoverPlanOperator
    extends SchemaRegionPlanVisitor<RecoverOperationResult, SchemaRegionPBTreeImpl> {
        private RecoverPlanOperator() {
        }

        @Override
        public RecoverOperationResult visitSchemaRegionPlan(ISchemaRegionPlan plan, SchemaRegionPBTreeImpl context) {
            throw new UnsupportedOperationException(String.format("SchemaRegionPlan of type %s doesn't support recover operation in SchemaRegionPBTreeImpl.", plan.getPlanType().name()));
        }

        @Override
        public RecoverOperationResult visitCreateTimeSeries(ICreateTimeSeriesPlan createTimeSeriesPlan, SchemaRegionPBTreeImpl context) {
            try {
                SchemaRegionPBTreeImpl.this.recoverTimeSeries(createTimeSeriesPlan, createTimeSeriesPlan.getTagOffset());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitCreateAlignedTimeSeries(ICreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan, SchemaRegionPBTreeImpl context) {
            try {
                SchemaRegionPBTreeImpl.this.recoverAlignedTimeSeries(createAlignedTimeSeriesPlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitDeleteTimeSeries(IDeleteTimeSeriesPlan deleteTimeSeriesPlan, SchemaRegionPBTreeImpl context) {
            try {
                SchemaRegionPBTreeImpl.this.deleteOneTimeseriesUpdateStatistics(deleteTimeSeriesPlan.getDeletePathList().get(0));
                return RecoverOperationResult.SUCCESS;
            }
            catch (IOException | MetadataException e) {
                return new RecoverOperationResult((Exception)e);
            }
        }

        @Override
        public RecoverOperationResult visitChangeAlias(IChangeAliasPlan changeAliasPlan, SchemaRegionPBTreeImpl context) {
            try {
                SchemaRegionPBTreeImpl.this.upsertAlias(changeAliasPlan.getAlias(), changeAliasPlan.getPath());
                return RecoverOperationResult.SUCCESS;
            }
            catch (IOException | MetadataException e) {
                return new RecoverOperationResult((Exception)e);
            }
        }

        @Override
        public RecoverOperationResult visitChangeTagOffset(IChangeTagOffsetPlan changeTagOffsetPlan, SchemaRegionPBTreeImpl context) {
            try {
                SchemaRegionPBTreeImpl.this.changeOffset(changeTagOffsetPlan.getPath(), changeTagOffsetPlan.getOffset());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitAutoCreateDeviceMNode(IAutoCreateDeviceMNodePlan autoCreateDeviceMNodePlan, SchemaRegionPBTreeImpl context) {
            try {
                SchemaRegionPBTreeImpl.this.autoCreateDeviceMNode(autoCreateDeviceMNodePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitActivateTemplateInCluster(IActivateTemplateInClusterPlan activateTemplateInClusterPlan, SchemaRegionPBTreeImpl context) {
            try {
                SchemaRegionPBTreeImpl.this.recoverActivatingSchemaTemplate(activateTemplateInClusterPlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitPreDeleteTimeSeries(IPreDeleteTimeSeriesPlan preDeleteTimeSeriesPlan, SchemaRegionPBTreeImpl context) {
            try {
                SchemaRegionPBTreeImpl.this.recoverPreDeleteTimeseries(preDeleteTimeSeriesPlan.getPath());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitRollbackPreDeleteTimeSeries(IRollbackPreDeleteTimeSeriesPlan rollbackPreDeleteTimeSeriesPlan, SchemaRegionPBTreeImpl context) {
            try {
                SchemaRegionPBTreeImpl.this.recoverRollbackPreDeleteTimeseries(rollbackPreDeleteTimeSeriesPlan.getPath());
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitPreDeactivateTemplate(IPreDeactivateTemplatePlan preDeactivateTemplatePlan, SchemaRegionPBTreeImpl context) {
            try {
                SchemaRegionPBTreeImpl.this.constructSchemaBlackListWithTemplate(preDeactivateTemplatePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitRollbackPreDeactivateTemplate(IRollbackPreDeactivateTemplatePlan rollbackPreDeactivateTemplatePlan, SchemaRegionPBTreeImpl context) {
            try {
                SchemaRegionPBTreeImpl.this.rollbackSchemaBlackListWithTemplate(rollbackPreDeactivateTemplatePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }

        @Override
        public RecoverOperationResult visitDeactivateTemplate(IDeactivateTemplatePlan deactivateTemplatePlan, SchemaRegionPBTreeImpl context) {
            try {
                SchemaRegionPBTreeImpl.this.deactivateTemplateInBlackList(deactivateTemplatePlan);
                return RecoverOperationResult.SUCCESS;
            }
            catch (MetadataException e) {
                return new RecoverOperationResult((Exception)((Object)e));
            }
        }
    }

    private static class RecoverOperationResult {
        private static final RecoverOperationResult SUCCESS = new RecoverOperationResult(null);
        private final Exception e;

        private RecoverOperationResult(Exception e) {
            this.e = e;
        }

        private boolean isFailed() {
            return this.e != null;
        }

        private Exception getException() {
            return this.e;
        }
    }
}

