/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.coordinator.task;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.consensus.request.read.pipe.task.ShowPipePlanV2;
import org.apache.iotdb.confignode.consensus.response.pipe.task.PipeTableResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.pipe.coordinator.task.PipeTaskCoordinatorLock;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.confignode.rpc.thrift.TAlterPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllPipeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTaskCoordinator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTaskCoordinator.class);
    private final ConfigManager configManager;
    private final PipeTaskInfo pipeTaskInfo;
    private final PipeTaskCoordinatorLock pipeTaskCoordinatorLock;

    public PipeTaskCoordinator(ConfigManager configManager, PipeTaskInfo pipeTaskInfo) {
        this.configManager = configManager;
        this.pipeTaskInfo = pipeTaskInfo;
        this.pipeTaskCoordinatorLock = new PipeTaskCoordinatorLock();
    }

    public AtomicReference<PipeTaskInfo> tryLock() {
        return this.pipeTaskCoordinatorLock.tryLock() ? new AtomicReference<PipeTaskInfo>(this.pipeTaskInfo) : null;
    }

    public AtomicReference<PipeTaskInfo> lock() {
        this.pipeTaskCoordinatorLock.lock();
        return new AtomicReference<PipeTaskInfo>(this.pipeTaskInfo);
    }

    public boolean unlock() {
        try {
            this.pipeTaskCoordinatorLock.unlock();
            return true;
        }
        catch (IllegalMonitorStateException ignored) {
            LOGGER.warn("This thread is not holding the lock.");
            return false;
        }
    }

    public boolean isLocked() {
        return this.pipeTaskCoordinatorLock.isLocked();
    }

    public TSStatus createPipe(TCreatePipeReq req) {
        TSStatus status = this.configManager.getProcedureManager().createPipe(req);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to create pipe {}. Result status: {}.", (Object)req.getPipeName(), (Object)status);
        }
        return status;
    }

    public TSStatus alterPipe(TAlterPipeReq req) {
        TSStatus status = this.configManager.getProcedureManager().alterPipe(req);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to alter pipe {}. Result status: {}.", (Object)req.getPipeName(), (Object)status);
        }
        return status;
    }

    public TSStatus startPipe(String pipeName) {
        TSStatus status = this.configManager.getProcedureManager().startPipe(pipeName);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to start pipe {}. Result status: {}.", (Object)pipeName, (Object)status);
        }
        return status;
    }

    public TSStatus stopPipe(String pipeName) {
        boolean isStoppedByRuntimeException = this.pipeTaskInfo.isStoppedByRuntimeException(pipeName);
        TSStatus status = this.configManager.getProcedureManager().stopPipe(pipeName);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            if (isStoppedByRuntimeException) {
                LOGGER.info("Pipe {} has stopped manually, stop its auto restart process.", (Object)pipeName);
                this.pipeTaskInfo.setIsStoppedByRuntimeExceptionToFalse(pipeName);
                this.configManager.getProcedureManager().pipeHandleMetaChange(true, false);
            }
        } else {
            LOGGER.warn("Failed to stop pipe {}. Result status: {}.", (Object)pipeName, (Object)status);
        }
        return status;
    }

    public TSStatus dropPipe(TDropPipeReq req) {
        String pipeName = req.getPipeName();
        boolean isPipeExistedBeforeDrop = this.pipeTaskInfo.isPipeExisted(pipeName);
        TSStatus status = this.configManager.getProcedureManager().dropPipe(pipeName);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to drop pipe {}. Result status: {}.", (Object)pipeName, (Object)status);
        }
        boolean isSetIfExistsCondition = req.isSetIfExistsCondition() && req.isIfExistsCondition();
        return isPipeExistedBeforeDrop || isSetIfExistsCondition ? status : RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_NOT_EXIST_ERROR, (String)String.format("Failed to drop pipe %s. Failures: %s does not exist.", pipeName, pipeName));
    }

    public TShowPipeResp showPipes(TShowPipeReq req) {
        try {
            return ((PipeTableResp)this.configManager.getConsensusManager().read(new ShowPipePlanV2())).filter(req.whereClause, req.pipeName).convertToTShowPipeResp();
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the read API executing the consensus layer due to: ", (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new PipeTableResp(res, Collections.emptyList()).convertToTShowPipeResp();
        }
    }

    public TGetAllPipeInfoResp getAllPipeInfo() {
        try {
            return ((PipeTableResp)this.configManager.getConsensusManager().read(new ShowPipePlanV2())).convertToTGetAllPipeInfoResp();
        }
        catch (IOException | ConsensusException e) {
            LOGGER.warn("Failed to get all pipe info.", e);
            return new TGetAllPipeInfoResp(new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList());
        }
    }

    public boolean hasAnyPipe() {
        return !this.pipeTaskInfo.isEmpty();
    }

    public void updateLastSyncedVersion() {
        this.pipeTaskInfo.updateLastSyncedVersion();
    }

    public boolean canSkipNextSync() {
        return this.pipeTaskInfo.canSkipNextSync();
    }

    public long runningPipeCount() {
        return this.pipeTaskInfo.runningPipeCount();
    }

    public long droppedPipeCount() {
        return this.pipeTaskInfo.droppedPipeCount();
    }

    public long userStoppedPipeCount() {
        return this.pipeTaskInfo.userStoppedPipeCount();
    }

    public long exceptionStoppedPipeCount() {
        return this.pipeTaskInfo.exceptionStoppedPipeCount();
    }
}

