/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.coordinator.task;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTaskCoordinatorLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTaskCoordinatorLock.class);
    private final ReentrantLock lock = new ReentrantLock();

    public void lock() {
        LOGGER.debug("PipeTaskCoordinator lock waiting for thread {}", (Object)Thread.currentThread().getName());
        try {
            this.lock.lockInterruptibly();
            LOGGER.debug("PipeTaskCoordinator lock acquired by thread {}", (Object)Thread.currentThread().getName());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Interrupted while waiting for PipeTaskCoordinator lock, current thread: {}", (Object)Thread.currentThread().getName());
        }
    }

    public boolean tryLock() {
        try {
            LOGGER.debug("PipeTaskCoordinator lock waiting for thread {}", (Object)Thread.currentThread().getName());
            if (this.lock.tryLock(10L, TimeUnit.SECONDS)) {
                LOGGER.debug("PipeTaskCoordinator lock acquired by thread {}", (Object)Thread.currentThread().getName());
                return true;
            }
            LOGGER.info("PipeTaskCoordinator lock failed to acquire by thread {} because of timeout", (Object)Thread.currentThread().getName());
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Interrupted while waiting for PipeTaskCoordinator lock, current thread: {}", (Object)Thread.currentThread().getName());
            return false;
        }
    }

    public void unlock() {
        this.lock.unlock();
        LOGGER.debug("PipeTaskCoordinator lock released by thread {}", (Object)Thread.currentThread().getName());
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }
}

