/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure;

import java.util.List;
import java.util.TreeMap;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.partition.AutoCleanPartitionTablePlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.procedure.InternalProcedure;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionTableAutoCleaner<Env>
extends InternalProcedure<Env> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionTableAutoCleaner.class);
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final String timestampPrecision = CommonDescriptor.getInstance().getConfig().getTimestampPrecision();
    private final ConfigManager configManager;

    public PartitionTableAutoCleaner(ConfigManager configManager) {
        super(COMMON_CONFIG.getTTLCheckInterval());
        this.configManager = configManager;
        LOGGER.info("[PartitionTableCleaner] The PartitionTableAutoCleaner is started with cycle={}ms", (Object)COMMON_CONFIG.getTTLCheckInterval());
    }

    @Override
    protected void periodicExecute(Env env) {
        long databaseTTL;
        List<String> databases = this.configManager.getClusterSchemaManager().getDatabaseNames();
        TreeMap<String, Long> databaseTTLMap = new TreeMap<String, Long>();
        for (String database : databases) {
            databaseTTL = this.configManager.getTTLManager().getDatabaseLevelTTL(database);
            if (0L < databaseTTL && databaseTTL < Long.MAX_VALUE) {
                databaseTTL = this.configManager.getTTLManager().getDatabaseMaxTTL(database);
            }
            databaseTTLMap.put(database, databaseTTL);
        }
        LOGGER.info("[PartitionTableCleaner] Periodically activate PartitionTableAutoCleaner, databaseTTL: {}", databaseTTLMap);
        for (String database : databases) {
            databaseTTL = (Long)databaseTTLMap.get(database);
            if (this.configManager.getPartitionManager().isDatabaseExist(database) && databaseTTL >= 0L && databaseTTL != Long.MAX_VALUE) continue;
            databaseTTLMap.remove(database);
        }
        if (!databaseTTLMap.isEmpty()) {
            LOGGER.info("[PartitionTableCleaner] Periodically activate PartitionTableAutoCleaner for: {}", databaseTTLMap);
            TTimePartitionSlot currentTimePartitionSlot = PartitionTableAutoCleaner.getCurrentTimePartitionSlot();
            try {
                this.configManager.getConsensusManager().write(new AutoCleanPartitionTablePlan(databaseTTLMap, currentTimePartitionSlot));
            }
            catch (ConsensusException e) {
                LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            }
        }
    }

    private static TTimePartitionSlot getCurrentTimePartitionSlot() {
        if ("ms".equals(timestampPrecision)) {
            return new TTimePartitionSlot(System.currentTimeMillis());
        }
        if ("us".equals(timestampPrecision)) {
            return new TTimePartitionSlot(System.currentTimeMillis() * 1000L);
        }
        return new TTimePartitionSlot(System.currentTimeMillis() * 1000000L);
    }
}

