/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.pattern;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePatternOperations;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class IoTDBPipePattern
extends IoTDBPipePatternOperations {
    private final String pattern;
    private final PartialPath patternPartialPath;
    private static volatile DevicePathGetter devicePathGetter = PartialPath::new;
    private static volatile MeasurementPathGetter measurementPathGetter = PartialPath::new;

    public IoTDBPipePattern(String pattern) {
        this.pattern = pattern != null ? pattern : this.getDefaultPattern();
        try {
            this.patternPartialPath = new PartialPath(this.getPattern());
        }
        catch (IllegalPathException e) {
            throw new PipeException("Illegal IoTDBPipePattern: " + this.getPattern(), (Throwable)e);
        }
    }

    private String getDefaultPattern() {
        return "root.**";
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isRoot() {
        return Objects.isNull(this.pattern) || this.pattern.equals(this.getDefaultPattern());
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean isLegal() {
        if (!this.pattern.startsWith("root")) {
            return false;
        }
        try {
            PathUtils.isLegalPath(this.pattern);
            return true;
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean coversDb(String db) {
        try {
            return this.patternPartialPath.include(new PartialPath(db, "**"));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean coversDevice(String device) {
        try {
            return this.patternPartialPath.include(new PartialPath(device, "*"));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean mayOverlapWithDevice(String device) {
        try {
            return this.patternPartialPath.matchPrefixPath(devicePathGetter.apply(device));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean mayOverlapWithDb(String db) {
        try {
            return this.patternPartialPath.overlapWith(new PartialPath(db + ".**"));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean matchesMeasurement(String device, String measurement) {
        if (Objects.isNull(measurement) || measurement.isEmpty()) {
            return false;
        }
        try {
            return this.patternPartialPath.matchFullPath(measurementPathGetter.apply(device, measurement));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public List<PartialPath> getBaseInclusionPaths() {
        return Collections.singletonList(this.patternPartialPath);
    }

    @Override
    public boolean matchPrefixPath(String path) {
        return this.mayOverlapWithDevice(path);
    }

    @Override
    public boolean matchDevice(String devicePath) {
        try {
            return this.patternPartialPath.overlapWith(new PartialPath(devicePath, "*"));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean matchTailNode(String tailNode) {
        return !this.isFullPath() || this.patternPartialPath.getTailNode().equals(tailNode);
    }

    @Override
    public List<PartialPath> getIntersection(PartialPath partialPath) {
        if (this.isFullPath()) {
            return partialPath.matchFullPath(this.patternPartialPath) ? Collections.singletonList(this.patternPartialPath) : Collections.emptyList();
        }
        return partialPath.intersectWithPrefixPattern(this.patternPartialPath);
    }

    @Override
    public PathPatternTree getIntersection(PathPatternTree patternTree) {
        PathPatternTree thisPatternTree = new PathPatternTree();
        thisPatternTree.appendPathPattern(this.patternPartialPath);
        thisPatternTree.constructTree();
        return patternTree.intersectWithFullPathPrefixTree(thisPatternTree);
    }

    @Override
    public boolean isPrefixOrFullPath() {
        return this.isPrefix() || this.isFullPath();
    }

    @Override
    public boolean mayMatchMultipleTimeSeriesInOneDevice() {
        return PathPatternUtil.hasWildcard(this.patternPartialPath.getTailNode());
    }

    private boolean isPrefix() {
        return PathPatternUtil.isMultiLevelMatchWildcard(this.patternPartialPath.getTailNode()) && !new PartialPath(Arrays.copyOfRange(this.patternPartialPath.getNodes(), 0, this.patternPartialPath.getNodeLength() - 1)).hasWildcard();
    }

    private boolean isFullPath() {
        return !this.patternPartialPath.hasWildcard();
    }

    public static void setDevicePathGetter(DevicePathGetter devicePathGetter) {
        IoTDBPipePattern.devicePathGetter = devicePathGetter;
    }

    public static void setMeasurementPathGetter(MeasurementPathGetter measurementPathGetter) {
        IoTDBPipePattern.measurementPathGetter = measurementPathGetter;
    }

    public String toString() {
        return "IoTDBPipePattern{pattern='" + this.pattern + "'}";
    }

    public static interface DevicePathGetter {
        public PartialPath apply(String var1) throws IllegalPathException;
    }

    public static interface MeasurementPathGetter {
        public PartialPath apply(String var1, String var2) throws IllegalPathException;
    }
}

