/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.pattern;

import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;

public class WithExclusionPipePattern
extends PipePattern {
    private final PipePattern inclusionPattern;
    private final PipePattern exclusionPattern;

    public WithExclusionPipePattern(PipePattern inclusionPattern, PipePattern exclusionPattern) {
        this.inclusionPattern = inclusionPattern;
        this.exclusionPattern = exclusionPattern;
    }

    @Override
    public String getPattern() {
        return "INCLUSION(" + this.inclusionPattern.getPattern() + "), EXCLUSION(" + this.exclusionPattern.getPattern() + ")";
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public boolean isLegal() {
        return this.inclusionPattern.isLegal() && this.exclusionPattern.isLegal();
    }

    @Override
    public boolean coversDb(String db) {
        return this.inclusionPattern.coversDb(db) && !this.exclusionPattern.mayOverlapWithDb(db);
    }

    @Override
    public boolean coversDevice(String device) {
        return this.inclusionPattern.coversDevice(device) && !this.exclusionPattern.mayOverlapWithDevice(device);
    }

    @Override
    public boolean mayOverlapWithDb(String db) {
        return this.inclusionPattern.mayOverlapWithDb(db) && !this.exclusionPattern.coversDb(db);
    }

    @Override
    public boolean mayOverlapWithDevice(String device) {
        return this.inclusionPattern.mayOverlapWithDevice(device) && !this.exclusionPattern.coversDevice(device);
    }

    @Override
    public boolean matchesMeasurement(String device, String measurement) {
        return this.inclusionPattern.matchesMeasurement(device, measurement) && !this.exclusionPattern.matchesMeasurement(device, measurement);
    }

    @Override
    public List<PartialPath> getBaseInclusionPaths() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "ExclusionPipePattern{inclusionPattern=" + this.inclusionPattern + ", exclusionPattern=" + this.exclusionPattern + '}';
    }
}

