/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tablet;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.row.PipeRow;
import org.apache.iotdb.db.pipe.event.common.row.PipeRowCollector;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeTabletCollector;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.collector.TabletCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletInsertionDataContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TabletInsertionDataContainer.class);
    private static final LocalDate EMPTY_LOCALDATE = LocalDate.of(1000, 1, 1);
    private final PipeTaskMeta pipeTaskMeta;
    private final EnrichedEvent sourceEvent;
    private String deviceId;
    private boolean isAligned;
    private MeasurementSchema[] measurementSchemaList;
    private String[] columnNameStringList;
    private long[] timestampColumn;
    private TSDataType[] valueColumnTypes;
    private Object[] valueColumns;
    private BitMap[] nullValueColumnBitmaps;
    private int rowCount;
    private Tablet tablet;
    private boolean shouldReport = false;
    private static final Integer CACHED_FULL_ROW_INDEX_LIST_ROW_COUNT_UPPER = 16;
    private static final Map<Integer, List<Integer>> CACHED_FULL_ROW_INDEX_LIST = new HashMap<Integer, List<Integer>>();

    public TabletInsertionDataContainer(PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent, InsertNode insertNode, PipePattern pattern) {
        this.pipeTaskMeta = pipeTaskMeta;
        this.sourceEvent = sourceEvent;
        if (insertNode instanceof InsertRowNode) {
            this.parse((InsertRowNode)insertNode, pattern);
        } else if (insertNode instanceof InsertTabletNode) {
            this.parse((InsertTabletNode)insertNode, pattern);
        } else {
            throw new UnSupportedDataTypeException(String.format("InsertNode type %s is not supported.", insertNode.getClass().getName()));
        }
    }

    public TabletInsertionDataContainer(PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent, Tablet tablet, boolean isAligned, PipePattern pattern) {
        this.pipeTaskMeta = pipeTaskMeta;
        this.sourceEvent = sourceEvent;
        this.parse(tablet, isAligned, pattern);
    }

    public TabletInsertionDataContainer(InsertNode insertNode, PipePattern pattern) {
        this(null, null, insertNode, pattern);
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public void markAsNeedToReport() {
        this.shouldReport = true;
    }

    private void parse(InsertRowNode insertRowNode, PipePattern pattern) {
        int originColumnSize = insertRowNode.getMeasurements().length;
        Integer[] originColumnIndex2FilteredColumnIndexMapperList = new Integer[originColumnSize];
        this.deviceId = insertRowNode.getDevicePath().getFullPath();
        this.isAligned = insertRowNode.isAligned();
        long[] originTimestampColumn = new long[]{insertRowNode.getTime()};
        List<Integer> rowIndexList = this.generateRowIndexList(originTimestampColumn);
        this.timestampColumn = rowIndexList.stream().mapToLong(i -> originTimestampColumn[i]).toArray();
        this.generateColumnIndexMapper(insertRowNode.getMeasurements(), pattern, originColumnIndex2FilteredColumnIndexMapperList);
        int filteredColumnSize = Arrays.stream(originColumnIndex2FilteredColumnIndexMapperList).filter(Objects::nonNull).toArray().length;
        this.measurementSchemaList = new MeasurementSchema[filteredColumnSize];
        this.columnNameStringList = new String[filteredColumnSize];
        this.valueColumnTypes = new TSDataType[filteredColumnSize];
        this.valueColumns = new Object[filteredColumnSize];
        this.nullValueColumnBitmaps = new BitMap[filteredColumnSize];
        MeasurementSchema[] originMeasurementSchemaList = insertRowNode.getMeasurementSchemas();
        String[] originColumnNameStringList = insertRowNode.getMeasurements();
        TSDataType[] originValueColumnTypes = insertRowNode.getDataTypes();
        Object[] originValueColumns = insertRowNode.getValues();
        for (int i2 = 0; i2 < originColumnIndex2FilteredColumnIndexMapperList.length; ++i2) {
            if (originColumnIndex2FilteredColumnIndexMapperList[i2] == null) continue;
            int filteredColumnIndex = originColumnIndex2FilteredColumnIndexMapperList[i2];
            this.measurementSchemaList[filteredColumnIndex] = originMeasurementSchemaList[i2];
            this.columnNameStringList[filteredColumnIndex] = originColumnNameStringList[i2];
            this.valueColumnTypes[filteredColumnIndex] = originValueColumnTypes[i2];
            BitMap bitMap = new BitMap(this.timestampColumn.length);
            if (Objects.isNull(originValueColumns[i2]) || Objects.isNull(originValueColumnTypes[i2])) {
                this.fillNullValue(originValueColumnTypes[i2], this.valueColumns, bitMap, filteredColumnIndex, rowIndexList.size());
            } else {
                this.valueColumns[filteredColumnIndex] = TabletInsertionDataContainer.filterValueColumnsByRowIndexList(originValueColumnTypes[i2], originValueColumns[i2], rowIndexList, true, bitMap, bitMap);
            }
            this.nullValueColumnBitmaps[filteredColumnIndex] = bitMap;
        }
        this.rowCount = this.timestampColumn.length;
        if (this.rowCount == 0 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("InsertRowNode({}) is parsed to zero rows according to the pattern({}) and time range [{}, {}], the corresponding source event({}) will be ignored.", new Object[]{insertRowNode, pattern, this.sourceEvent.getStartTime(), this.sourceEvent.getEndTime(), this.sourceEvent});
        }
    }

    private void parse(InsertTabletNode insertTabletNode, PipePattern pattern) {
        int i2;
        int originColumnSize = insertTabletNode.getMeasurements().length;
        Integer[] originColumnIndex2FilteredColumnIndexMapperList = new Integer[originColumnSize];
        this.deviceId = insertTabletNode.getDevicePath().getFullPath();
        this.isAligned = insertTabletNode.isAligned();
        long[] originTimestampColumn = insertTabletNode.getTimes();
        int originRowSize = originTimestampColumn.length;
        List<Integer> rowIndexList = this.generateRowIndexList(originTimestampColumn);
        this.timestampColumn = rowIndexList.stream().mapToLong(i -> originTimestampColumn[i]).toArray();
        this.generateColumnIndexMapper(insertTabletNode.getMeasurements(), pattern, originColumnIndex2FilteredColumnIndexMapperList);
        int filteredColumnSize = Arrays.stream(originColumnIndex2FilteredColumnIndexMapperList).filter(Objects::nonNull).toArray().length;
        this.measurementSchemaList = new MeasurementSchema[filteredColumnSize];
        this.columnNameStringList = new String[filteredColumnSize];
        this.valueColumnTypes = new TSDataType[filteredColumnSize];
        this.valueColumns = new Object[filteredColumnSize];
        this.nullValueColumnBitmaps = new BitMap[filteredColumnSize];
        MeasurementSchema[] originMeasurementSchemaList = insertTabletNode.getMeasurementSchemas();
        String[] originColumnNameStringList = insertTabletNode.getMeasurements();
        TSDataType[] originValueColumnTypes = insertTabletNode.getDataTypes();
        Object[] originValueColumns = insertTabletNode.getColumns();
        BitMap[] originBitMapList = insertTabletNode.getBitMaps() == null ? (BitMap[])IntStream.range(0, originColumnSize).boxed().map(o -> new BitMap(originRowSize)).toArray(BitMap[]::new) : insertTabletNode.getBitMaps();
        for (i2 = 0; i2 < originBitMapList.length; ++i2) {
            if (originBitMapList[i2] != null) continue;
            originBitMapList[i2] = new BitMap(originRowSize);
        }
        for (i2 = 0; i2 < originColumnIndex2FilteredColumnIndexMapperList.length; ++i2) {
            if (originColumnIndex2FilteredColumnIndexMapperList[i2] == null) continue;
            int filteredColumnIndex = originColumnIndex2FilteredColumnIndexMapperList[i2];
            this.measurementSchemaList[filteredColumnIndex] = originMeasurementSchemaList[i2];
            this.columnNameStringList[filteredColumnIndex] = originColumnNameStringList[i2];
            this.valueColumnTypes[filteredColumnIndex] = originValueColumnTypes[i2];
            BitMap bitMap = new BitMap(this.timestampColumn.length);
            if (Objects.isNull(originValueColumns[i2]) || Objects.isNull(originValueColumnTypes[i2])) {
                this.fillNullValue(originValueColumnTypes[i2], this.valueColumns, bitMap, filteredColumnIndex, rowIndexList.size());
            } else {
                this.valueColumns[filteredColumnIndex] = TabletInsertionDataContainer.filterValueColumnsByRowIndexList(originValueColumnTypes[i2], originValueColumns[i2], rowIndexList, false, originBitMapList[i2], bitMap);
            }
            this.nullValueColumnBitmaps[filteredColumnIndex] = bitMap;
        }
        this.rowCount = this.timestampColumn.length;
        if (this.rowCount == 0 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("InsertTabletNode({}) is parsed to zero rows according to the pattern({}) and time range [{}, {}], the corresponding source event({}) will be ignored.", new Object[]{insertTabletNode, pattern, this.sourceEvent.getStartTime(), this.sourceEvent.getEndTime(), this.sourceEvent});
        }
    }

    private void parse(Tablet tablet, boolean isAligned, PipePattern pattern) {
        int i2;
        int originColumnSize = tablet.getSchemas().size();
        Integer[] originColumnIndex2FilteredColumnIndexMapperList = new Integer[originColumnSize];
        this.deviceId = tablet.deviceId;
        this.isAligned = isAligned;
        long[] originTimestampColumn = Arrays.copyOf(tablet.timestamps, tablet.rowSize);
        List<Integer> rowIndexList = this.generateRowIndexList(originTimestampColumn);
        this.timestampColumn = rowIndexList.stream().mapToLong(i -> originTimestampColumn[i]).toArray();
        List originMeasurementSchemaList = tablet.getSchemas();
        String[] originMeasurementList = new String[originMeasurementSchemaList.size()];
        for (int i3 = 0; i3 < originMeasurementSchemaList.size(); ++i3) {
            originMeasurementList[i3] = ((MeasurementSchema)originMeasurementSchemaList.get(i3)).getMeasurementId();
        }
        this.generateColumnIndexMapper(originMeasurementList, pattern, originColumnIndex2FilteredColumnIndexMapperList);
        int filteredColumnSize = Arrays.stream(originColumnIndex2FilteredColumnIndexMapperList).filter(Objects::nonNull).toArray().length;
        this.measurementSchemaList = new MeasurementSchema[filteredColumnSize];
        this.columnNameStringList = new String[filteredColumnSize];
        this.valueColumnTypes = new TSDataType[filteredColumnSize];
        this.valueColumns = new Object[filteredColumnSize];
        this.nullValueColumnBitmaps = new BitMap[filteredColumnSize];
        String[] originColumnNameStringList = new String[originColumnSize];
        TSDataType[] originValueColumnTypes = new TSDataType[originColumnSize];
        for (int i4 = 0; i4 < originColumnSize; ++i4) {
            originColumnNameStringList[i4] = ((MeasurementSchema)originMeasurementSchemaList.get(i4)).getMeasurementId();
            originValueColumnTypes[i4] = ((MeasurementSchema)originMeasurementSchemaList.get(i4)).getType();
        }
        Object[] originValueColumns = tablet.values;
        BitMap[] originBitMapList = tablet.bitMaps == null ? (BitMap[])IntStream.range(0, originColumnSize).boxed().map(o -> new BitMap(tablet.getMaxRowNumber())).toArray(BitMap[]::new) : tablet.bitMaps;
        for (i2 = 0; i2 < originBitMapList.length; ++i2) {
            if (originBitMapList[i2] != null) continue;
            originBitMapList[i2] = new BitMap(tablet.getMaxRowNumber());
        }
        for (i2 = 0; i2 < originColumnIndex2FilteredColumnIndexMapperList.length; ++i2) {
            if (originColumnIndex2FilteredColumnIndexMapperList[i2] == null) continue;
            int filteredColumnIndex = originColumnIndex2FilteredColumnIndexMapperList[i2];
            this.measurementSchemaList[filteredColumnIndex] = (MeasurementSchema)originMeasurementSchemaList.get(i2);
            this.columnNameStringList[filteredColumnIndex] = originColumnNameStringList[i2];
            this.valueColumnTypes[filteredColumnIndex] = originValueColumnTypes[i2];
            BitMap bitMap = new BitMap(this.timestampColumn.length);
            if (Objects.isNull(originValueColumns[i2]) || Objects.isNull(originValueColumnTypes[i2])) {
                this.fillNullValue(originValueColumnTypes[i2], this.valueColumns, bitMap, filteredColumnIndex, rowIndexList.size());
            } else {
                this.valueColumns[filteredColumnIndex] = TabletInsertionDataContainer.filterValueColumnsByRowIndexList(originValueColumnTypes[i2], originValueColumns[i2], rowIndexList, false, originBitMapList[i2], bitMap);
            }
            this.nullValueColumnBitmaps[filteredColumnIndex] = bitMap;
        }
        this.rowCount = this.timestampColumn.length;
        if (this.rowCount == 0 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Tablet({}) is parsed to zero rows according to the pattern({}) and time range [{}, {}], the corresponding source event({}) will be ignored.", new Object[]{tablet, pattern, this.sourceEvent.getStartTime(), this.sourceEvent.getEndTime(), this.sourceEvent});
        }
    }

    private void generateColumnIndexMapper(String[] originMeasurementList, PipePattern pattern, Integer[] originColumnIndex2FilteredColumnIndexMapperList) {
        block3: {
            int originColumnSize;
            block2: {
                originColumnSize = originMeasurementList.length;
                if (!Objects.isNull(pattern) && !pattern.isRoot() && !pattern.coversDevice(this.deviceId)) break block2;
                for (int i = 0; i < originColumnSize; ++i) {
                    originColumnIndex2FilteredColumnIndexMapperList[i] = i;
                }
                break block3;
            }
            if (!pattern.mayOverlapWithDevice(this.deviceId)) break block3;
            int filteredCount = 0;
            for (int i = 0; i < originColumnSize; ++i) {
                String measurement = originMeasurementList[i];
                if (measurement == null || !pattern.matchesMeasurement(this.deviceId, measurement)) continue;
                originColumnIndex2FilteredColumnIndexMapperList[i] = filteredCount++;
            }
        }
    }

    private List<Integer> generateRowIndexList(long[] originTimestampColumn) {
        int rowCount = originTimestampColumn.length;
        if (Objects.isNull(this.sourceEvent) || !this.sourceEvent.shouldParseTime()) {
            return TabletInsertionDataContainer.generateFullRowIndexList(rowCount);
        }
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>();
        if (originTimestampColumn[originTimestampColumn.length - 1] < this.sourceEvent.getStartTime() || originTimestampColumn[0] > this.sourceEvent.getEndTime()) {
            return rowIndexList;
        }
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            if (this.sourceEvent.getStartTime() > originTimestampColumn[rowIndex] || originTimestampColumn[rowIndex] > this.sourceEvent.getEndTime()) continue;
            rowIndexList.add(rowIndex);
        }
        return rowIndexList;
    }

    private static List<Integer> generateFullRowIndexList(int rowCount) {
        if (rowCount <= CACHED_FULL_ROW_INDEX_LIST_ROW_COUNT_UPPER) {
            return CACHED_FULL_ROW_INDEX_LIST.get(rowCount);
        }
        return IntStream.range(0, rowCount).boxed().collect(Collectors.toList());
    }

    private static Object filterValueColumnsByRowIndexList(@NonNull TSDataType type, @NonNull Object originValueColumn, @NonNull List<Integer> rowIndexList, boolean isSingleOriginValueColumn, @NonNull BitMap originNullValueColumnBitmap, @NonNull BitMap nullValueColumnBitmap) {
        switch (type) {
            case INT32: {
                int[] nArray;
                if (isSingleOriginValueColumn) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = (Integer)originValueColumn;
                } else {
                    nArray = (int[])originValueColumn;
                }
                int[] intValueColumns = nArray;
                int[] valueColumns = new int[rowIndexList.size()];
                for (int i = 0; i < rowIndexList.size(); ++i) {
                    if (originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                        valueColumns[i] = 0;
                        nullValueColumnBitmap.mark(i);
                        continue;
                    }
                    valueColumns[i] = intValueColumns[rowIndexList.get(i)];
                }
                return valueColumns;
            }
            case DATE: {
                LocalDate[] valueColumns = new LocalDate[rowIndexList.size()];
                if (isSingleOriginValueColumn && originValueColumn instanceof LocalDate || !isSingleOriginValueColumn && originValueColumn instanceof LocalDate[]) {
                    LocalDate[] localDateArray;
                    if (isSingleOriginValueColumn) {
                        LocalDate[] localDateArray2 = new LocalDate[1];
                        localDateArray = localDateArray2;
                        localDateArray2[0] = (LocalDate)originValueColumn;
                    } else {
                        localDateArray = (LocalDate[])originValueColumn;
                    }
                    LocalDate[] dateValueColumns = localDateArray;
                    for (int i = 0; i < rowIndexList.size(); ++i) {
                        if (originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                            valueColumns[i] = EMPTY_LOCALDATE;
                            nullValueColumnBitmap.mark(i);
                            continue;
                        }
                        valueColumns[i] = dateValueColumns[rowIndexList.get(i)];
                    }
                } else {
                    int[] nArray;
                    if (isSingleOriginValueColumn) {
                        int[] nArray3 = new int[1];
                        nArray = nArray3;
                        nArray3[0] = (Integer)originValueColumn;
                    } else {
                        nArray = (int[])originValueColumn;
                    }
                    int[] intValueColumns = nArray;
                    for (int i = 0; i < rowIndexList.size(); ++i) {
                        if (originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                            valueColumns[i] = EMPTY_LOCALDATE;
                            nullValueColumnBitmap.mark(i);
                            continue;
                        }
                        valueColumns[i] = DateUtils.parseIntToLocalDate((int)intValueColumns[rowIndexList.get(i)]);
                    }
                }
                return valueColumns;
            }
            case INT64: 
            case TIMESTAMP: {
                long[] lArray;
                if (isSingleOriginValueColumn) {
                    long[] lArray2 = new long[1];
                    lArray = lArray2;
                    lArray2[0] = (Long)originValueColumn;
                } else {
                    lArray = (long[])originValueColumn;
                }
                long[] longValueColumns = lArray;
                long[] valueColumns = new long[rowIndexList.size()];
                for (int i = 0; i < rowIndexList.size(); ++i) {
                    if (originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                        valueColumns[i] = 0L;
                        nullValueColumnBitmap.mark(i);
                        continue;
                    }
                    valueColumns[i] = longValueColumns[rowIndexList.get(i)];
                }
                return valueColumns;
            }
            case FLOAT: {
                float[] fArray;
                if (isSingleOriginValueColumn) {
                    float[] fArray2 = new float[1];
                    fArray = fArray2;
                    fArray2[0] = ((Float)originValueColumn).floatValue();
                } else {
                    fArray = (float[])originValueColumn;
                }
                float[] floatValueColumns = fArray;
                float[] valueColumns = new float[rowIndexList.size()];
                for (int i = 0; i < rowIndexList.size(); ++i) {
                    if (originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                        valueColumns[i] = 0.0f;
                        nullValueColumnBitmap.mark(i);
                        continue;
                    }
                    valueColumns[i] = floatValueColumns[rowIndexList.get(i)];
                }
                return valueColumns;
            }
            case DOUBLE: {
                double[] dArray;
                if (isSingleOriginValueColumn) {
                    double[] dArray2 = new double[1];
                    dArray = dArray2;
                    dArray2[0] = (Double)originValueColumn;
                } else {
                    dArray = (double[])originValueColumn;
                }
                double[] doubleValueColumns = dArray;
                double[] valueColumns = new double[rowIndexList.size()];
                for (int i = 0; i < rowIndexList.size(); ++i) {
                    if (originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                        valueColumns[i] = 0.0;
                        nullValueColumnBitmap.mark(i);
                        continue;
                    }
                    valueColumns[i] = doubleValueColumns[rowIndexList.get(i)];
                }
                return valueColumns;
            }
            case BOOLEAN: {
                boolean[] blArray;
                if (isSingleOriginValueColumn) {
                    boolean[] blArray2 = new boolean[1];
                    blArray = blArray2;
                    blArray2[0] = (Boolean)originValueColumn;
                } else {
                    blArray = (boolean[])originValueColumn;
                }
                boolean[] booleanValueColumns = blArray;
                boolean[] valueColumns = new boolean[rowIndexList.size()];
                for (int i = 0; i < rowIndexList.size(); ++i) {
                    if (originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                        valueColumns[i] = false;
                        nullValueColumnBitmap.mark(i);
                        continue;
                    }
                    valueColumns[i] = booleanValueColumns[rowIndexList.get(i)];
                }
                return valueColumns;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryArray;
                if (isSingleOriginValueColumn) {
                    Binary[] binaryArray2 = new Binary[1];
                    binaryArray = binaryArray2;
                    binaryArray2[0] = (Binary)originValueColumn;
                } else {
                    binaryArray = (Binary[])originValueColumn;
                }
                Binary[] binaryValueColumns = binaryArray;
                Binary[] valueColumns = new Binary[rowIndexList.size()];
                for (int i = 0; i < rowIndexList.size(); ++i) {
                    if (Objects.isNull(binaryValueColumns[rowIndexList.get(i)]) || Objects.isNull(binaryValueColumns[rowIndexList.get(i)].getValues()) || originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                        valueColumns[i] = Binary.EMPTY_VALUE;
                        nullValueColumnBitmap.mark(i);
                        continue;
                    }
                    valueColumns[i] = new Binary(binaryValueColumns[rowIndexList.get(i)].getValues());
                }
                return valueColumns;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
    }

    private void fillNullValue(TSDataType type, Object[] valueColumns, BitMap nullValueColumnBitmap, int columnIndex, int rowSize) {
        nullValueColumnBitmap.markAll();
        if (Objects.isNull(type)) {
            return;
        }
        switch (type) {
            case INT64: 
            case TIMESTAMP: {
                valueColumns[columnIndex] = new long[rowSize];
                break;
            }
            case INT32: {
                valueColumns[columnIndex] = new int[rowSize];
                break;
            }
            case DOUBLE: {
                valueColumns[columnIndex] = new double[rowSize];
                break;
            }
            case FLOAT: {
                valueColumns[columnIndex] = new float[rowSize];
                break;
            }
            case BOOLEAN: {
                valueColumns[columnIndex] = new boolean[rowSize];
                break;
            }
            case DATE: {
                Object[] dates = new LocalDate[rowSize];
                Arrays.fill(dates, EMPTY_LOCALDATE);
                valueColumns[columnIndex] = dates;
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Object[] columns = new Binary[rowSize];
                Arrays.fill(columns, Binary.EMPTY_VALUE);
                valueColumns[columnIndex] = columns;
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
            }
        }
    }

    public List<TabletInsertionEvent> processRowByRow(BiConsumer<Row, RowCollector> consumer) {
        if (this.valueColumns.length == 0 || this.timestampColumn.length == 0) {
            return Collections.emptyList();
        }
        PipeRowCollector rowCollector = new PipeRowCollector(this.pipeTaskMeta, this.sourceEvent);
        for (int i = 0; i < this.rowCount; ++i) {
            consumer.accept(new PipeRow(i, this.deviceId, this.isAligned, this.measurementSchemaList, this.timestampColumn, this.valueColumnTypes, this.valueColumns, this.nullValueColumnBitmaps, this.columnNameStringList), rowCollector);
        }
        return rowCollector.convertToTabletInsertionEvents(this.shouldReport);
    }

    public List<TabletInsertionEvent> processTablet(BiConsumer<Tablet, RowCollector> consumer) {
        PipeRowCollector rowCollector = new PipeRowCollector(this.pipeTaskMeta, this.sourceEvent);
        consumer.accept(this.convertToTablet(), rowCollector);
        return rowCollector.convertToTabletInsertionEvents(this.shouldReport);
    }

    public List<TabletInsertionEvent> processTabletWithCollect(BiConsumer<Tablet, TabletCollector> consumer) {
        PipeTabletCollector tabletCollector = new PipeTabletCollector(this.pipeTaskMeta, this.sourceEvent);
        consumer.accept(this.convertToTablet(), tabletCollector);
        return tabletCollector.convertToTabletInsertionEvents(this.shouldReport);
    }

    public Tablet convertToTablet() {
        if (this.tablet != null) {
            return this.tablet;
        }
        Tablet newTablet = new Tablet(this.deviceId, Arrays.asList(this.measurementSchemaList), this.rowCount);
        newTablet.timestamps = this.timestampColumn;
        newTablet.bitMaps = this.nullValueColumnBitmaps;
        newTablet.values = this.valueColumns;
        newTablet.rowSize = this.rowCount;
        this.tablet = newTablet;
        return this.tablet;
    }

    static {
        for (int rowCount = 0; rowCount <= CACHED_FULL_ROW_INDEX_LIST_ROW_COUNT_UPPER; ++rowCount) {
            CACHED_FULL_ROW_INDEX_LIST.put(rowCount, IntStream.range(0, rowCount).boxed().collect(Collectors.toList()));
        }
    }
}

