/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeSchemaCacheMetrics;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DeviceCacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.IDeviceSchema;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.ICache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheBuilder;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CachePolicy;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DeviceSchemaCache {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Logger logger = LoggerFactory.getLogger(DeviceSchemaCache.class);
    private final ICache<PartialPath, DeviceCacheEntry> dualKeyCache;
    private final Map<String, String> databasePool = new ConcurrentHashMap<String, String>();
    private final ReentrantLock lock = new ReentrantLock(false);

    DeviceSchemaCache() {
        this.dualKeyCache = new CacheBuilder().cacheEvictionPolicy(CachePolicy.valueOf(config.getDataNodeSchemaCacheEvictionPolicy())).memoryCapacity(config.getAllocateMemoryForSchemaCache()).secondKeySizeComputer(PartialPath::estimateSize).valueSizeComputer(DeviceCacheEntry::estimateSize).build();
        MetricService.getInstance().addMetricSet((IMetricSet)new DataNodeSchemaCacheMetrics(this));
    }

    public TimeValuePair getLastEntry(PartialPath device, String measurement) {
        DeviceCacheEntry entry = this.dualKeyCache.get(device);
        return Objects.nonNull(entry) ? entry.getTimeValuePair(measurement) : null;
    }

    public void invalidateDeviceLastCache(PartialPath device) {
        this.dualKeyCache.update(device, null, entry -> -entry.invalidateLastCache(), false);
    }

    public void putDeviceSchema(String database, DeviceSchemaInfo deviceSchemaInfo) {
        PartialPath devicePath = deviceSchemaInfo.getDevicePath();
        String databaseToUse = this.databasePool.computeIfAbsent(database, k -> database);
        this.dualKeyCache.update(devicePath, new DeviceCacheEntry(), entry -> entry.setDeviceSchema(databaseToUse, deviceSchemaInfo), true);
    }

    public IDeviceSchema getDeviceSchema(PartialPath device) {
        DeviceCacheEntry entry = this.dualKeyCache.get(device);
        return Objects.nonNull(entry) ? entry.getDeviceSchema() : null;
    }

    void updateLastCache(String database, PartialPath device, String[] measurements, @Nullable TimeValuePair[] timeValuePairs, boolean isAligned, IMeasurementSchema[] measurementSchemas, boolean initOrInvalidate) {
        String database2Use = this.databasePool.computeIfAbsent(database, k -> database);
        this.dualKeyCache.update(device, new DeviceCacheEntry(), initOrInvalidate ? entry -> entry.setMeasurementSchema(database2Use, isAligned, measurements, measurementSchemas) + entry.initOrInvalidateLastCache(measurements, Objects.nonNull(timeValuePairs)) : entry -> entry.setMeasurementSchema(database2Use, isAligned, measurements, measurementSchemas) + entry.tryUpdateLastCache(measurements, timeValuePairs), Objects.isNull(timeValuePairs));
    }

    public boolean getLastCache(Map<PartialPath, Map<String, TimeValuePair>> inputMap) {
        return this.dualKeyCache.batchApply(inputMap, DeviceCacheEntry::updateInputMap);
    }

    void invalidateLastCache(PartialPath devicePath, String measurement) {
        ToIntFunction<DeviceCacheEntry> updateFunction;
        ToIntFunction<DeviceCacheEntry> toIntFunction = updateFunction = PathPatternUtil.hasWildcard((String)measurement) ? entry -> -entry.invalidateLastCache() : entry -> -entry.invalidateLastCache(measurement);
        if (!devicePath.hasWildcard()) {
            this.dualKeyCache.update(devicePath, null, updateFunction, false);
        } else {
            this.dualKeyCache.update(cachedDeviceID -> cachedDeviceID.matchFullPath(devicePath), updateFunction);
        }
    }

    void invalidateCache(@Nonnull PartialPath devicePath, boolean isMultiLevelWildcardMeasurement) {
        if (!devicePath.hasWildcard()) {
            this.dualKeyCache.invalidate(devicePath);
        } else {
            this.dualKeyCache.invalidate(cachedDeviceID -> isMultiLevelWildcardMeasurement ? devicePath.matchPrefixPath(cachedDeviceID) : devicePath.matchFullPath(cachedDeviceID));
        }
    }

    long getHitCount() {
        return this.dualKeyCache.stats().hitCount();
    }

    long getRequestCount() {
        return this.dualKeyCache.stats().requestCount();
    }

    public long getMemoryUsage() {
        return this.dualKeyCache.stats().memoryUsage();
    }

    long capacity() {
        return this.dualKeyCache.stats().capacity();
    }

    long entriesCount() {
        return this.dualKeyCache.stats().entriesCount();
    }

    public void invalidateLastCache() {
        this.lock.lock();
        try {
            this.dualKeyCache.update(device -> true, entry -> -entry.invalidateLastCache());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void invalidateSchema() {
        this.lock.lock();
        try {
            this.dualKeyCache.update(device -> true, entry -> -entry.invalidateSchema());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void invalidateAll() {
        this.lock.lock();
        try {
            this.dualKeyCache.invalidateAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

