/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.memory;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.memory.MemoryReservationManager;
import org.apache.tsfile.utils.Pair;

@NotThreadSafe
public class NotThreadSafeMemoryReservationManager
implements MemoryReservationManager {
    private static final long MEMORY_BATCH_THRESHOLD = 0x100000L;
    private final LocalExecutionPlanner LOCAL_EXECUTION_PLANNER = LocalExecutionPlanner.getInstance();
    private final QueryId queryId;
    private final String contextHolder;
    private long reservedBytesInTotal = 0L;
    private long bytesToBeReserved = 0L;
    private long bytesToBeReleased = 0L;

    public NotThreadSafeMemoryReservationManager(QueryId queryId, String contextHolder) {
        this.queryId = queryId;
        this.contextHolder = contextHolder;
    }

    @Override
    public void reserveMemoryCumulatively(long size) {
        this.bytesToBeReserved += size;
        if (this.bytesToBeReserved >= 0x100000L) {
            this.reserveMemoryImmediately();
        }
    }

    @Override
    public void reserveMemoryImmediately() {
        if (this.bytesToBeReserved != 0L) {
            this.LOCAL_EXECUTION_PLANNER.reserveFromFreeMemoryForOperators(this.bytesToBeReserved, this.reservedBytesInTotal, this.queryId.getId(), this.contextHolder);
            this.reservedBytesInTotal += this.bytesToBeReserved;
            this.bytesToBeReserved = 0L;
        }
    }

    @Override
    public void releaseMemoryCumulatively(long size) {
        this.bytesToBeReleased += size;
        if (this.bytesToBeReleased >= 0x100000L) {
            if (this.bytesToBeReleased <= this.bytesToBeReserved) {
                this.bytesToBeReserved -= this.bytesToBeReleased;
            } else {
                long bytesToRelease = this.bytesToBeReleased - this.bytesToBeReserved;
                this.bytesToBeReserved = 0L;
                this.LOCAL_EXECUTION_PLANNER.releaseToFreeMemoryForOperators(bytesToRelease);
                this.reservedBytesInTotal -= bytesToRelease;
            }
            this.bytesToBeReleased = 0L;
        }
    }

    @Override
    public void releaseAllReservedMemory() {
        if (this.reservedBytesInTotal != 0L) {
            this.LOCAL_EXECUTION_PLANNER.releaseToFreeMemoryForOperators(this.reservedBytesInTotal);
            this.reservedBytesInTotal = 0L;
            this.bytesToBeReserved = 0L;
            this.bytesToBeReleased = 0L;
        }
    }

    @Override
    public Pair<Long, Long> releaseMemoryVirtually(long size) {
        if (this.bytesToBeReserved >= size) {
            this.bytesToBeReserved -= size;
            return new Pair((Object)size, (Object)0L);
        }
        long releasedBytesInReserved = this.bytesToBeReserved;
        long releasedBytesInTotal = size - this.bytesToBeReserved;
        this.bytesToBeReserved = 0L;
        this.reservedBytesInTotal -= releasedBytesInTotal;
        return new Pair((Object)releasedBytesInReserved, (Object)releasedBytesInTotal);
    }

    @Override
    public void reserveMemoryVirtually(long bytesToBeReserved, long bytesAlreadyReserved) {
        this.reservedBytesInTotal += bytesAlreadyReserved;
        this.reserveMemoryCumulatively(bytesToBeReserved);
    }
}

