/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.analyze.SelectIntoUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class IntoPathDescriptor {
    private List<Pair<String, PartialPath>> sourceTargetPathPairList;
    private final List<String> sourceColumnToViewList;
    private final Map<String, Boolean> targetDeviceToAlignedMap;
    private Map<String, TSDataType> sourceToDataTypeMap;

    public IntoPathDescriptor() {
        this.sourceTargetPathPairList = new ArrayList<Pair<String, PartialPath>>();
        this.sourceColumnToViewList = new ArrayList<String>();
        this.targetDeviceToAlignedMap = new HashMap<String, Boolean>();
        this.sourceToDataTypeMap = new HashMap<String, TSDataType>();
    }

    public IntoPathDescriptor(List<Pair<String, PartialPath>> sourceTargetPathPairList, List<String> sourceColumnToViewList, Map<String, Boolean> targetDeviceToAlignedMap) {
        this.sourceTargetPathPairList = sourceTargetPathPairList;
        this.sourceColumnToViewList = sourceColumnToViewList;
        this.targetDeviceToAlignedMap = targetDeviceToAlignedMap;
    }

    public void specifyTargetPath(String sourceColumn, String sourceViewPath, PartialPath targetPath) {
        this.sourceTargetPathPairList.add((Pair<String, PartialPath>)new Pair((Object)sourceColumn, (Object)targetPath));
        this.sourceColumnToViewList.add(sourceViewPath == null ? "" : sourceViewPath);
    }

    public void specifyDeviceAlignment(String targetDevice, boolean isAligned) {
        if (this.targetDeviceToAlignedMap.containsKey(targetDevice) && this.targetDeviceToAlignedMap.get(targetDevice) != isAligned) {
            throw new SemanticException("select into: alignment property must be the same for the same device.");
        }
        this.targetDeviceToAlignedMap.put(targetDevice, isAligned);
    }

    public void recordSourceColumnDataType(String sourceColumn, TSDataType dataType) {
        this.sourceToDataTypeMap.put(sourceColumn, dataType);
    }

    public void validate() {
        List targetPaths = this.sourceTargetPathPairList.stream().map(Pair::getRight).collect(Collectors.toList());
        if (targetPaths.size() > new HashSet(targetPaths).size()) {
            throw new SemanticException("select into: target paths in into clause should be different.");
        }
    }

    public void bindType() {
        this.sourceTargetPathPairList = SelectIntoUtils.bindTypeForSourceTargetPathPairList(this.sourceTargetPathPairList, this.sourceToDataTypeMap);
    }

    public List<Pair<String, PartialPath>> getSourceTargetPathPairList() {
        return this.sourceTargetPathPairList;
    }

    public List<String> getSourceColumnToViewList() {
        return this.sourceColumnToViewList;
    }

    public Map<String, Boolean> getTargetDeviceToAlignedMap() {
        return this.targetDeviceToAlignedMap;
    }

    public Map<PartialPath, Map<String, String>> getTargetPathToSourceMap() {
        HashMap<PartialPath, Map<String, String>> targetPathToSourceMap = new HashMap<PartialPath, Map<String, String>>();
        for (Pair<String, PartialPath> sourceTargetPathPair : this.sourceTargetPathPairList) {
            String sourceColumn = (String)sourceTargetPathPair.left;
            PartialPath targetDevice = ((PartialPath)sourceTargetPathPair.right).getDevicePath();
            String targetMeasurement = ((PartialPath)sourceTargetPathPair.right).getMeasurement();
            targetPathToSourceMap.computeIfAbsent(targetDevice, key -> new HashMap()).put(targetMeasurement, sourceColumn);
        }
        return targetPathToSourceMap;
    }

    public Map<PartialPath, Map<String, TSDataType>> getTargetPathToDataTypeMap() {
        return SelectIntoUtils.convertSourceTargetPathPairListToTargetPathDataTypeMap(this.sourceTargetPathPairList);
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.sourceTargetPathPairList.size(), (ByteBuffer)byteBuffer);
        for (Pair<String, PartialPath> pair : this.sourceTargetPathPairList) {
            ReadWriteIOUtils.write((String)((String)pair.left), (ByteBuffer)byteBuffer);
            ((PartialPath)pair.right).serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.targetDeviceToAlignedMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry entry : this.targetDeviceToAlignedMap.entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((Boolean)((Boolean)entry.getValue()), (ByteBuffer)byteBuffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.sourceTargetPathPairList.size(), (OutputStream)stream);
        for (Pair<String, PartialPath> pair : this.sourceTargetPathPairList) {
            ReadWriteIOUtils.write((String)((String)pair.left), (OutputStream)stream);
            ((PartialPath)pair.right).serialize((OutputStream)stream);
        }
        for (String string : this.sourceColumnToViewList) {
            ReadWriteIOUtils.write((String)string, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.targetDeviceToAlignedMap.size(), (OutputStream)stream);
        for (Map.Entry entry : this.targetDeviceToAlignedMap.entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)stream);
            ReadWriteIOUtils.write((Boolean)((Boolean)entry.getValue()), (OutputStream)stream);
        }
    }

    public static IntoPathDescriptor deserialize(ByteBuffer byteBuffer) {
        int listSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Pair<String, PartialPath>> sourceTargetPathPairList = new ArrayList<Pair<String, PartialPath>>(listSize);
        for (int i = 0; i < listSize; ++i) {
            String sourceColumn = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            PartialPath targetPath = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
            sourceTargetPathPairList.add(new Pair((Object)sourceColumn, (Object)targetPath));
        }
        ArrayList<String> sourceColumnToViewList = new ArrayList<String>();
        for (int i = 0; i < listSize; ++i) {
            String viewPath = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            sourceColumnToViewList.add(StringUtils.isEmpty((CharSequence)viewPath) ? "" : viewPath);
        }
        int mapSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<String, Boolean> targetDeviceToAlignedMap = new HashMap<String, Boolean>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            targetDeviceToAlignedMap.put(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer));
        }
        return new IntoPathDescriptor(sourceTargetPathPairList, sourceColumnToViewList, targetDeviceToAlignedMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntoPathDescriptor that = (IntoPathDescriptor)o;
        return this.sourceTargetPathPairList.equals(that.sourceTargetPathPairList) && this.targetDeviceToAlignedMap.equals(that.targetDeviceToAlignedMap);
    }

    public int hashCode() {
        return Objects.hash(this.sourceTargetPathPairList, this.targetDeviceToAlignedMap);
    }
}

