/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.active;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.load.active.ActiveLoadDirScanner;
import org.apache.iotdb.db.storageengine.load.active.ActiveLoadMetricsCollector;
import org.apache.iotdb.db.storageengine.load.active.ActiveLoadTsFileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveLoadAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveLoadAgent.class);
    private final ActiveLoadTsFileLoader activeLoadTsFileLoader = new ActiveLoadTsFileLoader();
    private final ActiveLoadDirScanner activeLoadDirScanner = new ActiveLoadDirScanner(this.activeLoadTsFileLoader);
    private final ActiveLoadMetricsCollector activeLoadMetricsCollector = new ActiveLoadMetricsCollector(this.activeLoadTsFileLoader, this.activeLoadDirScanner);

    public ActiveLoadTsFileLoader loader() {
        return this.activeLoadTsFileLoader;
    }

    public ActiveLoadDirScanner scanner() {
        return this.activeLoadDirScanner;
    }

    public ActiveLoadMetricsCollector metrics() {
        return this.activeLoadMetricsCollector;
    }

    public synchronized void start() {
        this.activeLoadDirScanner.start();
        this.activeLoadMetricsCollector.start();
    }

    public static void cleanupListeningDirectories() {
        try {
            ArrayList<String> dirsToClean = new ArrayList<String>();
            dirsToClean.addAll(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getLoadActiveListeningDirs()));
            dirsToClean.add(IoTDBDescriptor.getInstance().getConfig().getLoadActiveListeningPipeDir());
            dirsToClean.add(IoTDBDescriptor.getInstance().getConfig().getLoadActiveListeningFailDir());
            for (String dirPath : dirsToClean) {
                try {
                    File dir;
                    block13: {
                        if (dirPath == null || dirPath.isEmpty()) continue;
                        dir = new File(dirPath);
                        try {
                            if (!dir.exists()) continue;
                            if (!dir.isDirectory()) {
                            }
                            break block13;
                        }
                        catch (Exception e) {
                            LOGGER.debug("Failed to check directory: {}", (Object)dirPath, (Object)e);
                        }
                        continue;
                    }
                    File[] files = null;
                    try {
                        files = dir.listFiles();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to list files in directory: {}", (Object)dirPath, (Object)e);
                        continue;
                    }
                    if (files == null) continue;
                    for (File file : files) {
                        try {
                            FileUtils.deleteFileOrDirectory((File)file, (boolean)true);
                        }
                        catch (Exception e) {
                            LOGGER.debug("Failed to delete file or directory: {}", (Object)file.getAbsolutePath(), (Object)e);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to cleanup directory: {}", (Object)dirPath, (Object)e);
                }
            }
            LOGGER.info("Cleaned up active load listening directories");
        }
        catch (Throwable t) {
            LOGGER.warn("Unexpected error during cleanup of active load listening directories", t);
        }
    }
}

