/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.storageengine.rescon.memory.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.MathUtils;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.BatchEncodeInfo;
import org.apache.iotdb.db.utils.datastructure.BinaryTVList;
import org.apache.iotdb.db.utils.datastructure.BooleanTVList;
import org.apache.iotdb.db.utils.datastructure.DoubleTVList;
import org.apache.iotdb.db.utils.datastructure.FloatTVList;
import org.apache.iotdb.db.utils.datastructure.IntTVList;
import org.apache.iotdb.db.utils.datastructure.LongTVList;
import org.apache.iotdb.db.utils.datastructure.MemPointIterator;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;

public abstract class TVList
implements WALEntryValue {
    protected static final String ERR_DATATYPE_NOT_CONSISTENT = "DataType not consistent";
    protected List<long[]> timestamps;
    protected int rowCount = 0;
    protected int seqRowCount = 0;
    protected List<int[]> indices;
    protected List<BitMap> bitMap;
    private final ReentrantLock queryListLock = new ReentrantLock();
    protected final Set<QueryContext> queryContextSet;
    protected QueryContext ownerQuery;
    protected long reservedMemoryBytes = 0L;
    protected boolean sorted = true;
    protected long maxTime;
    protected long minTime;
    protected AtomicInteger referenceCount;
    private long version;
    private final TVList outer = this;

    protected TVList() {
        this.timestamps = new ArrayList<long[]>();
        this.maxTime = Long.MIN_VALUE;
        this.minTime = Long.MAX_VALUE;
        this.queryContextSet = new HashSet<QueryContext>();
        this.referenceCount = new AtomicInteger();
    }

    public static TVList newList(TSDataType dataType) {
        switch (dataType) {
            case TEXT: 
            case BLOB: 
            case STRING: {
                return BinaryTVList.newList();
            }
            case FLOAT: {
                return FloatTVList.newList();
            }
            case INT32: 
            case DATE: {
                return IntTVList.newList();
            }
            case INT64: 
            case TIMESTAMP: {
                return LongTVList.newList();
            }
            case DOUBLE: {
                return DoubleTVList.newList();
            }
            case BOOLEAN: {
                return BooleanTVList.newList();
            }
        }
        return null;
    }

    public long tvListArrayMemCost() {
        long size = TVList.tvListArrayMemCost(this.getDataType());
        size += this.indices != null ? (long)PrimitiveArrayManager.ARRAY_SIZE * 4L : 0L;
        return size += this.bitMap != null ? (long)(PrimitiveArrayManager.ARRAY_SIZE / 8) + 1L : 0L;
    }

    public static long tvListArrayMemCost(TSDataType type) {
        long size = 0L;
        size += (long)PrimitiveArrayManager.ARRAY_SIZE * 8L;
        size += (long)PrimitiveArrayManager.ARRAY_SIZE * (long)type.getDataTypeSize();
        size += (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER * 2L;
        return size += (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * 2L;
    }

    public synchronized long calculateRamSize() {
        return (long)this.timestamps.size() * this.tvListArrayMemCost();
    }

    public synchronized boolean isSorted() {
        return this.sorted;
    }

    public void setReservedMemoryBytes(long bytes) {
        this.reservedMemoryBytes = bytes;
    }

    public void addReservedMemoryBytes(long bytes) {
        this.reservedMemoryBytes += bytes;
    }

    public long getReservedMemoryBytes() {
        return this.reservedMemoryBytes;
    }

    public abstract int sort();

    public void increaseReferenceCount() {
        this.referenceCount.incrementAndGet();
    }

    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    public int rowCount() {
        return this.rowCount;
    }

    public int seqRowCount() {
        return this.seqRowCount;
    }

    public int count() {
        if (this.bitMap == null) {
            return this.rowCount;
        }
        int count = 0;
        for (int rowIdx = 0; rowIdx < this.rowCount; ++rowIdx) {
            if (this.isNullValue(rowIdx)) continue;
            ++count;
        }
        return count;
    }

    public long getTime(int index) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        return this.timestamps.get(arrayIndex)[elementIndex];
    }

    private int binarySearchTimestampFirstGreaterOrEqualsPosition(long time, int low, int high) {
        if (!this.sorted && high >= this.seqRowCount) {
            throw new UnsupportedOperationException("Current TVList is not sorted");
        }
        while (low <= high) {
            int mid = low + (high - low >>> 1);
            long midTime = this.getTime(mid);
            if (midTime < time) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return low;
    }

    private int binarySearchTimestampLastLessOrEqualsPosition(long time, int low, int high) {
        if (!this.sorted && high >= this.seqRowCount) {
            throw new UnsupportedOperationException("Current TVList is not sorted");
        }
        while (low <= high) {
            int mid = low + (high - low >>> 1);
            long midTime = this.getTime(mid);
            if (midTime <= time) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return high;
    }

    protected void set(int src, int dest) {
        long srcT = this.getTime(src);
        int srcV = this.getValueIndex(src);
        this.set(dest, srcT, srcV);
    }

    protected void set(int index, long timestamp, int valueIndex) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        this.timestamps.get((int)arrayIndex)[elementIndex] = timestamp;
        if (this.indices == null) {
            this.indices = new ArrayList<int[]>();
            for (int i = 0; i < this.timestamps.size(); ++i) {
                this.indices.add((int[])this.getPrimitiveArraysByType(TSDataType.INT32));
                int offset = i * PrimitiveArrayManager.ARRAY_SIZE;
                Arrays.setAll(this.indices.get(i), j -> offset + j);
            }
        }
        this.indices.get((int)arrayIndex)[elementIndex] = valueIndex;
    }

    protected int[] cloneIndex(int[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public int getValueIndex(int index) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (this.indices == null) {
            return index;
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        return this.indices.get(arrayIndex)[elementIndex];
    }

    protected void markNullValue(int arrayIndex, int elementIndex) {
        if (this.bitMap == null) {
            ArrayList<BitMap> localBitMap = new ArrayList<BitMap>();
            for (int i = 0; i < this.timestamps.size(); ++i) {
                localBitMap.add(new BitMap(PrimitiveArrayManager.ARRAY_SIZE));
            }
            this.bitMap = localBitMap;
        }
        if (this.bitMap.get(arrayIndex) == null) {
            this.bitMap.set(arrayIndex, new BitMap(PrimitiveArrayManager.ARRAY_SIZE));
        }
        this.bitMap.get(arrayIndex).mark(elementIndex);
    }

    public boolean isNullValue(int unsortedRowIndex) {
        if (unsortedRowIndex >= this.rowCount) {
            throw new IndexOutOfBoundsException("Index out of bound error!");
        }
        if (this.bitMap == null || this.bitMap.get(unsortedRowIndex / PrimitiveArrayManager.ARRAY_SIZE) == null) {
            return false;
        }
        int arrayIndex = unsortedRowIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = unsortedRowIndex % PrimitiveArrayManager.ARRAY_SIZE;
        return this.bitMap.get(arrayIndex).isMarked(elementIndex);
    }

    protected void cloneBitMap(TVList cloneList) {
        if (this.bitMap != null) {
            cloneList.bitMap = new ArrayList<BitMap>();
            for (BitMap bm : this.bitMap) {
                cloneList.bitMap.add(bm == null ? null : bm.clone());
            }
        }
    }

    public void putLong(long time, long value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putInt(long time, int value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putFloat(long time, float value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putDouble(long time, double value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putBinary(long time, Binary value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putBoolean(long time, boolean value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putAlignedValue(long time, Object[] value) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putLongs(long[] time, long[] value, BitMap bitMap, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putInts(long[] time, int[] value, BitMap bitMap, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putFloats(long[] time, float[] value, BitMap bitMap, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putDoubles(long[] time, double[] value, BitMap bitMap, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putBinaries(long[] time, Binary[] value, BitMap bitMap, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putBooleans(long[] time, boolean[] value, BitMap bitMap, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public void putAlignedValues(long[] time, Object[] value, BitMap[] bitMaps, int start, int end) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public long getLong(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public int getInt(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public float getFloat(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public double getDouble(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public Binary getBinary(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public boolean getBoolean(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public Object getAlignedValue(int index) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public TVList getTvListByColumnIndex(List<Integer> columnIndexList, List<TSDataType> dataTypeList) {
        throw new UnsupportedOperationException(ERR_DATATYPE_NOT_CONSISTENT);
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getVersion() {
        return this.version;
    }

    protected abstract void expandValues();

    public abstract TVList clone();

    public TVList clone(long version) {
        this.version = version;
        return this.clone();
    }

    public int delete(long lowerBound, long upperBound) {
        int deletedNumber = 0;
        long maxTime = Long.MIN_VALUE;
        long minTime = Long.MAX_VALUE;
        for (int i = 0; i < this.rowCount; ++i) {
            long time = this.getTime(i);
            if (time >= lowerBound && time <= upperBound) {
                int originRowIndex = this.getValueIndex(i);
                if (this.isNullValue(originRowIndex)) continue;
                int arrayIndex = originRowIndex / PrimitiveArrayManager.ARRAY_SIZE;
                int elementIndex = originRowIndex % PrimitiveArrayManager.ARRAY_SIZE;
                this.markNullValue(arrayIndex, elementIndex);
                ++deletedNumber;
                continue;
            }
            maxTime = Math.max(time, maxTime);
            minTime = Math.min(time, minTime);
        }
        return deletedNumber;
    }

    protected void cloneAs(TVList cloneList) {
        for (long[] timestampArray : this.timestamps) {
            cloneList.timestamps.add(this.cloneTime(timestampArray));
        }
        if (this.indices != null) {
            cloneList.indices = new ArrayList<int[]>();
            for (int[] indicesArray : this.indices) {
                cloneList.indices.add(this.cloneIndex(indicesArray));
            }
        }
        cloneList.rowCount = this.rowCount;
        cloneList.seqRowCount = this.seqRowCount;
        cloneList.sorted = this.sorted;
        cloneList.maxTime = this.maxTime;
        cloneList.minTime = this.minTime;
    }

    public void clear() {
        this.rowCount = 0;
        this.seqRowCount = 0;
        this.sorted = true;
        this.maxTime = Long.MIN_VALUE;
        this.minTime = Long.MAX_VALUE;
        this.queryContextSet.clear();
        this.ownerQuery = null;
        this.clearTime();
        this.clearValue();
        this.clearIndices();
        this.clearBitMap();
    }

    protected void clearTime() {
        if (this.timestamps != null) {
            for (long[] dataArray : this.timestamps) {
                PrimitiveArrayManager.release(dataArray);
            }
            this.timestamps.clear();
        }
    }

    protected abstract void clearValue();

    protected void clearIndices() {
        if (this.indices != null) {
            for (int[] dataArray : this.indices) {
                PrimitiveArrayManager.release(dataArray);
            }
            this.indices.clear();
        }
    }

    protected void clearBitMap() {
        if (this.bitMap != null) {
            this.bitMap.clear();
        }
    }

    protected void checkExpansion() {
        if (this.rowCount % PrimitiveArrayManager.ARRAY_SIZE == 0) {
            this.expandValues();
            this.timestamps.add((long[])this.getPrimitiveArraysByType(TSDataType.INT64));
        }
    }

    protected Object getPrimitiveArraysByType(TSDataType dataType) {
        return PrimitiveArrayManager.allocate(dataType);
    }

    protected long[] cloneTime(long[] array) {
        long[] cloneArray = new long[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    void updateMinMaxTimeAndSorted(long[] time, int start, int end) {
        int length = time.length;
        long inPutMinTime = Long.MAX_VALUE;
        boolean inputSorted = true;
        int inputSeqRowCount = 0;
        for (int i = start; i < end; ++i) {
            inPutMinTime = Math.min(inPutMinTime, time[i]);
            this.maxTime = Math.max(this.maxTime, time[i]);
            if (!inputSorted) continue;
            if (i < length - 1 && time[i] > time[i + 1]) {
                inputSorted = false;
                continue;
            }
            ++inputSeqRowCount;
        }
        this.minTime = Math.min(this.minTime, inPutMinTime);
        if (this.sorted && (this.rowCount == 0 || time[start] >= this.getTime(this.rowCount - 1))) {
            this.seqRowCount += inputSeqRowCount;
        }
        this.sorted = this.sorted && inputSorted && (this.rowCount == 0 || inPutMinTime >= this.getTime(this.rowCount - 1));
    }

    public abstract TimeValuePair getTimeValuePair(int var1);

    protected abstract TimeValuePair getTimeValuePair(int var1, long var2, Integer var4, TSEncoding var5);

    public TsBlock buildTsBlock() {
        return this.buildTsBlock(0, TSEncoding.PLAIN, null);
    }

    public TsBlock buildTsBlock(int floatPrecision, TSEncoding encoding, List<TimeRange> deletionList) {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(this.getDataType()));
        this.writeValidValuesIntoTsBlock(builder, floatPrecision, encoding, deletionList);
        return builder.build();
    }

    protected abstract void writeValidValuesIntoTsBlock(TsBlockBuilder var1, int var2, TSEncoding var3, List<TimeRange> var4);

    protected float roundValueWithGivenPrecision(float value, int floatPrecision, TSEncoding encoding) {
        if (!(Float.isNaN(value) || encoding != TSEncoding.RLE && encoding != TSEncoding.TS_2DIFF)) {
            return MathUtils.roundWithGivenPrecision(value, floatPrecision);
        }
        return value;
    }

    protected double roundValueWithGivenPrecision(double value, int floatPrecision, TSEncoding encoding) {
        if (!(Double.isNaN(value) || encoding != TSEncoding.RLE && encoding != TSEncoding.TS_2DIFF)) {
            return MathUtils.roundWithGivenPrecision(value, floatPrecision);
        }
        return value;
    }

    public abstract TSDataType getDataType();

    public static TVList deserialize(DataInputStream stream) throws IOException {
        TSDataType dataType = ReadWriteIOUtils.readDataType((InputStream)stream);
        switch (dataType) {
            case TEXT: 
            case BLOB: 
            case STRING: {
                return BinaryTVList.deserialize(stream);
            }
            case FLOAT: {
                return FloatTVList.deserialize(stream);
            }
            case INT32: 
            case DATE: {
                return IntTVList.deserialize(stream);
            }
            case INT64: 
            case TIMESTAMP: {
                return LongTVList.deserialize(stream);
            }
            case DOUBLE: {
                return DoubleTVList.deserialize(stream);
            }
            case BOOLEAN: {
                return BooleanTVList.deserialize(stream);
            }
        }
        return null;
    }

    public static TVList deserializeWithoutBitMap(DataInputStream stream) throws IOException {
        TSDataType dataType = ReadWriteIOUtils.readDataType((InputStream)stream);
        switch (dataType) {
            case TEXT: 
            case BLOB: 
            case STRING: {
                return BinaryTVList.deserializeWithoutBitMap(stream);
            }
            case FLOAT: {
                return FloatTVList.deserializeWithoutBitMap(stream);
            }
            case INT32: 
            case DATE: {
                return IntTVList.deserializeWithoutBitMap(stream);
            }
            case INT64: 
            case TIMESTAMP: {
                return LongTVList.deserializeWithoutBitMap(stream);
            }
            case DOUBLE: {
                return DoubleTVList.deserializeWithoutBitMap(stream);
            }
            case BOOLEAN: {
                return BooleanTVList.deserializeWithoutBitMap(stream);
            }
        }
        return null;
    }

    public List<long[]> getTimestamps() {
        return this.timestamps;
    }

    public List<int[]> getIndices() {
        return this.indices;
    }

    public void setOwnerQuery(QueryContext queryCtx) {
        this.ownerQuery = queryCtx;
    }

    public QueryContext getOwnerQuery() {
        return this.ownerQuery;
    }

    public Set<QueryContext> getQueryContextSet() {
        return this.queryContextSet;
    }

    public List<BitMap> getBitMap() {
        return this.bitMap;
    }

    public void lockQueryList() {
        this.queryListLock.lock();
    }

    public void unlockQueryList() {
        this.queryListLock.unlock();
    }

    public TVListIterator iterator(Ordering scanOrder, int rowCount, Filter globalTimeFilter, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding, int maxNumberOfPointsInPage) {
        return new TVListIterator(scanOrder, rowCount, globalTimeFilter, deletionList, floatPrecision, encoding, maxNumberOfPointsInPage);
    }

    public class TVListIterator
    extends MemPointIterator {
        protected int index;
        protected int rows;
        protected boolean probeNext;
        protected final Filter globalTimeFilter;
        private final List<TimeRange> deletionList;
        private final int[] deleteCursor;
        private final int floatPrecision;
        private final TSEncoding encoding;
        protected final int maxNumberOfPointsInPage;

        public TVListIterator(Ordering scanOrder, int rowCount, Filter globalTimeFilter, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding, int maxNumberOfPointsInPage) {
            super(scanOrder);
            this.globalTimeFilter = globalTimeFilter;
            this.deletionList = deletionList;
            this.floatPrecision = floatPrecision != null ? floatPrecision : 0;
            this.encoding = encoding;
            this.index = 0;
            this.rows = rowCount;
            this.probeNext = false;
            this.maxNumberOfPointsInPage = maxNumberOfPointsInPage;
            int cursor = deletionList == null || scanOrder.isAscending() ? 0 : deletionList.size() - 1;
            this.deleteCursor = new int[]{cursor};
        }

        @Override
        protected void skipToCurrentTimeRangeStartPosition() {
            int indexInTVList;
            long searchTimestamp;
            if (this.timeRange == null || this.index >= this.rows) {
                return;
            }
            if (this.timeRange.contains(TVList.this.getTime(this.getScanOrderIndex(this.index)))) {
                return;
            }
            if (this.scanOrder.isAscending()) {
                searchTimestamp = this.timeRange.getMin();
                if (searchTimestamp <= TVList.this.outer.getMinTime()) {
                    return;
                }
                if (searchTimestamp > TVList.this.outer.getMaxTime()) {
                    this.index = this.rows;
                    this.probeNext = true;
                    return;
                }
                indexInTVList = TVList.this.binarySearchTimestampFirstGreaterOrEqualsPosition(searchTimestamp, this.getScanOrderIndex(this.index), this.rows - 1);
            } else {
                searchTimestamp = this.timeRange.getMax();
                if (searchTimestamp >= TVList.this.outer.getMaxTime()) {
                    return;
                }
                if (searchTimestamp < TVList.this.outer.getMinTime()) {
                    this.index = this.rows;
                    this.probeNext = true;
                    return;
                }
                indexInTVList = TVList.this.binarySearchTimestampLastLessOrEqualsPosition(searchTimestamp, 0, this.getScanOrderIndex(this.index));
            }
            int newIndex = this.getScanOrderIndex(indexInTVList);
            if (newIndex > this.index) {
                this.index = newIndex;
            }
            this.probeNext = false;
        }

        protected void prepareNext() {
            if (this.scanOrder.isAscending()) {
                this.skipDeletedOrTimeNotSatisfiedRows();
                while (this.index + 1 < this.rows && TVList.this.getTime(this.getScanOrderIndex(this.index + 1)) == TVList.this.getTime(this.getScanOrderIndex(this.index))) {
                    ++this.index;
                }
            } else {
                while (this.index > 0 && this.index <= this.rows - 1 && TVList.this.getTime(this.getScanOrderIndex(this.index - 1)) == TVList.this.getTime(this.getScanOrderIndex(this.index))) {
                    ++this.index;
                }
                this.skipDeletedOrTimeNotSatisfiedRows();
            }
            this.probeNext = true;
        }

        protected void skipDeletedOrTimeNotSatisfiedRows() {
            long time;
            while (this.index < this.rows && (TVList.this.isNullValue(TVList.this.getValueIndex(this.getScanOrderIndex(this.index))) || ModificationUtils.isPointDeleted(time = TVList.this.getTime(this.getScanOrderIndex(this.index)), this.deletionList, this.deleteCursor, this.scanOrder) || !this.isTimeSatisfied(time))) {
                ++this.index;
            }
        }

        protected boolean isTimeSatisfied(long timestamp) {
            return this.globalTimeFilter == null || this.globalTimeFilter.satisfyRow(timestamp, null);
        }

        public boolean hasNextTimeValuePair() {
            if (!this.paginationController.hasCurLimit()) {
                return false;
            }
            if (!this.probeNext) {
                this.prepareNext();
            }
            return this.index < this.rows && !this.isCurrentTimeExceedTimeRange(TVList.this.getTime(this.getScanOrderIndex(this.index)));
        }

        public TimeValuePair nextTimeValuePair() {
            if (!this.hasNextTimeValuePair()) {
                return null;
            }
            TimeValuePair tvp = TVList.this.getTimeValuePair(this.getScanOrderIndex(this.index));
            this.next();
            return tvp;
        }

        public TimeValuePair currentTimeValuePair() {
            if (!this.hasNextTimeValuePair()) {
                return null;
            }
            return TVList.this.getTimeValuePair(this.getScanOrderIndex(this.index));
        }

        @Override
        public TsBlock getBatch(int tsBlockIndex) {
            if (tsBlockIndex < 0 || tsBlockIndex >= this.tsBlocks.size()) {
                return null;
            }
            return (TsBlock)this.tsBlocks.get(tsBlockIndex);
        }

        @Override
        public boolean hasNextBatch() {
            if (!this.paginationController.hasCurLimit()) {
                return false;
            }
            return this.hasNextTimeValuePair();
        }

        @Override
        public TsBlock nextBatch() {
            TSDataType dataType = TVList.this.getDataType();
            int maxRowCountOfCurrentBatch = Math.min(this.paginationController.hasSetLimit() ? (int)this.paginationController.getCurLimit() : Integer.MAX_VALUE, Math.min(this.maxNumberOfPointsInPage, this.rows - this.index));
            TsBlockBuilder builder = new TsBlockBuilder(maxRowCountOfCurrentBatch, Collections.singletonList(dataType));
            switch (dataType) {
                case BOOLEAN: {
                    long time;
                    while (this.index < this.rows && builder.getPositionCount() < this.maxNumberOfPointsInPage && this.paginationController.hasCurLimit() && !this.isCurrentTimeExceedTimeRange(time = TVList.this.getTime(this.getScanOrderIndex(this.index)))) {
                        if (!TVList.this.isNullValue(TVList.this.getValueIndex(this.getScanOrderIndex(this.index))) && !ModificationUtils.isPointDeleted(time, this.deletionList, this.deleteCursor, this.scanOrder) && this.isLatestPoint(this.index, time) && this.isTimeSatisfied(time)) {
                            boolean aBoolean = TVList.this.getBoolean(this.getScanOrderIndex(this.index));
                            if (this.pushDownFilter == null || this.pushDownFilter.satisfyBoolean(time, aBoolean)) {
                                if (this.paginationController.hasCurOffset()) {
                                    this.paginationController.consumeOffset();
                                    ++this.index;
                                    continue;
                                }
                                this.paginationController.consumeLimit();
                                builder.getTimeColumnBuilder().writeLong(time);
                                builder.getColumnBuilder(0).writeBoolean(aBoolean);
                                builder.declarePosition();
                            }
                        }
                        ++this.index;
                    }
                    break;
                }
                case INT32: 
                case DATE: {
                    long time;
                    while (this.index < this.rows && builder.getPositionCount() < this.maxNumberOfPointsInPage && this.paginationController.hasCurLimit() && !this.isCurrentTimeExceedTimeRange(time = TVList.this.getTime(this.getScanOrderIndex(this.index)))) {
                        if (!TVList.this.isNullValue(TVList.this.getValueIndex(this.getScanOrderIndex(this.index))) && !ModificationUtils.isPointDeleted(time, this.deletionList, this.deleteCursor, this.scanOrder) && this.isLatestPoint(this.index, time) && this.isTimeSatisfied(time)) {
                            int anInt = TVList.this.getInt(this.getScanOrderIndex(this.index));
                            if (this.pushDownFilter == null || this.pushDownFilter.satisfyInteger(time, anInt)) {
                                if (this.paginationController.hasCurOffset()) {
                                    this.paginationController.consumeOffset();
                                    ++this.index;
                                    continue;
                                }
                                this.paginationController.consumeLimit();
                                builder.getTimeColumnBuilder().writeLong(time);
                                builder.getColumnBuilder(0).writeInt(anInt);
                                builder.declarePosition();
                            }
                        }
                        ++this.index;
                    }
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    long time;
                    while (this.index < this.rows && builder.getPositionCount() < this.maxNumberOfPointsInPage && this.paginationController.hasCurLimit() && !this.isCurrentTimeExceedTimeRange(time = TVList.this.getTime(this.getScanOrderIndex(this.index)))) {
                        if (!TVList.this.isNullValue(TVList.this.getValueIndex(this.getScanOrderIndex(this.index))) && !ModificationUtils.isPointDeleted(time, this.deletionList, this.deleteCursor, this.scanOrder) && this.isLatestPoint(this.index, time) && this.isTimeSatisfied(time)) {
                            long aLong = TVList.this.getLong(this.getScanOrderIndex(this.index));
                            if (this.pushDownFilter == null || this.pushDownFilter.satisfyLong(time, aLong)) {
                                if (this.paginationController.hasCurOffset()) {
                                    this.paginationController.consumeOffset();
                                    ++this.index;
                                    continue;
                                }
                                this.paginationController.consumeLimit();
                                builder.getTimeColumnBuilder().writeLong(time);
                                builder.getColumnBuilder(0).writeLong(aLong);
                                builder.declarePosition();
                            }
                        }
                        ++this.index;
                    }
                    break;
                }
                case FLOAT: {
                    long time;
                    while (this.index < this.rows && builder.getPositionCount() < this.maxNumberOfPointsInPage && this.paginationController.hasCurLimit() && !this.isCurrentTimeExceedTimeRange(time = TVList.this.getTime(this.getScanOrderIndex(this.index)))) {
                        if (!TVList.this.isNullValue(TVList.this.getValueIndex(this.getScanOrderIndex(this.index))) && !ModificationUtils.isPointDeleted(time, this.deletionList, this.deleteCursor, this.scanOrder) && this.isLatestPoint(this.index, time) && this.isTimeSatisfied(time)) {
                            float aFloat = TVList.this.roundValueWithGivenPrecision(TVList.this.getFloat(this.getScanOrderIndex(this.index)), this.floatPrecision, this.encoding);
                            if (this.pushDownFilter == null || this.pushDownFilter.satisfyFloat(time, aFloat)) {
                                if (this.paginationController.hasCurOffset()) {
                                    this.paginationController.consumeOffset();
                                    ++this.index;
                                    continue;
                                }
                                this.paginationController.consumeLimit();
                                builder.getTimeColumnBuilder().writeLong(time);
                                builder.getColumnBuilder(0).writeFloat(aFloat);
                                builder.declarePosition();
                            }
                        }
                        ++this.index;
                    }
                    break;
                }
                case DOUBLE: {
                    long time;
                    while (this.index < this.rows && builder.getPositionCount() < this.maxNumberOfPointsInPage && this.paginationController.hasCurLimit() && !this.isCurrentTimeExceedTimeRange(time = TVList.this.getTime(this.getScanOrderIndex(this.index)))) {
                        if (!TVList.this.isNullValue(TVList.this.getValueIndex(this.getScanOrderIndex(this.index))) && !ModificationUtils.isPointDeleted(time, this.deletionList, this.deleteCursor, this.scanOrder) && this.isLatestPoint(this.index, time) && this.isTimeSatisfied(time)) {
                            double aDouble = TVList.this.roundValueWithGivenPrecision(TVList.this.getDouble(this.getScanOrderIndex(this.index)), this.floatPrecision, this.encoding);
                            if (this.pushDownFilter == null || this.pushDownFilter.satisfyDouble(time, aDouble)) {
                                if (this.paginationController.hasCurOffset()) {
                                    this.paginationController.consumeOffset();
                                    ++this.index;
                                    continue;
                                }
                                this.paginationController.consumeLimit();
                                builder.getTimeColumnBuilder().writeLong(time);
                                builder.getColumnBuilder(0).writeDouble(aDouble);
                                builder.declarePosition();
                            }
                        }
                        ++this.index;
                    }
                    break;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    long time;
                    while (this.index < this.rows && builder.getPositionCount() < this.maxNumberOfPointsInPage && this.paginationController.hasCurLimit() && !this.isCurrentTimeExceedTimeRange(time = TVList.this.getTime(this.getScanOrderIndex(this.index)))) {
                        if (!TVList.this.isNullValue(TVList.this.getValueIndex(this.getScanOrderIndex(this.index))) && !ModificationUtils.isPointDeleted(time, this.deletionList, this.deleteCursor, this.scanOrder) && this.isLatestPoint(this.index, time) && this.isTimeSatisfied(time)) {
                            Binary binary = TVList.this.getBinary(this.getScanOrderIndex(this.index));
                            if (this.pushDownFilter == null || this.pushDownFilter.satisfyBinary(time, binary)) {
                                if (this.paginationController.hasCurOffset()) {
                                    this.paginationController.consumeOffset();
                                    ++this.index;
                                    continue;
                                }
                                this.paginationController.consumeLimit();
                                builder.getTimeColumnBuilder().writeLong(time);
                                builder.getColumnBuilder(0).writeBinary(binary);
                                builder.declarePosition();
                            }
                        }
                        ++this.index;
                    }
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
                }
            }
            TsBlock tsBlock = builder.build();
            this.addTsBlock(tsBlock);
            return tsBlock;
        }

        protected boolean isLatestPoint(int rowIndex, long currentTime) {
            if (this.scanOrder.isAscending()) {
                return rowIndex == this.rows - 1 || currentTime != TVList.this.getTime(this.getScanOrderIndex(rowIndex + 1));
            }
            return rowIndex == 0 || currentTime != TVList.this.getTime(this.getScanOrderIndex(rowIndex - 1));
        }

        public int getScanOrderIndex(int rowIndex) {
            return this.scanOrder.isAscending() ? rowIndex : this.rows - 1 - rowIndex;
        }

        @Override
        public void encodeBatch(IChunkWriter chunkWriter, BatchEncodeInfo encodeInfo, long[] times) {
            TSDataType dataType = TVList.this.getDataType();
            ChunkWriterImpl chunkWriterImpl = (ChunkWriterImpl)chunkWriter;
            while (this.index < this.rows) {
                if (!TVList.this.isNullValue(TVList.this.getValueIndex(this.index))) {
                    long time = TVList.this.getTime(this.index);
                    while (this.index + 1 < this.rows && time == TVList.this.getTime(this.index + 1)) {
                        ++this.index;
                    }
                    if (encodeInfo.lastIterator) {
                        while (this.index < this.rows && TVList.this.isNullValue(TVList.this.getValueIndex(this.index))) {
                            ++this.index;
                        }
                        if (this.index == this.rows || this.index == this.rows - 1) {
                            chunkWriterImpl.setLastPoint(true);
                        }
                    }
                    switch (dataType) {
                        case BOOLEAN: {
                            chunkWriterImpl.write(time, TVList.this.getBoolean(this.index));
                            encodeInfo.dataSizeInChunk += 9L;
                            break;
                        }
                        case INT32: 
                        case DATE: {
                            chunkWriterImpl.write(time, TVList.this.getInt(this.index));
                            encodeInfo.dataSizeInChunk += 12L;
                            break;
                        }
                        case INT64: 
                        case TIMESTAMP: {
                            chunkWriterImpl.write(time, TVList.this.getLong(this.index));
                            encodeInfo.dataSizeInChunk += 16L;
                            break;
                        }
                        case FLOAT: {
                            chunkWriterImpl.write(time, TVList.this.getFloat(this.index));
                            encodeInfo.dataSizeInChunk += 12L;
                            break;
                        }
                        case DOUBLE: {
                            chunkWriterImpl.write(time, TVList.this.getDouble(this.index));
                            encodeInfo.dataSizeInChunk += 16L;
                            break;
                        }
                        case TEXT: 
                        case BLOB: 
                        case STRING: {
                            Binary value = TVList.this.getBinary(this.index);
                            chunkWriterImpl.write(time, value);
                            encodeInfo.dataSizeInChunk += 8L + MemUtils.getBinarySize(value);
                            break;
                        }
                        default: {
                            throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
                        }
                    }
                    ++encodeInfo.pointNumInChunk;
                    if ((long)encodeInfo.pointNumInChunk >= encodeInfo.maxNumberOfPointsInChunk || encodeInfo.dataSizeInChunk >= encodeInfo.targetChunkSize) break;
                }
                ++this.index;
            }
        }

        public long getUsedMemorySize() {
            return 0L;
        }

        public void next() {
            ++this.index;
            this.probeNext = false;
        }

        public boolean hasCurrent() {
            return this.index < this.rows;
        }

        public long currentTime() {
            if (!this.hasCurrent()) {
                return Long.MIN_VALUE;
            }
            return TVList.this.getTime(this.getScanOrderIndex(this.index));
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
            this.probeNext = false;
        }

        public void reset() {
            this.index = 0;
            this.probeNext = false;
        }

        public TVList getTVList() {
            return TVList.this.outer;
        }
    }
}

