/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.util.stream.LongStream;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.factory.stack.primitive.ImmutableLongStackFactory;
import org.eclipse.collections.api.stack.primitive.ImmutableLongStack;
import org.eclipse.collections.impl.factory.primitive.LongStacks;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableLongArrayStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableLongEmptyStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableLongSingletonStack;

public class ImmutableLongStackFactoryImpl
implements ImmutableLongStackFactory {
    public static final ImmutableLongStackFactory INSTANCE = new ImmutableLongStackFactoryImpl();

    @Override
    public ImmutableLongStack empty() {
        return ImmutableLongEmptyStack.INSTANCE;
    }

    @Override
    public ImmutableLongStack of() {
        return this.empty();
    }

    @Override
    public ImmutableLongStack with() {
        return this.empty();
    }

    @Override
    public ImmutableLongStack of(long one) {
        return this.with(one);
    }

    @Override
    public ImmutableLongStack with(long one) {
        return new ImmutableLongSingletonStack(one);
    }

    @Override
    public ImmutableLongStack of(long ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableLongStack with(long ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableLongArrayStack.newStackWith(items);
    }

    @Override
    public ImmutableLongStack ofAll(LongIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableLongStack withAll(LongIterable items) {
        if (items instanceof ImmutableLongStack) {
            return (ImmutableLongStack)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableLongStack ofAll(Iterable<Long> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableLongStack withAll(Iterable<Long> iterable) {
        return LongStacks.mutable.withAll(iterable).toImmutable();
    }

    @Override
    public ImmutableLongStack ofAllReversed(LongIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public ImmutableLongStack withAllReversed(LongIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableLongArrayStack.newStackFromTopToBottom(items);
    }

    @Override
    public ImmutableLongStack ofAll(LongStream items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableLongStack withAll(LongStream items) {
        return this.with(items.toArray());
    }
}

