/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.executor;

import com.google.common.util.concurrent.SettableFuture;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.iotdb.ainode.rpc.thrift.TLoadModelReq;
import org.apache.iotdb.ainode.rpc.thrift.TShowAIDevicesResp;
import org.apache.iotdb.ainode.rpc.thrift.TShowLoadedModelsReq;
import org.apache.iotdb.ainode.rpc.thrift.TShowLoadedModelsResp;
import org.apache.iotdb.ainode.rpc.thrift.TShowModelsReq;
import org.apache.iotdb.ainode.rpc.thrift.TShowModelsResp;
import org.apache.iotdb.ainode.rpc.thrift.TTrainingReq;
import org.apache.iotdb.ainode.rpc.thrift.TUnloadModelReq;
import org.apache.iotdb.common.rpc.thrift.Model;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetConfigurationReq;
import org.apache.iotdb.common.rpc.thrift.TSetSpaceQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.common.rpc.thrift.TSetThrottleQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TShowTTLReq;
import org.apache.iotdb.common.rpc.thrift.TSpaceQuota;
import org.apache.iotdb.common.rpc.thrift.TTestConnectionResp;
import org.apache.iotdb.common.rpc.thrift.TThrottleQuota;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.ConfigurationFileUtils;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.executable.ExecutableManager;
import org.apache.iotdb.commons.executable.ExecutableResource;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.agent.plugin.service.PipePluginClassLoader;
import org.apache.iotdb.commons.pipe.agent.plugin.service.PipePluginExecutableManager;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.datastructure.visibility.Visibility;
import org.apache.iotdb.commons.pipe.datastructure.visibility.VisibilityUtils;
import org.apache.iotdb.commons.pipe.sink.payload.airgap.AirGapPseudoTPipeTransferRequest;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.cache.CacheClearOptions;
import org.apache.iotdb.commons.schema.table.AlterOrDropTableOperationType;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.TsTableInternalRPCUtil;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchemaUtil;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMeta;
import org.apache.iotdb.commons.trigger.service.TriggerExecutableManager;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.SerializeUtils;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.confignode.rpc.thrift.TAINodeRemoveReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterEncodingCompressorReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterOrDropTableReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TCountDatabaseResp;
import org.apache.iotdb.confignode.rpc.thrift.TCountTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TCountTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTableViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveResp;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDeactivateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteDatabasesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTableDeviceReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTableDeviceResp;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDescTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TDropCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropPipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropSubscriptionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TExtendRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TFetchTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllPipeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipePluginTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetUDFTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetUdfTableReq;
import org.apache.iotdb.confignode.rpc.thrift.TMigrateRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TPipeConfigTransferReq;
import org.apache.iotdb.confignode.rpc.thrift.TPipeConfigTransferResp;
import org.apache.iotdb.confignode.rpc.thrift.TReconstructRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TRemoveRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowAINodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowCQResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowConfigNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDataNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDatabaseResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowSubscriptionResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowTTLResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowThrottleReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTopicResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowVariablesResp;
import org.apache.iotdb.confignode.rpc.thrift.TSpaceQuotaResp;
import org.apache.iotdb.confignode.rpc.thrift.TStartPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TStopPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TThrottleQuotaResp;
import org.apache.iotdb.confignode.rpc.thrift.TUnsetSchemaTemplateReq;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.SchemaQuotaExceededException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.protocol.client.DataNodeClientPoolFactory;
import org.apache.iotdb.db.protocol.client.ainode.AINodeClient;
import org.apache.iotdb.db.protocol.client.ainode.AINodeClientManager;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.Analyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.CountDatabaseTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.CountTimeSlotListTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.DatabaseSchemaTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.GetRegionIdTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.GetSeriesSlotListTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.GetTimeSlotListTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowAINodesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowClusterDetailsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowClusterIdTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowClusterTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowConfigNodesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowContinuousQueriesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowDataNodesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowFunctionsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowPipePluginsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowRegionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowTTLTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowTriggersTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowVariablesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ai.ShowAIDevicesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ai.ShowLoadedModelsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ai.ShowModelsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.region.ExtendRegionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.region.MigrateRegionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.region.ReconstructRegionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.region.RemoveRegionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.DeleteDeviceTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.DescribeTableDetailsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.DescribeTableTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowCreateTableTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowCreateViewTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowDBTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowTablesDetailsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowTablesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.template.ShowNodesInSchemaTemplateTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.template.ShowPathSetTemplateTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.template.ShowSchemaTemplateTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.ShowCurrentDatabaseTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.ShowCurrentSqlDialectTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.ShowCurrentTimestampTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.ShowCurrentUserTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.ShowVersionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.TestConnectionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.ShowPipeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.quota.ShowSpaceQuotaTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.quota.ShowThrottleQuotaTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.subscription.ShowSubscriptionsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.subscription.ShowTopicsTask;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.TransformToViewExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.view.AlterLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DeleteDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCluster;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Use;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.AlterEncodingCompressorStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountTimeSlotListStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateContinuousQueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTriggerStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DatabaseSchemaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DeleteDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DeleteTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.GetRegionIdStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.GetSeriesSlotListStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.GetTimeSlotListStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.RemoveAINodeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.RemoveConfigNodeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.RemoveDataNodeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.SetTTLStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowClusterStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowRegionStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.AlterPipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.CreatePipePluginStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.CreatePipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.DropPipePluginStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.DropPipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.ShowPipePluginsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.ShowPipesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.StartPipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.StopPipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.subscription.CreateTopicStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.subscription.DropSubscriptionStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.subscription.DropTopicStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.subscription.ShowSubscriptionsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.subscription.ShowTopicsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.AlterSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.DeactivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.DropSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowNodesInSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowPathSetTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.UnsetSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.AlterLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.CreateLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.DeleteLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.RenameLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.KillQueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.quota.SetSpaceQuotaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.quota.SetThrottleQuotaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.quota.ShowSpaceQuotaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.quota.ShowThrottleQuotaStatement;
import org.apache.iotdb.db.queryengine.plan.udf.UDFManagementService;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.schemaengine.rescon.DataNodeSchemaQuotaManager;
import org.apache.iotdb.db.schemaengine.table.InformationSchemaUtils;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.schemaengine.template.TemplateAlterOperationType;
import org.apache.iotdb.db.schemaengine.template.alter.TemplateAlterOperationUtil;
import org.apache.iotdb.db.schemaengine.template.alter.TemplateExtendInfo;
import org.apache.iotdb.db.service.DataNodeInternalRPCService;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairTaskStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.trigger.service.TriggerClassLoader;
import org.apache.iotdb.pipe.api.PipePlugin;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.trigger.api.Trigger;
import org.apache.iotdb.trigger.api.enums.FailureStrategy;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConfigTaskExecutor
implements IConfigTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterConfigTaskExecutor.class);
    private static final IClientManager<ConfigRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = ConfigNodeClientManager.getInstance();
    private static final IClientManager<ConfigRegionId, ConfigNodeClient> CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER = new IClientManager.Factory().createClientManager((IClientPoolFactory)new DataNodeClientPoolFactory.ClusterDeletionConfigNodeClientPoolFactory());
    private static final SettableFuture<ConfigTaskResult> SUBSCRIPTION_NOT_ENABLED_ERROR_FUTURE = SettableFuture.create();

    public static ClusterConfigTaskExecutor getInstance() {
        return ClusterConfigTaskExecutorHolder.INSTANCE;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setDatabase(DatabaseSchemaStatement databaseSchemaStatement) {
        SettableFuture future = SettableFuture.create();
        String databaseName = databaseSchemaStatement.getDatabasePath().getFullPath();
        if (databaseName.length() > 64 || "root".equals(databaseName)) {
            IllegalPathException illegalPathException = new IllegalPathException(databaseName, "root".equals(databaseName) ? "the database name in tree model must start with 'root.'." : "the length of database name shall not exceed 64");
            future.setException((Throwable)new IoTDBException(illegalPathException.getMessage(), illegalPathException.getErrorCode()));
            return future;
        }
        TDatabaseSchema databaseSchema = DatabaseSchemaTask.constructDatabaseSchema(databaseSchemaStatement);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.setDatabase(databaseSchema);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                if (TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode() == tsStatus.getCode() && !databaseSchemaStatement.getEnablePrintExceptionLog()) {
                    future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
                } else {
                    LOGGER.warn("Failed to execute create database {} in config node, status is {}.", (Object)databaseSchemaStatement.getDatabasePath(), (Object)tsStatus);
                    future.setException((Throwable)new IoTDBException(tsStatus));
                }
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> alterDatabase(DatabaseSchemaStatement databaseSchemaStatement) {
        SettableFuture future = SettableFuture.create();
        TDatabaseSchema databaseSchema = DatabaseSchemaTask.constructDatabaseSchema(databaseSchemaStatement);
        databaseSchema.setIsTableModel(false);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.alterDatabase(databaseSchema);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                if (databaseSchemaStatement.getEnablePrintExceptionLog()) {
                    LOGGER.warn("Failed to execute alter database {} in config node, status is {}.", (Object)databaseSchemaStatement.getDatabasePath(), (Object)tsStatus);
                }
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showDatabase(ShowDatabaseStatement showDatabaseStatement) {
        SettableFuture future = SettableFuture.create();
        List<String> databasePathPattern = Arrays.asList(showDatabaseStatement.getPathPattern().getNodes());
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetDatabaseReq req = new TGetDatabaseReq(databasePathPattern, showDatabaseStatement.getAuthorityScope().serialize()).setIsTableModel(false);
            TShowDatabaseResp resp = client.showDatabase(req);
            showDatabaseStatement.buildTSBlock(resp.getDatabaseInfoMap(), (SettableFuture<ConfigTaskResult>)future);
        }
        catch (IOException | ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> countDatabase(CountDatabaseStatement countDatabaseStatement) {
        SettableFuture future = SettableFuture.create();
        List<String> databasePathPattern = Arrays.asList(countDatabaseStatement.getPathPattern().getNodes());
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetDatabaseReq req = new TGetDatabaseReq(databasePathPattern, countDatabaseStatement.getAuthorityScope().serialize());
            TCountDatabaseResp resp = client.countMatchedDatabases(req);
            int databaseNum = resp.getCount();
            CountDatabaseTask.buildTSBlock(databaseNum, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (IOException | ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deleteDatabase(DeleteDatabaseStatement deleteDatabaseStatement) {
        SettableFuture future = SettableFuture.create();
        TDeleteDatabasesReq req = new TDeleteDatabasesReq(deleteDatabaseStatement.getPrefixPath()).setIsTableModel(false);
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = client.deleteDatabases(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute delete database {} in config node, status is {}.", deleteDatabaseStatement.getPrefixPath(), (Object)tsStatus);
                if (tsStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    future.setException((Throwable)((Object)new BatchProcessException(tsStatus.subStatus.toArray(new TSStatus[0]))));
                } else {
                    future.setException((Throwable)new IoTDBException(tsStatus));
                }
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Exception decompiling
     */
    @Override
    public SettableFuture<ConfigTaskResult> createFunction(Model model, String udfName, String className, Optional<String> stringURI, Class<?> baseClazz) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropFunction(Model model, String udfName) {
        SettableFuture future = SettableFuture.create();
        if (UDFManagementService.getInstance().checkIsBuiltInFunctionName(model, udfName)) {
            future.setException((Throwable)new IoTDBException(String.format("Built-in function %s can not be deregistered.", udfName.toUpperCase()), TSStatusCode.DROP_UDF_ERROR.getStatusCode()));
            return future;
        }
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus executionStatus = client.dropFunction(new TDropFunctionReq(udfName).setModel(model));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to drop function {}.", (Object)executionStatus, (Object)udfName);
                future.setException((Throwable)new IoTDBException(executionStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showFunctions(Model model) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetUDFTableResp getUDFTableResp = client.getUDFTable(new TGetUdfTableReq(model));
            if (getUDFTableResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(getUDFTableResp.getStatus().message, getUDFTableResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowFunctionsTask.buildTsBlock(model, getUDFTableResp.getAllUDFInformation(), (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> createTrigger(CreateTriggerStatement createTriggerStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCreateTriggerReq tCreateTriggerReq = new TCreateTriggerReq(createTriggerStatement.getTriggerName(), createTriggerStatement.getClassName(), createTriggerStatement.getTriggerEvent().getId(), createTriggerStatement.getTriggerType().getId(), createTriggerStatement.getPathPattern().serialize(), createTriggerStatement.getAttributes(), FailureStrategy.OPTIMISTIC.getId(), createTriggerStatement.isUsingURI());
            String libRoot = TriggerExecutableManager.getInstance().getLibRoot();
            if (createTriggerStatement.isUsingURI()) {
                String jarMd5;
                ByteBuffer jarFile;
                String jarFileName;
                block27: {
                    URI uri;
                    String uriString = createTriggerStatement.getUriString();
                    if (uriString == null || uriString.isEmpty()) {
                        future.setException((Throwable)new IoTDBException("URI is empty, please specify the URI.", TSStatusCode.TRIGGER_DOWNLOAD_ERROR.getStatusCode()));
                        SettableFuture settableFuture = future;
                        return settableFuture;
                    }
                    jarFileName = new File(uriString).getName();
                    try {
                        uri = new URI(uriString);
                        if (uri.getScheme() == null) {
                            future.setException((Throwable)new IoTDBException("The scheme of URI is not set, please specify the scheme of URI.", TSStatusCode.TRIGGER_DOWNLOAD_ERROR.getStatusCode()));
                            SettableFuture settableFuture = future;
                            return settableFuture;
                        }
                    }
                    catch (IOException | URISyntaxException e) {
                        LOGGER.warn("Failed to get executable for Trigger({}) using URI: {}.", new Object[]{createTriggerStatement.getTriggerName(), createTriggerStatement.getUriString(), e});
                        future.setException((Throwable)new IoTDBException("Failed to get executable for Trigger '" + createTriggerStatement.getUriString() + "', please check the URI.", TSStatusCode.TRIGGER_DOWNLOAD_ERROR.getStatusCode()));
                        SettableFuture resource = future;
                        if (client == null) return resource;
                        client.close();
                        return resource;
                    }
                    {
                        if (!uri.getScheme().equals("file")) {
                            String jarFilePathUnderTempDir;
                            ExecutableResource resource = TriggerExecutableManager.getInstance().request(Collections.singletonList(uriString));
                            libRoot = jarFilePathUnderTempDir = TriggerExecutableManager.getInstance().getDirStringUnderTempRootByRequestId(resource.getRequestId()) + jarFileName;
                            jarFile = ExecutableManager.transferToBytebuffer((String)jarFilePathUnderTempDir);
                            jarMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(jarFilePathUnderTempDir, new String[0]), new OpenOption[0]));
                            break block27;
                        }
                        libRoot = new File(new URI(uriString)).getAbsolutePath();
                        jarFile = ExecutableManager.transferToBytebuffer((String)libRoot);
                        jarMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(libRoot, new String[0]), new OpenOption[0]));
                    }
                }
                tCreateTriggerReq.setJarFile(jarFile);
                tCreateTriggerReq.setJarMD5(jarMd5);
                tCreateTriggerReq.setIsUsingURI(true);
                tCreateTriggerReq.setJarName(String.format("%s-%s.%s", jarFileName.substring(0, jarFileName.lastIndexOf(".")), jarMd5, jarFileName.substring(jarFileName.lastIndexOf(".") + 1)));
            }
            try (TriggerClassLoader classLoader = new TriggerClassLoader(libRoot);){
                Class<?> triggerClass = Class.forName(createTriggerStatement.getClassName(), true, classLoader);
                Trigger trigger = (Trigger)triggerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                tCreateTriggerReq.setFailureStrategy(trigger.getFailureStrategy().getId());
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.warn("Failed to create trigger when try to create trigger({}) instance first.", (Object)createTriggerStatement.getTriggerName(), (Object)e);
                future.setException((Throwable)new IoTDBException("Failed to load class '" + createTriggerStatement.getClassName() + "', because it's not found in jar file or is invalid: " + createTriggerStatement.getUriString(), TSStatusCode.TRIGGER_LOAD_CLASS_ERROR.getStatusCode()));
                SettableFuture settableFuture = future;
                if (client == null) return settableFuture;
                client.close();
                return settableFuture;
            }
            TSStatus executionStatus = client.createTrigger(tCreateTriggerReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to create trigger {}. TSStatus is {}", new Object[]{executionStatus, createTriggerStatement.getTriggerName(), executionStatus.message});
                future.setException((Throwable)new IoTDBException(executionStatus));
                return future;
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (IOException | ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropTrigger(String triggerName) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus executionStatus = client.dropTrigger(new TDropTriggerReq(triggerName));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to drop trigger {}.", (Object)executionStatus, (Object)triggerName);
                future.setException((Throwable)new IoTDBException(executionStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showTriggers() {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetTriggerTableResp getTriggerTableResp = client.getTriggerTable();
            if (getTriggerTableResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(getTriggerTableResp.getStatus().message, getTriggerTableResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowTriggersTask.buildTsBlock(getTriggerTableResp.getAllTriggerInformation(), (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> createPipePlugin(CreatePipePluginStatement createPipePluginStatement) {
        SettableFuture future = SettableFuture.create();
        String pluginName = createPipePluginStatement.getPluginName();
        String className = createPipePluginStatement.getClassName();
        String uriString = createPipePluginStatement.getUriString();
        String pathError = FileUtils.getIllegalError4Directory((String)pluginName);
        if (Objects.nonNull(pathError)) {
            future.setException((Throwable)new IoTDBException(String.format("Failed to create pipe plugin %s. " + pathError, pluginName), TSStatusCode.CREATE_PIPE_PLUGIN_ERROR.getStatusCode()));
            return future;
        }
        if (uriString == null || uriString.isEmpty()) {
            future.setException((Throwable)new IoTDBException("Failed to create pipe plugin, because the URI is empty.", TSStatusCode.PIPE_PLUGIN_DOWNLOAD_ERROR.getStatusCode()));
            return future;
        }
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            Class<?> clazz;
            PipePluginClassLoader classLoader;
            String jarMd5;
            ByteBuffer jarFile;
            String jarFileName;
            block30: {
                String libRoot;
                URI uri;
                block28: {
                    jarFileName = new File(uriString).getName();
                    uri = new URI(uriString);
                    if (uri.getScheme() != null) break block28;
                    future.setException((Throwable)new IoTDBException("The scheme of URI is not set, please specify the scheme of URI.", TSStatusCode.PIPE_PLUGIN_DOWNLOAD_ERROR.getStatusCode()));
                    SettableFuture settableFuture = future;
                    return settableFuture;
                }
                try {
                    if (!uri.getScheme().equals("file")) {
                        String jarFilePathUnderTempDir;
                        ExecutableResource resource = PipePluginExecutableManager.getInstance().request(Collections.singletonList(uriString));
                        libRoot = jarFilePathUnderTempDir = PipePluginExecutableManager.getInstance().getDirStringUnderTempRootByRequestId(resource.getRequestId()) + jarFileName;
                        jarFile = ExecutableManager.transferToBytebuffer((String)jarFilePathUnderTempDir);
                        jarMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(jarFilePathUnderTempDir, new String[0]), new OpenOption[0]));
                    } else {
                        libRoot = new File(new URI(uriString)).getAbsolutePath();
                        jarFile = ExecutableManager.transferToBytebuffer((String)libRoot);
                        jarMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(libRoot, new String[0]), new OpenOption[0]));
                    }
                }
                catch (IOException | URISyntaxException e) {
                    LOGGER.warn("Failed to get executable for PipePlugin({}) using URI: {}.", new Object[]{createPipePluginStatement.getPluginName(), createPipePluginStatement.getUriString(), e});
                    future.setException((Throwable)new IoTDBException("Failed to get executable for PipePlugin" + createPipePluginStatement.getPluginName() + "', please check the URI.", TSStatusCode.PIPE_PLUGIN_DOWNLOAD_ERROR.getStatusCode()));
                    SettableFuture resource = future;
                    if (client == null) return resource;
                    client.close();
                    return resource;
                }
                classLoader = new PipePluginClassLoader(libRoot);
                clazz = Class.forName(createPipePluginStatement.getClassName(), true, (ClassLoader)classLoader);
                Visibility pluginVisibility = VisibilityUtils.calculateFromPluginClass(clazz);
                boolean isTableModel = createPipePluginStatement.isTableModel();
                if (VisibilityUtils.isCompatible((Visibility)pluginVisibility, (boolean)isTableModel)) break block30;
                LOGGER.warn("Failed to create PipePlugin({}) because this plugin is not designed for {} model.", (Object)createPipePluginStatement.getPluginName(), (Object)(isTableModel ? "table" : "tree"));
                future.setException((Throwable)new IoTDBException("Failed to create PipePlugin '" + createPipePluginStatement.getPluginName() + "', because this plugin is not designed for " + (isTableModel ? "table" : "tree") + " model.", TSStatusCode.PIPE_PLUGIN_LOAD_CLASS_ERROR.getStatusCode()));
                SettableFuture settableFuture = future;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                classLoader.close();
                return settableFuture;
            }
            try {
                try {
                    PipePlugin pipePlugin = (PipePlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                finally {
                    classLoader.close();
                }
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.warn("Failed to create function when try to create PipePlugin({}) instance first.", (Object)createPipePluginStatement.getPluginName(), (Object)e);
                future.setException((Throwable)new IoTDBException("Failed to load class '" + createPipePluginStatement.getClassName() + "', because it's not found in jar file or is invalid: " + createPipePluginStatement.getUriString(), TSStatusCode.PIPE_PLUGIN_LOAD_CLASS_ERROR.getStatusCode()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            TSStatus executionStatus = client.createPipePlugin(new TCreatePipePluginReq().setPluginName(pluginName).setIfNotExistsCondition(createPipePluginStatement.hasIfNotExistsCondition()).setClassName(className).setJarFile(jarFile).setJarMD5(jarMd5).setJarName(String.format("%s-%s.%s", jarFileName.substring(0, jarFileName.lastIndexOf(".")), jarMd5, jarFileName.substring(jarFileName.lastIndexOf(".") + 1))));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("Failed to create PipePlugin {}({}) because {}", new Object[]{pluginName, className, executionStatus.getMessage()});
                future.setException((Throwable)new IoTDBException(executionStatus));
                return future;
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (IOException | ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropPipePlugin(DropPipePluginStatement dropPipePluginStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus executionStatus = client.dropPipePlugin(new TDropPipePluginReq().setPluginName(dropPipePluginStatement.getPluginName()).setIfExistsCondition(dropPipePluginStatement.hasIfExistsCondition()).setIsTableModel(dropPipePluginStatement.isTableModel()));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to drop pipe plugin {}.", (Object)executionStatus, (Object)dropPipePluginStatement.getPluginName());
                future.setException((Throwable)new IoTDBException(executionStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showPipePlugins(ShowPipePluginsStatement showPipePluginsStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetPipePluginTableResp getPipePluginTableResp = client.getPipePluginTableExtended(new TShowPipePluginReq().setIsTableModel(showPipePluginsStatement.isTableModel()));
            if (getPipePluginTableResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(getPipePluginTableResp.getStatus().message, getPipePluginTableResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowPipePluginsTask.buildTsBlock(getPipePluginTableResp.getAllPipePluginMeta(), (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setTTL(SetTTLStatement setTTLStatement, String taskName) {
        SettableFuture future = SettableFuture.create();
        List<String> pathPattern = Arrays.asList(setTTLStatement.getPath().getNodes());
        TSetTTLReq setTTLReq = new TSetTTLReq(pathPattern, setTTLStatement.getTTL(), false);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.setTTL(setTTLReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute {} {} in config node, status is {}.", new Object[]{taskName, setTTLStatement.getPath(), tsStatus});
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> merge(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                tsStatus = client.merge();
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            try {
                StorageEngine.getInstance().mergeAll();
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            catch (StorageEngineException e) {
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
            }
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> flush(TFlushReq tFlushReq, boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                tsStatus = client.flush(tFlushReq);
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            try {
                StorageEngine.getInstance().operateFlush(tFlushReq);
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            catch (Exception e) {
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
            }
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> clearCache(boolean onCluster, Set<CacheClearOptions> options) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                tsStatus = client.clearCache(options.stream().map(Enum::ordinal).collect(Collectors.toSet()));
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            tsStatus = DataNodeInternalRPCService.getInstance().getImpl().clearCacheImpl(options);
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setConfiguration(TSetConfigurationReq req) {
        boolean onLocal;
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        List ignoredConfigItems = ConfigurationFileUtils.filterInvalidConfigItems((Map)req.getConfigs());
        TSStatus warningTsStatus = null;
        if (!ignoredConfigItems.isEmpty()) {
            warningTsStatus = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            warningTsStatus.setMessage("ignored config items: " + ignoredConfigItems + " because they are immutable or undefined.");
            if (req.getConfigs().isEmpty()) {
                future.setException((Throwable)new IoTDBException(warningTsStatus));
                return future;
            }
        }
        boolean bl = onLocal = IoTDBDescriptor.getInstance().getConfig().getDataNodeId() == req.getNodeId();
        if (onLocal) {
            tsStatus = StorageEngine.getInstance().setConfiguration(req);
        } else {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                tsStatus = client.setConfiguration(req);
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        }
        if (warningTsStatus != null) {
            tsStatus = warningTsStatus;
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> startRepairData(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                tsStatus = client.startRepairData();
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            if (!StorageEngine.getInstance().isReadyForNonReadWriteFunctions()) {
                future.setException((Throwable)new IoTDBException("not all sg is ready", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
                return future;
            }
            if (!CompactionTaskManager.getInstance().isInit()) {
                future.setException((Throwable)new IoTDBException("cannot start repair task because compaction is not enabled", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
                return future;
            }
            try {
                tsStatus = StorageEngine.getInstance().repairData() ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS) : (CompactionScheduleTaskManager.getRepairTaskManagerInstance().getRepairTaskStatus() == RepairTaskStatus.STOPPING ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"previous repair task is still stopping") : RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"already have a running repair task"));
            }
            catch (Exception e) {
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
            }
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> stopRepairData(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                tsStatus = client.stopRepairData();
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            try {
                StorageEngine.getInstance().stopRepairData();
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            catch (StorageEngineException e) {
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
            }
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> loadConfiguration(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                tsStatus = client.submitLoadConfigurationTask();
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            try {
                IoTDBDescriptor.getInstance().loadHotModifiedProps();
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            catch (Exception e) {
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
            }
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new StatementExecutionException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setSystemStatus(boolean onCluster, NodeStatus status) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                tsStatus = client.setSystemStatus(status.getStatus());
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            try {
                CommonDescriptor.getInstance().getConfig().setNodeStatus(status);
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            catch (Exception e) {
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
            }
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new StatementExecutionException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> killQuery(KillQueryStatement killQueryStatement) {
        int dataNodeId = -1;
        String queryId = killQueryStatement.getQueryId();
        SettableFuture future = SettableFuture.create();
        if (!killQueryStatement.isKillAll()) {
            String[] splits = queryId.split("_");
            try {
                if (splits.length != 4 || (dataNodeId = Integer.parseInt(splits[3])) < 0) {
                    future.setException((Throwable)new IoTDBException("Please ensure your input <queryId> is correct", TSStatusCode.SEMANTIC_ERROR.getStatusCode(), true));
                    return future;
                }
            }
            catch (NumberFormatException e) {
                future.setException((Throwable)new IoTDBException("Please ensure your input <queryId> is correct", TSStatusCode.SEMANTIC_ERROR.getStatusCode(), true));
                return future;
            }
        }
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus executionStatus = client.killQuery(queryId, dataNodeId);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(executionStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showCluster(ShowClusterStatement showClusterStatement) {
        SettableFuture future = SettableFuture.create();
        TShowClusterResp showClusterResp = new TShowClusterResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            showClusterResp = client.showCluster();
        }
        catch (ClientManagerException | TException e) {
            if (showClusterResp.getConfigNodeList() == null) {
                future.setException((Throwable)new TException("Fail to connect to any config node. Please check status of ConfigNodes or logs of connected DataNode"));
            } else {
                future.setException(e);
            }
            return future;
        }
        if (showClusterStatement.isDetails()) {
            ShowClusterDetailsTask.buildTSBlock(showClusterResp, (SettableFuture<ConfigTaskResult>)future);
        } else {
            ShowClusterTask.buildTsBlock(showClusterResp, (SettableFuture<ConfigTaskResult>)future);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showClusterParameters() {
        SettableFuture future = SettableFuture.create();
        TShowVariablesResp showVariablesResp = new TShowVariablesResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            showVariablesResp = client.showVariables();
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        ShowVariablesTask.buildTSBlock(showVariablesResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showClusterId() {
        SettableFuture future = SettableFuture.create();
        ShowClusterIdTask.buildTSBlock(IoTDBDescriptor.getInstance().getConfig().getClusterId(), (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showVersion() {
        SettableFuture future = SettableFuture.create();
        ShowVersionTask.buildTsBlock((SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showCurrentSqlDialect(String sqlDialect) {
        SettableFuture future = SettableFuture.create();
        ShowCurrentSqlDialectTask.buildTsBlock(sqlDialect, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setSqlDialect(IClientSession.SqlDialect sqlDialect) {
        SettableFuture future = SettableFuture.create();
        try {
            SessionManager.getInstance().getCurrSession().setSqlDialectAndClean(sqlDialect);
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showCurrentDatabase(@Nullable String currentDatabase) {
        SettableFuture future = SettableFuture.create();
        ShowCurrentDatabaseTask.buildTsBlock(currentDatabase, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showCurrentUser(String currentUser) {
        SettableFuture future = SettableFuture.create();
        ShowCurrentUserTask.buildTsBlock(currentUser, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showCurrentTimestamp() {
        SettableFuture future = SettableFuture.create();
        ShowCurrentTimestampTask.buildTsBlock((SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> testConnection(boolean needDetails) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TTestConnectionResp result = client.submitTestConnectionTaskToLeader();
            int configNodeNum = 0;
            int dataNodeNum = 0;
            if (!needDetails) {
                configNodeNum = client.showConfigNodes().getConfigNodesInfoListSize();
                dataNodeNum = client.showDataNodes().getDataNodesInfoListSize();
            }
            TestConnectionTask.buildTSBlock(result, configNodeNum, dataNodeNum, needDetails, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showTTL(ShowTTLStatement showTTLStatement) {
        SettableFuture future = SettableFuture.create();
        TreeMap<String, Long> databaseToTTL = new TreeMap<String, Long>();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            for (PartialPath pathPattern : showTTLStatement.getPaths()) {
                TShowTTLReq req = new TShowTTLReq(Arrays.asList(pathPattern.getNodes()));
                TShowTTLResp resp = client.showTTL(req);
                databaseToTTL.putAll(resp.getPathTTLMap());
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        ShowTTLTask.buildTSBlock(databaseToTTL, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showRegion(ShowRegionStatement showRegionStatement, boolean isTableModel) {
        SettableFuture future = SettableFuture.create();
        TShowRegionResp showRegionResp = new TShowRegionResp();
        TShowRegionReq showRegionReq = new TShowRegionReq().setIsTableModel(isTableModel);
        showRegionReq.setConsensusGroupType(showRegionStatement.getRegionType());
        if (showRegionStatement.getDatabases() == null) {
            showRegionReq.setDatabases(null);
        } else {
            showRegionReq.setDatabases(showRegionStatement.getDatabases().stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
        }
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            showRegionResp = client.showRegion(showRegionReq);
            if (showRegionResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showRegionResp.getStatus().message, showRegionResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        if (showRegionStatement.getNodeIds() != null) {
            List regionInfos = showRegionResp.getRegionInfoList();
            regionInfos = regionInfos.stream().filter(regionInfo -> showRegionStatement.getNodeIds().contains(regionInfo.getDataNodeId())).collect(Collectors.toList());
            showRegionResp.setRegionInfoList(regionInfos);
        }
        ShowRegionTask.buildTSBlock(showRegionResp, (SettableFuture<ConfigTaskResult>)future, isTableModel);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showDataNodes() {
        SettableFuture future = SettableFuture.create();
        TShowDataNodesResp showDataNodesResp = new TShowDataNodesResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            showDataNodesResp = client.showDataNodes();
            if (showDataNodesResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showDataNodesResp.getStatus().message, showDataNodesResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        ShowDataNodesTask.buildTSBlock(showDataNodesResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showConfigNodes() {
        SettableFuture future = SettableFuture.create();
        TShowConfigNodesResp showConfigNodesResp = new TShowConfigNodesResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            showConfigNodesResp = client.showConfigNodes();
            if (showConfigNodesResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showConfigNodesResp.getStatus().message, showConfigNodesResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        ShowConfigNodesTask.buildTSBlock(showConfigNodesResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showAINodes() {
        SettableFuture future = SettableFuture.create();
        TShowAINodesResp resp = new TShowAINodesResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            resp = client.showAINodes();
            if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(resp.getStatus()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        ShowAINodesTask.buildTsBlock(resp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createSchemaTemplate(CreateSchemaTemplateStatement createSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            TSStatus tsStatus = ClusterTemplateManager.getInstance().createSchemaTemplate(createSchemaTemplateStatement);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException(e.getCause());
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showSchemaTemplate(ShowSchemaTemplateStatement showSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            List<Template> templateList = ClusterTemplateManager.getInstance().getAllTemplates();
            ShowSchemaTemplateTask.buildTSBlock(templateList, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showNodesInSchemaTemplate(ShowNodesInSchemaTemplateStatement showNodesInSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        String req = showNodesInSchemaTemplateStatement.getTemplateName();
        try {
            Template template = ClusterTemplateManager.getInstance().getTemplate(req);
            ShowNodesInSchemaTemplateTask.buildTSBlock(template, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setSchemaTemplate(String queryId, SetSchemaTemplateStatement setSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        String templateName = setSchemaTemplateStatement.getTemplateName();
        PartialPath path = setSchemaTemplateStatement.getPath();
        try {
            ClusterTemplateManager.getInstance().setSchemaTemplate(queryId, templateName, path);
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Throwable e) {
            if (e.getCause() instanceof IoTDBException) {
                future.setException(e.getCause());
            }
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showPathSetTemplate(ShowPathSetTemplateStatement showPathSetTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            List<PartialPath> listPath = ClusterTemplateManager.getInstance().getPathsSetTemplate(showPathSetTemplateStatement.getTemplateName(), showPathSetTemplateStatement.getAuthorityScope());
            ShowPathSetTemplateTask.buildTSBlock(listPath, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deactivateSchemaTemplate(String queryId, DeactivateTemplateStatement deactivateTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        TDeactivateSchemaTemplateReq req = new TDeactivateSchemaTemplateReq();
        req.setQueryId(queryId);
        req.setTemplateName(deactivateTemplateStatement.getTemplateName());
        req.setPathPatternTree(this.serializePatternListToByteBuffer(deactivateTemplateStatement.getPathPatternList()));
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.deactivateSchemaTemplate(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropSchemaTemplate(DropSchemaTemplateStatement dropSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.dropSchemaTemplate(dropSchemaTemplateStatement.getTemplateName());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> alterSchemaTemplate(String queryId, AlterSchemaTemplateStatement alterSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        if (alterSchemaTemplateStatement.getOperationType().equals((Object)TemplateAlterOperationType.EXTEND_TEMPLATE)) {
            TemplateExtendInfo templateExtendInfo = (TemplateExtendInfo)alterSchemaTemplateStatement.getTemplateAlterInfo();
            String duplicateMeasurement = templateExtendInfo.getFirstDuplicateMeasurement();
            if (duplicateMeasurement != null) {
                future.setException((Throwable)new MetadataException(String.format("Duplicated measurement [%s] in device template alter request", duplicateMeasurement)));
                return future;
            }
            long localNeedQuota = (long)templateExtendInfo.getMeasurements().size() * (long)SchemaEngine.getInstance().getSchemaEngineStatistics().getTemplateUsingNumber(templateExtendInfo.getTemplateName());
            if (localNeedQuota != 0L) {
                try {
                    DataNodeSchemaQuotaManager.getInstance().check(localNeedQuota, 0);
                }
                catch (SchemaQuotaExceededException e) {
                    future.setException((Throwable)((Object)e));
                    return future;
                }
            }
        }
        TAlterSchemaTemplateReq req = new TAlterSchemaTemplateReq();
        req.setQueryId(queryId);
        req.setTemplateAlterInfo(TemplateAlterOperationUtil.generateExtendTemplateReqInfo(alterSchemaTemplateStatement.getOperationType(), alterSchemaTemplateStatement.getTemplateAlterInfo()));
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.alterSchemaTemplate(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    private ByteBuffer serializePatternListToByteBuffer(List<PartialPath> patternList) {
        PathPatternTree patternTree = new PathPatternTree();
        patternList.forEach(arg_0 -> ((PathPatternTree)patternTree).appendPathPattern(arg_0));
        patternTree.constructTree();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            patternTree.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public SettableFuture<ConfigTaskResult> unsetSchemaTemplate(String queryId, UnsetSchemaTemplateStatement unsetSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        TUnsetSchemaTemplateReq req = new TUnsetSchemaTemplateReq();
        req.setQueryId(queryId);
        req.setTemplateName(unsetSchemaTemplateStatement.getTemplateName());
        req.setPath(unsetSchemaTemplateStatement.getPath().getFullPath());
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.unsetSchemaTemplate(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createPipe(CreatePipeStatement createPipeStatement) {
        SettableFuture future = SettableFuture.create();
        String pipeName = createPipeStatement.getPipeName();
        if (!Objects.equals(TSFileDescriptor.getInstance().getConfig().getEncryptType(), "UNENCRYPTED") && !Objects.equals(TSFileDescriptor.getInstance().getConfig().getEncryptType(), "org.apache.tsfile.encrypt.UNENCRYPTED")) {
            future.setException((Throwable)new IoTDBException(String.format("Failed to create Pipe %s because TSFile is configured with encryption, which prohibits the use of Pipe", pipeName), TSStatusCode.PIPE_ERROR.getStatusCode()));
            return future;
        }
        if (pipeName.startsWith("__")) {
            future.setException((Throwable)new IoTDBException(String.format("Failed to create pipe %s, pipe name starting with \"%s\" are not allowed to be created.", pipeName, "__"), TSStatusCode.PIPE_ERROR.getStatusCode()));
            return future;
        }
        String pathError = FileUtils.getIllegalError4Directory((String)pipeName);
        if (Objects.nonNull(pathError)) {
            future.setException((Throwable)new IoTDBException(String.format("Failed to create pipe %s, " + pathError, pipeName), TSStatusCode.PIPE_ERROR.getStatusCode()));
            return future;
        }
        try {
            PipeDataNodeAgent.plugin().validate(pipeName, createPipeStatement.getExtractorAttributes(), createPipeStatement.getProcessorAttributes(), createPipeStatement.getConnectorAttributes());
        }
        catch (Exception e) {
            future.setException((Throwable)new IoTDBException(e.getMessage(), TSStatusCode.PIPE_ERROR.getStatusCode()));
            return future;
        }
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCreatePipeReq req = new TCreatePipeReq().setPipeName(pipeName).setIfNotExistsCondition(createPipeStatement.hasIfNotExistsCondition()).setExtractorAttributes(createPipeStatement.getExtractorAttributes()).setProcessorAttributes(createPipeStatement.getProcessorAttributes()).setConnectorAttributes(createPipeStatement.getConnectorAttributes());
            TSStatus tsStatus = configNodeClient.createPipe(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> alterPipe(AlterPipeStatement alterPipeStatement) {
        PipeMeta pipeMetaFromCoordinator;
        SettableFuture future = SettableFuture.create();
        if (alterPipeStatement.getPipeName().startsWith("__")) {
            future.setException((Throwable)new IoTDBException(String.format("Failed to alter pipe %s, pipe name starting with \"%s\" are not allowed to be altered.", alterPipeStatement.getPipeName(), "__"), TSStatusCode.PIPE_ERROR.getStatusCode()));
            return future;
        }
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetAllPipeInfoResp getAllPipeInfoResp = configNodeClient.getAllPipeInfo();
            if (getAllPipeInfoResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(String.format("Failed to get pipe info from config node, status is %s.", getAllPipeInfoResp.getStatus()), TSStatusCode.PIPE_ERROR.getStatusCode()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            pipeMetaFromCoordinator = getAllPipeInfoResp.getAllPipeInfo().stream().map(PipeMeta::deserialize4Coordinator).filter(pipeMeta -> pipeMeta.getStaticMeta().getPipeName().equals(alterPipeStatement.getPipeName())).findFirst().orElse(null);
            if (pipeMetaFromCoordinator == null) {
                future.setException((Throwable)new IoTDBException(String.format("Failed to alter pipe %s, pipe not found in system.", alterPipeStatement.getPipeName()), TSStatusCode.PIPE_ERROR.getStatusCode()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (Exception e) {
            future.setException((Throwable)new IoTDBException(String.format("Failed to alter pipe %s, because %s", alterPipeStatement.getPipeName(), e.getMessage()), TSStatusCode.PIPE_ERROR.getStatusCode()));
            return future;
        }
        String pipeName = alterPipeStatement.getPipeName();
        try {
            Map connectorAttributes;
            Map processorAttributes;
            Map extractorAttributes;
            block39: {
                block38: {
                    boolean onlyContainsUser;
                    block37: {
                        block36: {
                            if (alterPipeStatement.getExtractorAttributes().isEmpty()) break block36;
                            if (alterPipeStatement.getExtractorAttributes().containsKey("extractor") || alterPipeStatement.getExtractorAttributes().containsKey("source") || alterPipeStatement.isReplaceAllExtractorAttributes()) {
                                ClusterConfigTaskExecutor.checkIfSourcePluginChanged(pipeMetaFromCoordinator.getStaticMeta().getSourceParameters(), new PipeParameters(alterPipeStatement.getExtractorAttributes()));
                            }
                            if (alterPipeStatement.isReplaceAllExtractorAttributes()) {
                                extractorAttributes = alterPipeStatement.getExtractorAttributes();
                                break block37;
                            } else {
                                onlyContainsUser = ClusterConfigTaskExecutor.onlyContainsUser(alterPipeStatement.getExtractorAttributes());
                                pipeMetaFromCoordinator.getStaticMeta().getSourceParameters().addOrReplaceEquivalentAttributes(new PipeParameters(alterPipeStatement.getExtractorAttributes()));
                                extractorAttributes = pipeMetaFromCoordinator.getStaticMeta().getSourceParameters().getAttribute();
                                if (onlyContainsUser) {
                                    ClusterConfigTaskExecutor.checkSourceType(alterPipeStatement.getPipeName(), extractorAttributes);
                                }
                            }
                            break block37;
                        }
                        extractorAttributes = pipeMetaFromCoordinator.getStaticMeta().getSourceParameters().getAttribute();
                    }
                    if (!alterPipeStatement.getProcessorAttributes().isEmpty()) {
                        if (alterPipeStatement.isReplaceAllProcessorAttributes()) {
                            processorAttributes = alterPipeStatement.getProcessorAttributes();
                        } else {
                            pipeMetaFromCoordinator.getStaticMeta().getProcessorParameters().addOrReplaceEquivalentAttributes(new PipeParameters(alterPipeStatement.getProcessorAttributes()));
                            processorAttributes = pipeMetaFromCoordinator.getStaticMeta().getProcessorParameters().getAttribute();
                        }
                    } else {
                        processorAttributes = pipeMetaFromCoordinator.getStaticMeta().getProcessorParameters().getAttribute();
                    }
                    if (alterPipeStatement.getConnectorAttributes().isEmpty()) break block38;
                    if (alterPipeStatement.isReplaceAllConnectorAttributes()) {
                        connectorAttributes = alterPipeStatement.getConnectorAttributes();
                        break block39;
                    } else {
                        onlyContainsUser = ClusterConfigTaskExecutor.onlyContainsUser(alterPipeStatement.getConnectorAttributes());
                        pipeMetaFromCoordinator.getStaticMeta().getSinkParameters().addOrReplaceEquivalentAttributes(new PipeParameters(alterPipeStatement.getConnectorAttributes()));
                        connectorAttributes = pipeMetaFromCoordinator.getStaticMeta().getSinkParameters().getAttribute();
                        if (onlyContainsUser) {
                            ClusterConfigTaskExecutor.checkSinkType(alterPipeStatement.getPipeName(), connectorAttributes);
                        }
                    }
                    break block39;
                }
                connectorAttributes = pipeMetaFromCoordinator.getStaticMeta().getSinkParameters().getAttribute();
            }
            PipeDataNodeAgent.plugin().validate(pipeName, extractorAttributes, processorAttributes, connectorAttributes);
        }
        catch (Exception e) {
            future.setException((Throwable)new IoTDBException(e.getMessage(), TSStatusCode.PIPE_ERROR.getStatusCode()));
            return future;
        }
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TAlterPipeReq req = new TAlterPipeReq(pipeName, alterPipeStatement.getProcessorAttributes(), alterPipeStatement.getConnectorAttributes(), alterPipeStatement.isReplaceAllProcessorAttributes(), alterPipeStatement.isReplaceAllConnectorAttributes());
            req.setExtractorAttributes(alterPipeStatement.getExtractorAttributes());
            req.setIsReplaceAllExtractorAttributes(alterPipeStatement.isReplaceAllExtractorAttributes());
            req.setIfExistsCondition(alterPipeStatement.hasIfExistsCondition());
            req.setIsTableModel(alterPipeStatement.isTableModel());
            TSStatus tsStatus = configNodeClient.alterPipe(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus));
                return future;
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    private static void checkIfSourcePluginChanged(PipeParameters oldPipeParameters, PipeParameters newPipeParameters) {
        String oldPluginName = oldPipeParameters.getStringOrDefault(Arrays.asList("extractor", "source"), BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName()).toLowerCase();
        String newPluginName = newPipeParameters.getStringOrDefault(Arrays.asList("extractor", "source"), BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName()).toLowerCase();
        if (!PipeDataNodeAgent.plugin().checkIfPluginSameType(oldPluginName, newPluginName)) {
            throw new SemanticException(String.format("Failed to alter pipe, the source plugin of the pipe cannot be changed from %s to %s", oldPluginName, newPluginName));
        }
    }

    private static void checkSourceType(String pipeName, Map<String, String> replacedExtractorAttributes) {
        PipeParameters extractorParameters = new PipeParameters(replacedExtractorAttributes);
        String pluginName = extractorParameters.getStringOrDefault(Arrays.asList("extractor", "source"), BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName()).toLowerCase();
        if (pluginName.equals(BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName()) || pluginName.equals(BuiltinPipePlugin.IOTDB_SOURCE.getPipePluginName())) {
            throw new SemanticException(String.format("Failed to alter pipe %s, in iotdb-source, password must be set when the username is specified.", pipeName));
        }
    }

    private static boolean onlyContainsUser(Map<String, String> extractorOrConnectorAttributes) {
        PipeParameters extractorOrConnectorParameters = new PipeParameters(extractorOrConnectorAttributes);
        return extractorOrConnectorParameters.hasAnyAttributes(new String[]{"connector.user", "sink.user", "connector.username", "sink.username"}) && !extractorOrConnectorParameters.hasAnyAttributes(new String[]{"connector.password", "sink.password"});
    }

    private static void checkSinkType(String pipeName, Map<String, String> connectorAttributes) {
        PipeParameters connectorParameters = new PipeParameters(connectorAttributes);
        String pluginName = connectorParameters.getStringOrDefault(Arrays.asList("connector", "sink"), BuiltinPipePlugin.IOTDB_THRIFT_SINK.getPipePluginName()).toLowerCase();
        if (pluginName.equals(BuiltinPipePlugin.WRITE_BACK_CONNECTOR.getPipePluginName()) || pluginName.equals(BuiltinPipePlugin.WRITE_BACK_SINK.getPipePluginName())) {
            throw new SemanticException(String.format("Failed to alter pipe %s, in write-back-sink, password must be set when the username is specified.", pipeName));
        }
    }

    @Override
    public SettableFuture<ConfigTaskResult> startPipe(StartPipeStatement startPipeStatement) {
        SettableFuture future = SettableFuture.create();
        if (startPipeStatement.getPipeName().startsWith("__")) {
            future.setException((Throwable)new IoTDBException(String.format("Failed to start pipe %s, pipe name starting with \"%s\" are not allowed to be started.", startPipeStatement.getPipeName(), "__"), TSStatusCode.PIPE_ERROR.getStatusCode()));
            return future;
        }
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.startPipeExtended(new TStartPipeReq().setPipeName(startPipeStatement.getPipeName()).setIsTableModel(startPipeStatement.isTableModel()));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropPipe(DropPipeStatement dropPipeStatement) {
        SettableFuture future = SettableFuture.create();
        if (dropPipeStatement.getPipeName().startsWith("__")) {
            future.setException((Throwable)new IoTDBException(String.format("Failed to drop pipe %s, pipe name starting with \"%s\" are not allowed to be dropped.", dropPipeStatement.getPipeName(), "__"), TSStatusCode.PIPE_ERROR.getStatusCode()));
            return future;
        }
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.dropPipeExtended(new TDropPipeReq().setPipeName(dropPipeStatement.getPipeName()).setIfExistsCondition(dropPipeStatement.hasIfExistsCondition()).setIsTableModel(dropPipeStatement.isTableModel()));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> stopPipe(StopPipeStatement stopPipeStatement) {
        SettableFuture future = SettableFuture.create();
        if (stopPipeStatement.getPipeName().startsWith("__")) {
            future.setException((Throwable)new IoTDBException(String.format("Failed to stop pipe %s, pipe name starting with \"%s\" are not allowed to be stopped.", stopPipeStatement.getPipeName(), "__"), TSStatusCode.PIPE_ERROR.getStatusCode()));
            return future;
        }
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.stopPipeExtended(new TStopPipeReq().setPipeName(stopPipeStatement.getPipeName()).setIsTableModel(stopPipeStatement.isTableModel()));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showPipes(ShowPipesStatement showPipesStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TShowPipeReq tShowPipeReq = new TShowPipeReq();
            if (showPipesStatement.getPipeName() != null) {
                tShowPipeReq.setPipeName(showPipesStatement.getPipeName());
            }
            if (showPipesStatement.getWhereClause()) {
                tShowPipeReq.setWhereClause(true);
            }
            tShowPipeReq.setIsTableModel(showPipesStatement.isTableModel());
            List tShowPipeInfoList = configNodeClient.showPipe(tShowPipeReq).getPipeInfoList();
            ShowPipeTask.buildTSBlock(tShowPipeInfoList, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showSubscriptions(ShowSubscriptionsStatement showSubscriptionsStatement) {
        if (!SubscriptionConfig.getInstance().getSubscriptionEnabled()) {
            return SUBSCRIPTION_NOT_ENABLED_ERROR_FUTURE;
        }
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TShowSubscriptionReq showSubscriptionReq = new TShowSubscriptionReq();
            if (showSubscriptionsStatement.getTopicName() != null) {
                showSubscriptionReq.setTopicName(showSubscriptionsStatement.getTopicName());
            }
            showSubscriptionReq.setIsTableModel(showSubscriptionsStatement.isTableModel());
            TShowSubscriptionResp showSubscriptionResp = configNodeClient.showSubscription(showSubscriptionReq);
            if (showSubscriptionResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showSubscriptionResp.getStatus().getMessage(), showSubscriptionResp.getStatus().getCode()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowSubscriptionsTask.buildTSBlock(showSubscriptionResp.isSetSubscriptionInfoList() ? showSubscriptionResp.getSubscriptionInfoList() : Collections.emptyList(), (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropSubscription(DropSubscriptionStatement dropSubscriptionStatement) {
        if (!SubscriptionConfig.getInstance().getSubscriptionEnabled()) {
            return SUBSCRIPTION_NOT_ENABLED_ERROR_FUTURE;
        }
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.dropSubscriptionById(new TDropSubscriptionReq().setSubsciptionId(dropSubscriptionStatement.getSubscriptionId()).setIfExistsCondition(dropSubscriptionStatement.hasIfExistsCondition()).setIsTableModel(dropSubscriptionStatement.isTableModel()));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createTopic(CreateTopicStatement createTopicStatement) {
        if (!SubscriptionConfig.getInstance().getSubscriptionEnabled()) {
            return SUBSCRIPTION_NOT_ENABLED_ERROR_FUTURE;
        }
        SettableFuture future = SettableFuture.create();
        String topicName = createTopicStatement.getTopicName();
        Map<String, String> topicAttributes = createTopicStatement.getTopicAttributes();
        long currentTime = CommonDateTimeUtils.convertMilliTimeWithPrecision((long)System.currentTimeMillis(), (String)CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
        topicAttributes.computeIfPresent("start-time", (k, v) -> {
            if ("now".equals(v)) {
                return String.valueOf(currentTime);
            }
            return v;
        });
        topicAttributes.computeIfPresent("end-time", (k, v) -> {
            if ("now".equals(v)) {
                return String.valueOf(currentTime);
            }
            return v;
        });
        TopicMeta temporaryTopicMeta = new TopicMeta(topicName, System.currentTimeMillis(), topicAttributes);
        try {
            PipeDataNodeAgent.plugin().validate("fakePipeName", temporaryTopicMeta.generateExtractorAttributes(CommonDescriptor.getInstance().getConfig().getAdminName()), temporaryTopicMeta.generateProcessorAttributes(), temporaryTopicMeta.generateConnectorAttributes("fakeConsumerGroupId"));
        }
        catch (Exception e) {
            future.setException((Throwable)new IoTDBException(e.getMessage(), TSStatusCode.CREATE_TOPIC_ERROR.getStatusCode()));
            return future;
        }
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCreateTopicReq req = new TCreateTopicReq().setTopicName(topicName).setIfNotExistsCondition(createTopicStatement.hasIfNotExistsCondition()).setTopicAttributes(topicAttributes);
            TSStatus tsStatus = configNodeClient.createTopic(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropTopic(DropTopicStatement dropTopicStatement) {
        if (!SubscriptionConfig.getInstance().getSubscriptionEnabled()) {
            return SUBSCRIPTION_NOT_ENABLED_ERROR_FUTURE;
        }
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.dropTopicExtended(new TDropTopicReq().setIfExistsCondition(dropTopicStatement.hasIfExistsCondition()).setTopicName(dropTopicStatement.getTopicName()).setIsTableModel(dropTopicStatement.isTableModel()));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showTopics(ShowTopicsStatement showTopicsStatement) {
        if (!SubscriptionConfig.getInstance().getSubscriptionEnabled()) {
            return SUBSCRIPTION_NOT_ENABLED_ERROR_FUTURE;
        }
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TShowTopicReq showTopicReq = new TShowTopicReq();
            if (showTopicsStatement.getTopicName() != null) {
                showTopicReq.setTopicName(showTopicsStatement.getTopicName());
            }
            showTopicReq.setIsTableModel(showTopicsStatement.isTableModel());
            TShowTopicResp showTopicResp = configNodeClient.showTopic(showTopicReq);
            if (showTopicResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showTopicResp.getStatus().getMessage(), showTopicResp.getStatus().getCode()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowTopicsTask.buildTSBlock(showTopicResp.isSetTopicInfoList() ? showTopicResp.getTopicInfoList() : Collections.emptyList(), (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> alterEncodingCompressor(String queryId, AlterEncodingCompressorStatement alterEncodingCompressorStatement) {
        SettableFuture future = SettableFuture.create();
        if (alterEncodingCompressorStatement.getPatternTree().isEmpty()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            alterEncodingCompressorStatement.getPatternTree().serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TAlterEncodingCompressorReq req = new TAlterEncodingCompressorReq(queryId, ByteBuffer.wrap(byteArrayOutputStream.toByteArray()), SerializeUtils.serializeNullable((TSEncoding)alterEncodingCompressorStatement.getEncoding()), SerializeUtils.serializeNullable((CompressionType)alterEncodingCompressorStatement.getCompressor()), alterEncodingCompressorStatement.ifExists(), alterEncodingCompressorStatement.isWithAudit());
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.alterEncodingCompressor(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                if (tsStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    future.setException((Throwable)((Object)new BatchProcessException(tsStatus.subStatus.toArray(new TSStatus[0]))));
                } else {
                    future.setException((Throwable)new IoTDBException(tsStatus));
                }
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deleteTimeSeries(String queryId, DeleteTimeSeriesStatement deleteTimeSeriesStatement) {
        SettableFuture future = SettableFuture.create();
        TDeleteTimeSeriesReq req = new TDeleteTimeSeriesReq(queryId, this.serializePatternListToByteBuffer(deleteTimeSeriesStatement.getPathPatternList()));
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.deleteTimeSeries(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                if (tsStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    future.setException((Throwable)((Object)new BatchProcessException(tsStatus.subStatus.toArray(new TSStatus[0]))));
                } else {
                    future.setException((Throwable)new IoTDBException(tsStatus));
                }
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deleteLogicalView(String queryId, DeleteLogicalViewStatement deleteLogicalViewStatement) {
        SettableFuture future = SettableFuture.create();
        TDeleteLogicalViewReq req = new TDeleteLogicalViewReq(queryId, this.serializePatternListToByteBuffer(deleteLogicalViewStatement.getPathPatternList()));
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.deleteLogicalView(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> renameLogicalView(String queryId, RenameLogicalViewStatement renameLogicalViewStatement) {
        SettableFuture future = SettableFuture.create();
        PartialPath oldName = renameLogicalViewStatement.getOldName();
        if (oldName.hasWildcard()) {
            future.setException((Throwable)new MetadataException("Rename view doesn't support path pattern with wildcard."));
            return future;
        }
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendFullPath(oldName);
        patternTree.constructTree();
        ClusterSchemaTree schemaTree = ClusterSchemaFetcher.getInstance().fetchSchema(patternTree, true, null);
        List measurementPathList = (List)schemaTree.searchMeasurementPaths((PartialPath)oldName).left;
        if (measurementPathList.isEmpty()) {
            future.setException((Throwable)((Object)new PathNotExistException(oldName.getFullPath())));
            return future;
        }
        LogicalViewSchema logicalViewSchema = (LogicalViewSchema)((MeasurementPath)measurementPathList.get(0)).getMeasurementSchema();
        ViewExpression viewExpression = logicalViewSchema.getExpression();
        CreateLogicalViewStatement createLogicalViewStatement = new CreateLogicalViewStatement();
        createLogicalViewStatement.setTargetFullPaths(Collections.singletonList(renameLogicalViewStatement.getNewName()));
        createLogicalViewStatement.setViewExpressions(Collections.singletonList(viewExpression));
        ExecutionResult executionResult = Coordinator.getInstance().executeForTreeModel(createLogicalViewStatement, 0L, null, "", ClusterPartitionFetcher.getInstance(), ClusterSchemaFetcher.getInstance(), IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold(), false);
        if (executionResult.status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.setException((Throwable)new IoTDBException(executionResult.status.getMessage(), executionResult.status.getCode()));
            return future;
        }
        TDeleteLogicalViewReq req = new TDeleteLogicalViewReq(queryId, this.serializePatternListToByteBuffer(Collections.singletonList(oldName)));
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.deleteLogicalView(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> alterLogicalView(AlterLogicalViewStatement alterLogicalViewStatement, MPPQueryContext context) {
        SettableFuture future = SettableFuture.create();
        CreateLogicalViewStatement createLogicalViewStatement = new CreateLogicalViewStatement();
        createLogicalViewStatement.setTargetPaths(alterLogicalViewStatement.getTargetPaths());
        createLogicalViewStatement.setSourcePaths(alterLogicalViewStatement.getSourcePaths());
        createLogicalViewStatement.setQueryStatement(alterLogicalViewStatement.getQueryStatement());
        Analysis analysis = Analyzer.analyze(createLogicalViewStatement, context);
        analysis.setDatabaseName(context.getDatabaseName().orElse(null));
        if (analysis.isFailed()) {
            future.setException((Throwable)new IoTDBException(analysis.getFailStatus().getMessage(), analysis.getFailStatus().getCode()));
            return future;
        }
        TransformToViewExpressionVisitor transformToViewExpressionVisitor = new TransformToViewExpressionVisitor();
        List<Expression> expressionList = alterLogicalViewStatement.getSourceExpressionList();
        ArrayList<ViewExpression> viewExpressionList = new ArrayList<ViewExpression>();
        for (Expression expression : expressionList) {
            viewExpressionList.add(transformToViewExpressionVisitor.process(expression, null));
        }
        List<PartialPath> viewPathList = alterLogicalViewStatement.getTargetPathList();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ReadWriteIOUtils.write((int)viewPathList.size(), (OutputStream)stream);
            for (int i = 0; i < viewPathList.size(); ++i) {
                viewPathList.get(i).serialize((OutputStream)stream);
                ViewExpression.serialize((ViewExpression)((ViewExpression)viewExpressionList.get(i)), (OutputStream)stream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        TAlterLogicalViewReq req = new TAlterLogicalViewReq(context.getQueryId().getId(), ByteBuffer.wrap(stream.toByteArray()));
        ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);
        try {
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.alterLogicalView(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                if (tsStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    future.setException((Throwable)((Object)new BatchProcessException(tsStatus.subStatus.toArray(new TSStatus[0]))));
                } else {
                    future.setException((Throwable)new IoTDBException(tsStatus));
                }
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
            SettableFuture settableFuture = future;
            if (client != null) {
                client.close();
            }
            return settableFuture;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
                return future;
            }
        }
    }

    @Override
    public TSStatus alterLogicalViewByPipe(AlterLogicalViewNode alterLogicalViewNode) {
        TSStatus tsStatus;
        Map<PartialPath, ViewExpression> viewPathToSourceMap = alterLogicalViewNode.getViewPathToSourceMap();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ReadWriteIOUtils.write((int)viewPathToSourceMap.size(), (OutputStream)stream);
            for (Map.Entry<PartialPath, ViewExpression> entry : viewPathToSourceMap.entrySet()) {
                entry.getKey().serialize((OutputStream)stream);
                ViewExpression.serialize((ViewExpression)entry.getValue(), (OutputStream)stream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        TAlterLogicalViewReq req = new TAlterLogicalViewReq(Coordinator.getInstance().createQueryId().getId(), ByteBuffer.wrap(stream.toByteArray())).setIsGeneratedByPipe(true);
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            do {
                try {
                    tsStatus = client.alterLogicalView(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute alter view {} by pipe, status is {}.", viewPathToSourceMap, (Object)tsStatus);
            }
        }
        catch (ClientManagerException | TException e) {
            tsStatus = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            tsStatus.setMessage(e.toString());
        }
        return tsStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> getRegionId(GetRegionIdStatement getRegionIdStatement) {
        SettableFuture future = SettableFuture.create();
        TGetRegionIdResp resp = new TGetRegionIdResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetRegionIdReq tGetRegionIdReq = new TGetRegionIdReq(getRegionIdStatement.getPartitionType());
            if (getRegionIdStatement.getDevice() != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                getRegionIdStatement.getDevice().serialize((OutputStream)baos);
                tGetRegionIdReq.setDevice(baos.toByteArray());
            } else {
                tGetRegionIdReq.setDatabase(getRegionIdStatement.getDatabase());
            }
            tGetRegionIdReq.setStartTimeSlot(TimePartitionUtils.getTimePartitionSlot((long)getRegionIdStatement.getStartTimeStamp()));
            tGetRegionIdReq.setEndTimeSlot(TimePartitionUtils.getTimePartitionSlot((long)getRegionIdStatement.getEndTimeStamp()));
            resp = configNodeClient.getRegionId(tGetRegionIdReq);
            if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(resp.getStatus()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        GetRegionIdTask.buildTsBlock(resp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> getSeriesSlotList(GetSeriesSlotListStatement getSeriesSlotListStatement) {
        SettableFuture future = SettableFuture.create();
        TGetSeriesSlotListResp resp = new TGetSeriesSlotListResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetSeriesSlotListReq tGetSeriesSlotListReq = new TGetSeriesSlotListReq(getSeriesSlotListStatement.getDatabase(), getSeriesSlotListStatement.getPartitionType());
            resp = configNodeClient.getSeriesSlotList(tGetSeriesSlotListReq);
            if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(resp.getStatus()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        GetSeriesSlotListTask.buildTsBlock(resp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> getTimeSlotList(GetTimeSlotListStatement getTimeSlotListStatement) {
        SettableFuture future = SettableFuture.create();
        TGetTimeSlotListResp resp = new TGetTimeSlotListResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetTimeSlotListReq tGetTimeSlotListReq = new TGetTimeSlotListReq();
            if (getTimeSlotListStatement.getDatabase() != null) {
                tGetTimeSlotListReq.setDatabase(getTimeSlotListStatement.getDatabase());
            } else if (getTimeSlotListStatement.getDevice() != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                getTimeSlotListStatement.getDevice().serialize((OutputStream)baos);
                tGetTimeSlotListReq.setDevice(baos.toByteArray());
            } else if (getTimeSlotListStatement.getRegionId() != -1L) {
                tGetTimeSlotListReq.setRegionId(getTimeSlotListStatement.getRegionId());
            }
            if (getTimeSlotListStatement.getStartTime() != -1L) {
                tGetTimeSlotListReq.setStartTime(getTimeSlotListStatement.getStartTime());
            }
            if (getTimeSlotListStatement.getEndTime() != -1L) {
                tGetTimeSlotListReq.setEndTime(getTimeSlotListStatement.getEndTime());
            }
            if ((resp = configNodeClient.getTimeSlotList(tGetTimeSlotListReq)).getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(resp.getStatus()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        GetTimeSlotListTask.buildTSBlock(resp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> countTimeSlotList(CountTimeSlotListStatement countTimeSlotListStatement) {
        SettableFuture future = SettableFuture.create();
        TCountTimeSlotListResp resp = new TCountTimeSlotListResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCountTimeSlotListReq tCountTimeSlotListReq = new TCountTimeSlotListReq();
            if (countTimeSlotListStatement.getDatabase() != null) {
                tCountTimeSlotListReq.setDatabase(countTimeSlotListStatement.getDatabase());
            } else if (countTimeSlotListStatement.getDevice() != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                countTimeSlotListStatement.getDevice().serialize((OutputStream)baos);
                tCountTimeSlotListReq.setDevice(baos.toByteArray());
            } else if (countTimeSlotListStatement.getRegionId() != -1L) {
                tCountTimeSlotListReq.setRegionId(countTimeSlotListStatement.getRegionId());
            }
            if (countTimeSlotListStatement.getStartTime() != -1L) {
                tCountTimeSlotListReq.setStartTime(countTimeSlotListStatement.getStartTime());
            }
            if (countTimeSlotListStatement.getEndTime() != -1L) {
                tCountTimeSlotListReq.setEndTime(countTimeSlotListStatement.getEndTime());
            }
            if ((resp = configNodeClient.countTimeSlotList(tCountTimeSlotListReq)).getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(resp.getStatus()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        CountTimeSlotListTask.buildTSBlock(resp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> migrateRegion(MigrateRegionTask migrateRegionTask) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TMigrateRegionReq tMigrateRegionReq = new TMigrateRegionReq(migrateRegionTask.getStatement().getRegionId(), migrateRegionTask.getStatement().getFromId(), migrateRegionTask.getStatement().getToId(), migrateRegionTask.getModel());
            TSStatus status = configNodeClient.migrateRegion(tMigrateRegionReq);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(status));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> removeDataNode(RemoveDataNodeStatement removeDataNodeStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            Set<Integer> nodeIds = removeDataNodeStatement.getNodeIds();
            Set validNodeIds = configNodeClient.getDataNodeConfiguration(-1).getDataNodeConfigurationMap().keySet();
            HashSet<Integer> invalidNodeIds = new HashSet<Integer>(nodeIds);
            invalidNodeIds.removeAll(validNodeIds);
            if (!invalidNodeIds.isEmpty()) {
                LOGGER.info("Cannot remove invalid nodeIds:{}", invalidNodeIds);
                nodeIds.removeAll(invalidNodeIds);
            }
            if (nodeIds.size() != 1) {
                LOGGER.error("The DataNode to be removed is not in the cluster, or the input format is incorrect.");
                future.setException((Throwable)new IOException("The DataNode to be removed is not in the cluster, or the input format is incorrect."));
            }
            LOGGER.info("Starting to remove DataNode with nodeIds: {}", nodeIds);
            Set<Integer> finalNodeIds = nodeIds;
            List removeDataNodeLocations = configNodeClient.getDataNodeConfiguration(-1).getDataNodeConfigurationMap().values().stream().map(TDataNodeConfiguration::getLocation).filter(location -> finalNodeIds.contains(location.getDataNodeId())).collect(Collectors.toList());
            ArrayList<String> simplifiedLocations = new ArrayList<String>();
            for (TDataNodeLocation dataNodeLocation : removeDataNodeLocations) {
                simplifiedLocations.add(dataNodeLocation.getDataNodeId() + "@" + dataNodeLocation.getInternalEndPoint().getIp());
            }
            LOGGER.info("Start to remove datanode, removed DataNodes endpoint: {}", simplifiedLocations);
            TDataNodeRemoveReq removeReq = new TDataNodeRemoveReq(removeDataNodeLocations);
            TDataNodeRemoveResp removeResp = configNodeClient.removeDataNode(removeReq);
            LOGGER.info("Submit Remove DataNodes result {} ", (Object)removeResp);
            if (removeResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(removeResp.getStatus().toString(), removeResp.getStatus().getCode()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            LOGGER.info("Submit remove-datanode request successfully, but the process may fail. more details are shown in the logs of confignode-leader and removed-datanode, and after the process of removing datanode ends successfully, you are supposed to delete directory and data of the removed-datanode manually");
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> removeConfigNode(RemoveConfigNodeStatement removeConfigNodeStatement) {
        SettableFuture future = SettableFuture.create();
        int removeConfigNodeId = removeConfigNodeStatement.getNodeId();
        LOGGER.info("Starting to remove ConfigNode with node-id {}", (Object)removeConfigNodeId);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TConfigNodeLocation configNodeLocation;
            TSStatus status;
            TShowClusterResp showClusterResp = configNodeClient.showCluster();
            List removeConfigNodeLocations = showClusterResp.getConfigNodeList().stream().filter(node -> node.configNodeId == removeConfigNodeId).collect(Collectors.toList());
            if (removeConfigNodeLocations.size() != 1) {
                LOGGER.error("The ConfigNode to be removed is not in the cluster, or the input format is incorrect.");
                future.setException((Throwable)new IOException("The ConfigNode to be removed is not in the cluster, or the input format is incorrect."));
            }
            if ((status = configNodeClient.removeConfigNode(configNodeLocation = (TConfigNodeLocation)removeConfigNodeLocations.get(0))).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IOException("Remove ConfigNode failed: " + status.getMessage()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            LOGGER.info("ConfigNode: {} is removed.", (Object)removeConfigNodeId);
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
            return future;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> removeAINode(RemoveAINodeStatement removeAINodeStatement) {
        SettableFuture future = SettableFuture.create();
        LOGGER.info("Starting to remove AINode");
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TShowClusterResp showClusterResp = configNodeClient.showCluster();
            if (showClusterResp.getAiNodeListSize() < 1) {
                LOGGER.error("Remove AINode failed because there is no AINode in the cluster.");
                future.setException((Throwable)new IOException("Remove AINode failed because there is no AINode in the cluster."));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            TSStatus status = configNodeClient.removeAINode(new TAINodeRemoveReq());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IOException("Remove AINode failed: " + status.getMessage()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            LOGGER.info("AINode in the cluster is removed.");
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
            return future;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> reconstructRegion(ReconstructRegionTask reconstructRegionTask) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TReconstructRegionReq req = new TReconstructRegionReq(reconstructRegionTask.getStatement().getRegionIds(), reconstructRegionTask.getStatement().getDataNodeId(), reconstructRegionTask.getModel());
            TSStatus status = configNodeClient.reconstructRegion(req);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(status));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> extendRegion(ExtendRegionTask extendRegionTask) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TExtendRegionReq req = new TExtendRegionReq(extendRegionTask.getStatement().getRegionId(), extendRegionTask.getStatement().getDataNodeId(), extendRegionTask.getModel());
            TSStatus status = configNodeClient.extendRegion(req);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(status));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> removeRegion(RemoveRegionTask removeRegionTask) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TRemoveRegionReq req = new TRemoveRegionReq(removeRegionTask.getStatement().getRegionId(), removeRegionTask.getStatement().getDataNodeId(), removeRegionTask.getModel());
            TSStatus status = configNodeClient.removeRegion(req);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(status));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createContinuousQuery(CreateContinuousQueryStatement createContinuousQueryStatement, MPPQueryContext context) {
        createContinuousQueryStatement.semanticCheck();
        String queryBody = createContinuousQueryStatement.getQueryBody();
        Analyzer.analyze(createContinuousQueryStatement.getQueryBodyStatement(), context);
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCreateCQReq tCreateCQReq = new TCreateCQReq(createContinuousQueryStatement.getCqId(), createContinuousQueryStatement.getEveryInterval(), createContinuousQueryStatement.getBoundaryTime(), createContinuousQueryStatement.getStartTimeOffset(), createContinuousQueryStatement.getEndTimeOffset(), createContinuousQueryStatement.getTimeoutPolicy().getType(), queryBody, context.getSql(), context.getZoneId().getId(), context.getSession() == null ? null : context.getSession().getUserName());
            TSStatus executionStatus = client.createCQ(tCreateCQReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(executionStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropContinuousQuery(String cqId) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus executionStatus = client.dropCQ(new TDropCQReq(cqId));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(executionStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showContinuousQueries() {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TShowCQResp showCQResp = client.showCQ();
            if (showCQResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showCQResp.getStatus()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowContinuousQueriesTask.buildTsBlock(showCQResp.getCqList(), (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createModel(String modelId, String uri) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCreateModelReq req = new TCreateModelReq(modelId, uri);
            TSStatus status = client.createModel(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != status.getCode()) {
                future.setException((Throwable)new IoTDBException(status));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropModel(String modelId) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus executionStatus = client.dropModel(new TDropModelReq(modelId));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                future.setException((Throwable)new IoTDBException(executionStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showModels(String modelId) {
        SettableFuture future = SettableFuture.create();
        try (AINodeClient ai = AINodeClientManager.getInstance().borrowClient(0);){
            TShowModelsResp resp;
            TShowModelsReq req = new TShowModelsReq();
            if (modelId != null) {
                req.setModelId(modelId);
            }
            if ((resp = ai.showModels(req)).getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(resp.getStatus()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowModelsTask.buildTsBlock(resp, (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showLoadedModels(List<String> deviceIdList) {
        SettableFuture future = SettableFuture.create();
        try (AINodeClient ai = AINodeClientManager.getInstance().borrowClient(0);){
            TShowLoadedModelsReq req = new TShowLoadedModelsReq();
            req.setDeviceIdList((List)(deviceIdList != null ? deviceIdList : new ArrayList()));
            TShowLoadedModelsResp resp = ai.showLoadedModels(req);
            if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(resp.getStatus()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowLoadedModelsTask.buildTsBlock(resp, (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showAIDevices() {
        SettableFuture future = SettableFuture.create();
        try (AINodeClient ai = AINodeClientManager.getInstance().borrowClient(0);){
            TShowAIDevicesResp resp = ai.showAIDevices();
            if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(resp.getStatus()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowAIDevicesTask.buildTsBlock(resp, (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> loadModel(String existingModelId, List<String> deviceIdList) {
        SettableFuture future = SettableFuture.create();
        try (AINodeClient ai = AINodeClientManager.getInstance().borrowClient(0);){
            TLoadModelReq req = new TLoadModelReq(existingModelId, deviceIdList);
            TSStatus result = ai.loadModel(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != result.getCode()) {
                future.setException((Throwable)new IoTDBException(result));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> unloadModel(String existingModelId, List<String> deviceIdList) {
        SettableFuture future = SettableFuture.create();
        try (AINodeClient ai = AINodeClientManager.getInstance().borrowClient(0);){
            TUnloadModelReq req = new TUnloadModelReq(existingModelId, deviceIdList);
            TSStatus result = ai.unloadModel(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != result.getCode()) {
                future.setException((Throwable)new IoTDBException(result));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createTraining(String modelId, boolean isTableModel, Map<String, String> parameters, List<List<Long>> timeRanges, String existingModelId, @Nullable String targetSql, @Nullable List<String> pathList) {
        SettableFuture future = SettableFuture.create();
        try (AINodeClient ai = AINodeClientManager.getInstance().borrowClient(0);){
            TTrainingReq req = new TTrainingReq();
            req.setModelId(modelId);
            req.setParameters(parameters);
            if (existingModelId != null) {
                req.setExistingModelId(existingModelId);
            }
            if (existingModelId != null) {
                req.setExistingModelId(existingModelId);
            }
            TSStatus status = ai.createTrainingTask(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != status.getCode()) {
                future.setException((Throwable)new IoTDBException(status));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setSpaceQuota(SetSpaceQuotaStatement setSpaceQuotaStatement) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        TSetSpaceQuotaReq req = new TSetSpaceQuotaReq();
        req.setDatabase(setSpaceQuotaStatement.getPrefixPathList());
        TSpaceQuota spaceQuota = new TSpaceQuota();
        spaceQuota.setDeviceNum(setSpaceQuotaStatement.getDeviceNum());
        spaceQuota.setTimeserieNum(setSpaceQuotaStatement.getTimeSeriesNum());
        spaceQuota.setDiskSize(setSpaceQuotaStatement.getDiskSize());
        req.setSpaceLimit(spaceQuota);
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            tsStatus = client.setSpaceQuota(req);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showSpaceQuota(ShowSpaceQuotaStatement showSpaceQuotaStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            ArrayList<String> databases = new ArrayList<String>();
            if (showSpaceQuotaStatement.getDatabases() != null) {
                showSpaceQuotaStatement.getDatabases().forEach(database -> databases.add(database.toString()));
            }
            TSpaceQuotaResp showSpaceQuotaResp = configNodeClient.showSpaceQuota(databases);
            ShowSpaceQuotaTask.buildTsBlock(showSpaceQuotaResp, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setThrottleQuota(SetThrottleQuotaStatement setThrottleQuotaStatement) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        TSetThrottleQuotaReq req = new TSetThrottleQuotaReq();
        req.setUserName(setThrottleQuotaStatement.getUserName());
        TThrottleQuota throttleQuota = new TThrottleQuota();
        throttleQuota.setThrottleLimit(setThrottleQuotaStatement.getThrottleLimit());
        throttleQuota.setMemLimit(setThrottleQuotaStatement.getMemLimit());
        throttleQuota.setCpuLimit(setThrottleQuotaStatement.getCpuLimit());
        req.setThrottleQuota(throttleQuota);
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            tsStatus = client.setThrottleQuota(req);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showThrottleQuota(ShowThrottleQuotaStatement showThrottleQuotaStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TShowThrottleReq req = new TShowThrottleReq();
            req.setUserName(showThrottleQuotaStatement.getUserName());
            TThrottleQuotaResp throttleQuotaResp = configNodeClient.showThrottleQuota(req);
            ShowThrottleQuotaTask.buildTSBlock(throttleQuotaResp, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public TThrottleQuotaResp getThrottleQuota() {
        TThrottleQuotaResp throttleQuotaResp = new TThrottleQuotaResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            throttleQuotaResp = configNodeClient.getThrottleQuota();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return throttleQuotaResp;
    }

    @Override
    public TSpaceQuotaResp getSpaceQuota() {
        TSpaceQuotaResp spaceQuotaResp = new TSpaceQuotaResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            spaceQuotaResp = configNodeClient.getSpaceQuota();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return spaceQuotaResp;
    }

    @Override
    public TPipeTransferResp handleTransferConfigPlan(String clientId, TPipeTransferReq req) {
        TPipeConfigTransferReq configTransferReq = new TPipeConfigTransferReq(req.version, req.type, req.body, req instanceof AirGapPseudoTPipeTransferRequest, clientId);
        ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);
        try {
            TPipeConfigTransferResp pipeConfigTransferResp = configNodeClient.handleTransferConfigPlan(configTransferReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != pipeConfigTransferResp.getStatus().getCode()) {
                LOGGER.warn("Failed to handleTransferConfigPlan, status is {}.", (Object)pipeConfigTransferResp);
            }
            TPipeTransferResp tPipeTransferResp = new TPipeTransferResp(pipeConfigTransferResp.status).setBody(pipeConfigTransferResp.body);
            if (configNodeClient != null) {
                configNodeClient.close();
            }
            return tPipeTransferResp;
        }
        catch (Throwable throwable) {
            try {
                if (configNodeClient != null) {
                    try {
                        configNodeClient.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                return new TPipeTransferResp(new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()).setMessage(e.toString()));
            }
        }
    }

    @Override
    public SettableFuture<ConfigTaskResult> showDatabases(ShowDB showDB, Predicate<String> canSeenDB) {
        SettableFuture future = SettableFuture.create();
        List<String> databasePathPattern = Arrays.asList(SchemaConstant.ALL_RESULT_NODES);
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetDatabaseReq req = new TGetDatabaseReq(databasePathPattern, SchemaConstant.ALL_MATCH_SCOPE.serialize()).setIsTableModel(true);
            TShowDatabaseResp resp = client.showDatabase(req);
            ShowDBTask.buildTSBlock(resp.getDatabaseInfoMap(), (SettableFuture<ConfigTaskResult>)future, showDB.isDetails(), canSeenDB);
        }
        catch (IOException | ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showCluster(ShowCluster showCluster) {
        ShowClusterStatement treeStatement = new ShowClusterStatement();
        treeStatement.setDetails(showCluster.getDetails().orElse(false));
        return this.showCluster(treeStatement);
    }

    @Override
    public SettableFuture<ConfigTaskResult> useDatabase(Use useDB, IClientSession clientSession) {
        SettableFuture future = SettableFuture.create();
        String database = useDB.getDatabaseId().getValue();
        if (InformationSchemaUtils.mayUseDB(database, clientSession, (SettableFuture<ConfigTaskResult>)future)) {
            return future;
        }
        List<String> databasePathPattern = Arrays.asList("root", database);
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetDatabaseReq req = new TGetDatabaseReq(databasePathPattern, SchemaConstant.ALL_MATCH_SCOPE.serialize()).setIsTableModel(true);
            TShowDatabaseResp resp = client.showDatabase(req);
            if (resp.getDatabaseInfoMap().containsKey(database)) {
                clientSession.setDatabaseName(database);
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            } else {
                future.setException((Throwable)new IoTDBException(String.format("Unknown database %s", database), TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()));
                ClusterConfigTaskExecutor.unsetDatabaseIfNotExist(useDB.getDatabaseId().getValue(), clientSession);
            }
        }
        catch (IOException | ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropDatabase(DropDB dropDB, IClientSession session) {
        SettableFuture future = SettableFuture.create();
        TDeleteDatabasesReq req = new TDeleteDatabasesReq(Collections.singletonList(dropDB.getDbName().getValue())).setIsTableModel(true);
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = client.deleteDatabases(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode()) {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
                ClusterConfigTaskExecutor.unsetDatabaseIfNotExist(dropDB.getDbName().getValue(), session);
            } else if (TSStatusCode.PATH_NOT_EXIST.getStatusCode() == tsStatus.getCode()) {
                if (dropDB.isExists()) {
                    future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
                } else {
                    LOGGER.info("Failed to DROP DATABASE {}, because it doesn't exist", (Object)dropDB.getDbName().getValue());
                    future.setException((Throwable)new IoTDBException(String.format("Database %s doesn't exist", dropDB.getDbName().getValue()), TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()));
                }
                ClusterConfigTaskExecutor.unsetDatabaseIfNotExist(dropDB.getDbName().getValue(), session);
            } else {
                LOGGER.warn("Failed to execute delete database {} in config node, status is {}.", (Object)dropDB.getDbName().getValue(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    public static void unsetDatabaseIfNotExist(String database, IClientSession session) {
        if (session != null && database.equals(session.getDatabaseName())) {
            session.setDatabaseName(null);
        }
    }

    @Override
    public SettableFuture<ConfigTaskResult> createDatabase(TDatabaseSchema databaseSchema, boolean ifExists) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.setDatabase(databaseSchema);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode()) {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            } else if (TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode() == tsStatus.getCode()) {
                if (ifExists) {
                    future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
                } else {
                    future.setException((Throwable)new IoTDBException(String.format("Database %s already exists", databaseSchema.getName()), TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode()));
                }
            } else {
                future.setException((Throwable)new IoTDBException(tsStatus));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> alterDatabase(TDatabaseSchema databaseSchema, boolean ifNotExists) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.alterDatabase(databaseSchema);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode()) {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            } else if (TSStatusCode.DATABASE_NOT_EXIST.getStatusCode() == tsStatus.getCode()) {
                if (ifNotExists) {
                    future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
                } else {
                    future.setException((Throwable)new IoTDBException(String.format("Database %s doesn't exist", databaseSchema.getName()), TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()));
                }
                ClusterConfigTaskExecutor.unsetDatabaseIfNotExist(databaseSchema.getName(), SessionManager.getInstance().getCurrSession());
            } else {
                future.setException((Throwable)new IoTDBException(tsStatus));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createTable(TsTable table, String database, boolean ifNotExists) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = configNodeClient.createTable(ByteBuffer.wrap(TsTableInternalRPCUtil.serializeSingleTsTableWithDatabase((String)database, (TsTable)table)));
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode() || TSStatusCode.TABLE_ALREADY_EXISTS.getStatusCode() == tsStatus.getCode() && ifNotExists) {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            } else {
                future.setException((Throwable)new IoTDBException(this.getTableErrorMessage(tsStatus, database), tsStatus.getCode()));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> describeTable(String database, String tableName, boolean isDetails, Boolean isShowCreateView) {
        SettableFuture future = SettableFuture.create();
        if (InformationSchemaUtils.mayDescribeTable(database, tableName, isDetails, isShowCreateView, (SettableFuture<ConfigTaskResult>)future)) {
            return future;
        }
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TDescTableResp resp = configNodeClient.describeTable(database, tableName, isDetails);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != resp.getStatus().getCode()) {
                future.setException((Throwable)new IoTDBException(this.getTableErrorMessage(resp.getStatus(), database), resp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            TsTable table = TsTableInternalRPCUtil.deserializeSingleTsTable((byte[])resp.getTableInfo());
            if (Boolean.TRUE.equals(isShowCreateView)) {
                ShowCreateViewTask.buildTsBlock(table, (SettableFuture<ConfigTaskResult>)future);
                return future;
            }
            if (Boolean.FALSE.equals(isShowCreateView)) {
                ShowCreateTableTask.buildTsBlock(table, (SettableFuture<ConfigTaskResult>)future);
                return future;
            }
            if (isDetails) {
                DescribeTableDetailsTask.buildTsBlock(table, resp.getPreDeletedColumns(), (SettableFuture<ConfigTaskResult>)future);
                return future;
            }
            DescribeTableTask.buildTsBlock(table, (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showTables(String database, Predicate<String> checkCanShowTable, boolean isDetails) {
        SettableFuture future = SettableFuture.create();
        if (InformationSchemaUtils.mayShowTable(database, isDetails, (SettableFuture<ConfigTaskResult>)future)) {
            return future;
        }
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TShowTableResp resp = configNodeClient.showTables(database, isDetails);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != resp.getStatus().getCode()) {
                future.setException((Throwable)new IoTDBException(this.getTableErrorMessage(resp.getStatus(), database), resp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            if (isDetails) {
                ShowTablesDetailsTask.buildTsBlock(resp.getTableInfoList(), (SettableFuture<ConfigTaskResult>)future, checkCanShowTable);
                return future;
            }
            ShowTablesTask.buildTsBlock(resp.getTableInfoList(), (SettableFuture<ConfigTaskResult>)future, checkCanShowTable);
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public TFetchTableResp fetchTables(Map<String, Set<String>> fetchTableMap) {
        ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);
        try {
            TFetchTableResp fetchTableResp = configNodeClient.fetchTables(fetchTableMap);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != fetchTableResp.getStatus().getCode()) {
                LOGGER.warn("Failed to fetchTables, status is {}.", (Object)fetchTableResp);
            }
            TFetchTableResp tFetchTableResp = fetchTableResp;
            if (configNodeClient != null) {
                configNodeClient.close();
            }
            return tFetchTableResp;
        }
        catch (Throwable throwable) {
            try {
                if (configNodeClient != null) {
                    try {
                        configNodeClient.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                return new TFetchTableResp(new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()).setMessage(e.toString()));
            }
        }
    }

    @Override
    public SettableFuture<ConfigTaskResult> alterTableRenameTable(String database, String sourceName, String targetName, String queryId, boolean tableIfExists, boolean isView) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                ReadWriteIOUtils.write((String)targetName, (OutputStream)stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            TSStatus tsStatus = this.sendAlterReq2ConfigNode(database, sourceName, queryId, AlterOrDropTableOperationType.RENAME_TABLE, stream.toByteArray(), isView, client);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode() || TSStatusCode.TABLE_NOT_EXISTS.getStatusCode() == tsStatus.getCode() && tableIfExists) {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            } else {
                future.setException((Throwable)new IoTDBException(this.getTableErrorMessage(tsStatus, database), tsStatus.getCode()));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> alterTableAddColumn(String database, String tableName, List<TsTableColumnSchema> columnSchemaList, String queryId, boolean tableIfExists, boolean columnIfExists, boolean isView) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = this.sendAlterReq2ConfigNode(database, tableName, queryId, AlterOrDropTableOperationType.ADD_COLUMN, TsTableColumnSchemaUtil.serialize(columnSchemaList), isView, client);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode() || TSStatusCode.TABLE_NOT_EXISTS.getStatusCode() == tsStatus.getCode() && tableIfExists || TSStatusCode.COLUMN_ALREADY_EXISTS.getStatusCode() == tsStatus.getCode() && columnIfExists) {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            } else {
                future.setException((Throwable)new IoTDBException(this.getTableErrorMessage(tsStatus, database), tsStatus.getCode()));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> alterTableRenameColumn(String database, String tableName, String oldName, String newName, String queryId, boolean tableIfExists, boolean columnIfExists, boolean isView) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                ReadWriteIOUtils.write((String)oldName, (OutputStream)stream);
                ReadWriteIOUtils.write((String)newName, (OutputStream)stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            TSStatus tsStatus = this.sendAlterReq2ConfigNode(database, tableName, queryId, AlterOrDropTableOperationType.RENAME_COLUMN, stream.toByteArray(), isView, client);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode() || TSStatusCode.TABLE_NOT_EXISTS.getStatusCode() == tsStatus.getCode() && tableIfExists || TSStatusCode.COLUMN_NOT_EXISTS.getStatusCode() == tsStatus.getCode() && columnIfExists) {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            } else {
                future.setException((Throwable)new IoTDBException(this.getTableErrorMessage(tsStatus, database), tsStatus.getCode()));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> alterTableDropColumn(String database, String tableName, String columnName, String queryId, boolean tableIfExists, boolean columnIfExists, boolean isView) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                ReadWriteIOUtils.write((String)columnName, (OutputStream)stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            TSStatus tsStatus = this.sendAlterReq2ConfigNode(database, tableName, queryId, AlterOrDropTableOperationType.DROP_COLUMN, stream.toByteArray(), isView, client);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode() || TSStatusCode.TABLE_NOT_EXISTS.getStatusCode() == tsStatus.getCode() && tableIfExists || TSStatusCode.COLUMN_NOT_EXISTS.getStatusCode() == tsStatus.getCode() && columnIfExists) {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            } else {
                future.setException((Throwable)new IoTDBException(this.getTableErrorMessage(tsStatus, database), tsStatus.getCode()));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> alterTableSetProperties(String database, String tableName, Map<String, String> properties, String queryId, boolean ifExists, boolean isView) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                ReadWriteIOUtils.write(properties, (OutputStream)stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            TSStatus tsStatus = this.sendAlterReq2ConfigNode(database, tableName, queryId, AlterOrDropTableOperationType.SET_PROPERTIES, stream.toByteArray(), isView, client);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode() || TSStatusCode.TABLE_NOT_EXISTS.getStatusCode() == tsStatus.getCode() && ifExists) {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            } else {
                future.setException((Throwable)new IoTDBException(this.getTableErrorMessage(tsStatus, database), tsStatus.getCode()));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> alterTableCommentTable(String database, String tableName, String queryId, boolean ifExists, String comment, boolean isView) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                ReadWriteIOUtils.write((String)comment, (OutputStream)stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            TSStatus tsStatus = this.sendAlterReq2ConfigNode(database, tableName, queryId, AlterOrDropTableOperationType.COMMENT_TABLE, stream.toByteArray(), isView, client);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode() || TSStatusCode.TABLE_NOT_EXISTS.getStatusCode() == tsStatus.getCode() && ifExists) {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            } else {
                future.setException((Throwable)new IoTDBException(this.getTableErrorMessage(tsStatus, database), tsStatus.getCode()));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> alterTableCommentColumn(String database, String tableName, String columnName, String queryId, boolean tableIfExists, boolean columnIfExists, String comment, boolean isView) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                ReadWriteIOUtils.write((String)columnName, (OutputStream)stream);
                ReadWriteIOUtils.write((String)comment, (OutputStream)stream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            TSStatus tsStatus = this.sendAlterReq2ConfigNode(database, tableName, queryId, AlterOrDropTableOperationType.COMMENT_COLUMN, stream.toByteArray(), isView, client);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode() || TSStatusCode.TABLE_NOT_EXISTS.getStatusCode() == tsStatus.getCode() && tableIfExists || TSStatusCode.COLUMN_NOT_EXISTS.getStatusCode() == tsStatus.getCode() && columnIfExists) {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            } else {
                future.setException((Throwable)new IoTDBException(this.getTableErrorMessage(tsStatus, database), tsStatus.getCode()));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropTable(String database, String tableName, String queryId, boolean ifExists, boolean isView) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = this.sendAlterReq2ConfigNode(database, tableName, queryId, AlterOrDropTableOperationType.DROP_TABLE, new byte[0], isView, client);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode() || TSStatusCode.TABLE_NOT_EXISTS.getStatusCode() == tsStatus.getCode() && ifExists) {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            } else {
                future.setException((Throwable)new IoTDBException(this.getTableErrorMessage(tsStatus, database), tsStatus.getCode()));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deleteDevice(DeleteDevice deleteDevice, String queryId, SessionInfo sessionInfo) {
        SettableFuture future = SettableFuture.create();
        if (!deleteDevice.isMayDeleteDevice()) {
            DeleteDeviceTask.buildTSBlock(0L, (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TDeleteTableDeviceResp resp;
            ByteArrayOutputStream patternStream = new ByteArrayOutputStream();
            try (DataOutputStream outputStream2 = new DataOutputStream(patternStream);){
                deleteDevice.serializePatternInfo(outputStream2);
            }
            catch (IOException outputStream2) {
                // empty catch block
            }
            ByteArrayOutputStream filterStream = new ByteArrayOutputStream();
            try (DataOutputStream outputStream3 = new DataOutputStream(filterStream);){
                deleteDevice.serializeFilterInfo(outputStream3, sessionInfo);
            }
            catch (IOException outputStream3) {
                // empty catch block
            }
            ByteArrayOutputStream modStream = new ByteArrayOutputStream();
            try (DataOutputStream outputStream4 = new DataOutputStream(modStream);){
                deleteDevice.serializeModEntries(outputStream4);
            }
            catch (IOException outputStream4) {
                // empty catch block
            }
            TDeleteTableDeviceReq req = new TDeleteTableDeviceReq(deleteDevice.getDatabase(), deleteDevice.getTableName(), queryId, ByteBuffer.wrap(patternStream.toByteArray()), ByteBuffer.wrap(filterStream.toByteArray()), ByteBuffer.wrap(modStream.toByteArray()));
            do {
                try {
                    resp = client.deleteDevice(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        resp = new TDeleteTableDeviceResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK));
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == resp.getStatus().getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == resp.getStatus().getCode()) {
                DeleteDeviceTask.buildTSBlock(resp.getDeletedNum(), (SettableFuture<ConfigTaskResult>)future);
            } else {
                future.setException((Throwable)new IoTDBException(this.getTableErrorMessage(resp.getStatus(), deleteDevice.getDatabase()), resp.getStatus().getCode()));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createTableView(TsTable table, String database, boolean replace) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = configNodeClient.createTableView(new TCreateTableViewReq(ByteBuffer.wrap(TsTableInternalRPCUtil.serializeSingleTsTableWithDatabase((String)database, (TsTable)table)), replace));
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode()) {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            } else {
                future.setException((Throwable)new IoTDBException(this.getTableErrorMessage(tsStatus, database), tsStatus.getCode()));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    private TSStatus sendAlterReq2ConfigNode(String database, String tableName, String queryId, AlterOrDropTableOperationType type, byte[] updateInfo, boolean isView, ConfigNodeClient client) throws TException {
        TSStatus tsStatus;
        TAlterOrDropTableReq req = new TAlterOrDropTableReq();
        req.setDatabase(database);
        req.setTableName(tableName);
        req.setQueryId(queryId);
        req.setOperationType(type.getTypeValue());
        req.setUpdateInfo(updateInfo);
        req.setIsView(isView);
        do {
            try {
                tsStatus = client.alterOrDropTable(req);
            }
            catch (TTransportException e) {
                if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                    tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                    continue;
                }
                throw e;
            }
        } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
        return tsStatus;
    }

    private String getTableErrorMessage(TSStatus status, String database) {
        if (status.code == TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()) {
            ClusterConfigTaskExecutor.unsetDatabaseIfNotExist(database, SessionManager.getInstance().getCurrSession());
            return String.format("Unknown database %s", PathUtils.unQualifyDatabaseName((String)database));
        }
        return status.getMessage();
    }

    @Override
    public void handlePipeConfigClientExit(String clientId) {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus status = configNodeClient.handlePipeConfigClientExit(clientId);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != status.getCode()) {
                LOGGER.warn("Failed to handlePipeConfigClientExit, status is {}.", (Object)status);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to handlePipeConfigClientExit.", (Throwable)e);
        }
    }

    static {
        SUBSCRIPTION_NOT_ENABLED_ERROR_FUTURE.setException((Throwable)new IoTDBException("Subscription not enabled, please set config `subscription_enabled` to true.", TSStatusCode.SUBSCRIPTION_NOT_ENABLED_ERROR.getStatusCode()));
    }

    private static final class ClusterConfigTaskExecutorHolder {
        private static final ClusterConfigTaskExecutor INSTANCE = new ClusterConfigTaskExecutor();

        private ClusterConfigTaskExecutorHolder() {
        }
    }
}

