/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TransformNode
extends SingleChildProcessNode {
    protected Expression[] outputExpressions;
    protected final boolean keepNull;
    protected final Ordering scanOrder;
    private List<String> outputColumnNames;

    public TransformNode(PlanNodeId id, PlanNode child, Expression[] outputExpressions, boolean keepNull, Ordering scanOrder) {
        super(id, child);
        this.outputExpressions = outputExpressions;
        this.keepNull = keepNull;
        this.scanOrder = scanOrder;
    }

    public TransformNode(PlanNodeId id, Expression[] outputExpressions, boolean keepNull, Ordering scanOrder) {
        super(id);
        this.outputExpressions = outputExpressions;
        this.keepNull = keepNull;
        this.scanOrder = scanOrder;
    }

    @Override
    public final List<String> getOutputColumnNames() {
        if (this.outputColumnNames == null) {
            this.outputColumnNames = new ArrayList<String>();
            for (Expression expression : this.outputExpressions) {
                this.outputColumnNames.add(expression.getExpressionString());
            }
        }
        return this.outputColumnNames;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTransform(this, context);
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.TRANSFORM;
    }

    @Override
    public PlanNode clone() {
        return new TransformNode(this.getPlanNodeId(), this.outputExpressions, this.keepNull, this.scanOrder);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TRANSFORM.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.outputExpressions.length, (ByteBuffer)byteBuffer);
        for (Expression expression : this.outputExpressions) {
            Expression.serialize(expression, byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.keepNull, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TRANSFORM.serialize(stream);
        ReadWriteIOUtils.write((int)this.outputExpressions.length, (OutputStream)stream);
        for (Expression expression : this.outputExpressions) {
            Expression.serialize(expression, stream);
        }
        ReadWriteIOUtils.write((Boolean)this.keepNull, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
    }

    public static TransformNode deserialize(ByteBuffer byteBuffer) {
        int outputExpressionsLength = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        Expression[] outputExpressions = new Expression[outputExpressionsLength];
        for (int i = 0; i < outputExpressionsLength; ++i) {
            outputExpressions[i] = Expression.deserialize(byteBuffer);
        }
        boolean keepNull = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        Ordering scanOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new TransformNode(planNodeId, outputExpressions, keepNull, scanOrder);
    }

    public final Expression[] getOutputExpressions() {
        return this.outputExpressions;
    }

    public final boolean isKeepNull() {
        return this.keepNull;
    }

    public Ordering getScanOrder() {
        return this.scanOrder;
    }

    public String toString() {
        return "TransformNode-" + this.getPlanNodeId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransformNode)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransformNode that = (TransformNode)o;
        return this.keepNull == that.keepNull && Arrays.equals(this.outputExpressions, that.outputExpressions) && this.scanOrder == that.scanOrder;
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(new Object[]{super.hashCode(), this.keepNull, this.scanOrder});
        result = 31 * result + Arrays.hashCode(this.outputExpressions);
        return result;
    }
}

