/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class CreateMonitoredItemsRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=749");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=751");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=750");
    private final RequestHeader requestHeader;
    private final UInteger subscriptionId;
    private final TimestampsToReturn timestampsToReturn;
    private final MonitoredItemCreateRequest[] itemsToCreate;

    public CreateMonitoredItemsRequest(RequestHeader requestHeader, UInteger subscriptionId, TimestampsToReturn timestampsToReturn, MonitoredItemCreateRequest[] itemsToCreate) {
        this.requestHeader = requestHeader;
        this.subscriptionId = subscriptionId;
        this.timestampsToReturn = timestampsToReturn;
        this.itemsToCreate = itemsToCreate;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    public MonitoredItemCreateRequest[] getItemsToCreate() {
        return this.itemsToCreate;
    }

    protected CreateMonitoredItemsRequest(CreateMonitoredItemsRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((CreateMonitoredItemsRequestBuilder)b).requestHeader;
        this.subscriptionId = ((CreateMonitoredItemsRequestBuilder)b).subscriptionId;
        this.timestampsToReturn = ((CreateMonitoredItemsRequestBuilder)b).timestampsToReturn;
        this.itemsToCreate = ((CreateMonitoredItemsRequestBuilder)b).itemsToCreate;
    }

    public static CreateMonitoredItemsRequestBuilder<?, ?> builder() {
        return new CreateMonitoredItemsRequestBuilderImpl();
    }

    public CreateMonitoredItemsRequestBuilder<?, ?> toBuilder() {
        return new CreateMonitoredItemsRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateMonitoredItemsRequest)) {
            return false;
        }
        CreateMonitoredItemsRequest other = (CreateMonitoredItemsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        UInteger this$subscriptionId = this.getSubscriptionId();
        UInteger other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !((Object)this$subscriptionId).equals(other$subscriptionId)) {
            return false;
        }
        TimestampsToReturn this$timestampsToReturn = this.getTimestampsToReturn();
        TimestampsToReturn other$timestampsToReturn = other.getTimestampsToReturn();
        if (this$timestampsToReturn == null ? other$timestampsToReturn != null : !this$timestampsToReturn.equals(other$timestampsToReturn)) {
            return false;
        }
        return Arrays.deepEquals(this.getItemsToCreate(), other.getItemsToCreate());
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateMonitoredItemsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        UInteger $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : ((Object)$subscriptionId).hashCode());
        TimestampsToReturn $timestampsToReturn = this.getTimestampsToReturn();
        result = result * 59 + ($timestampsToReturn == null ? 43 : $timestampsToReturn.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getItemsToCreate());
        return result;
    }

    @Override
    public String toString() {
        return "CreateMonitoredItemsRequest(requestHeader=" + this.getRequestHeader() + ", subscriptionId=" + this.getSubscriptionId() + ", timestampsToReturn=" + this.getTimestampsToReturn() + ", itemsToCreate=" + Arrays.deepToString(this.getItemsToCreate()) + ")";
    }

    private static final class CreateMonitoredItemsRequestBuilderImpl
    extends CreateMonitoredItemsRequestBuilder<CreateMonitoredItemsRequest, CreateMonitoredItemsRequestBuilderImpl> {
        private CreateMonitoredItemsRequestBuilderImpl() {
        }

        @Override
        protected CreateMonitoredItemsRequestBuilderImpl self() {
            return this;
        }

        @Override
        public CreateMonitoredItemsRequest build() {
            return new CreateMonitoredItemsRequest(this);
        }
    }

    public static abstract class CreateMonitoredItemsRequestBuilder<C extends CreateMonitoredItemsRequest, B extends CreateMonitoredItemsRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private UInteger subscriptionId;
        private TimestampsToReturn timestampsToReturn;
        private MonitoredItemCreateRequest[] itemsToCreate;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CreateMonitoredItemsRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CreateMonitoredItemsRequest instance, CreateMonitoredItemsRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.subscriptionId(instance.subscriptionId);
            b.timestampsToReturn(instance.timestampsToReturn);
            b.itemsToCreate(instance.itemsToCreate);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B subscriptionId(UInteger subscriptionId) {
            this.subscriptionId = subscriptionId;
            return (B)this.self();
        }

        public B timestampsToReturn(TimestampsToReturn timestampsToReturn) {
            this.timestampsToReturn = timestampsToReturn;
            return (B)this.self();
        }

        public B itemsToCreate(MonitoredItemCreateRequest[] itemsToCreate) {
            this.itemsToCreate = itemsToCreate;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CreateMonitoredItemsRequest.CreateMonitoredItemsRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", subscriptionId=" + this.subscriptionId + ", timestampsToReturn=" + this.timestampsToReturn + ", itemsToCreate=" + Arrays.deepToString(this.itemsToCreate) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<CreateMonitoredItemsRequest> {
        @Override
        public Class<CreateMonitoredItemsRequest> getType() {
            return CreateMonitoredItemsRequest.class;
        }

        @Override
        public CreateMonitoredItemsRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            UInteger subscriptionId = decoder.readUInt32("SubscriptionId");
            TimestampsToReturn timestampsToReturn = decoder.readEnum("TimestampsToReturn", TimestampsToReturn.class);
            MonitoredItemCreateRequest[] itemsToCreate = (MonitoredItemCreateRequest[])decoder.readStructArray("ItemsToCreate", MonitoredItemCreateRequest.TYPE_ID);
            return new CreateMonitoredItemsRequest(requestHeader, subscriptionId, timestampsToReturn, itemsToCreate);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, CreateMonitoredItemsRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeUInt32("SubscriptionId", value.getSubscriptionId());
            encoder.writeEnum("TimestampsToReturn", value.getTimestampsToReturn());
            encoder.writeStructArray("ItemsToCreate", (Object[])value.getItemsToCreate(), MonitoredItemCreateRequest.TYPE_ID);
        }
    }
}

