/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.util.AttributeKey;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.james.protocols.api.CommandDetectionSession;
import org.apache.james.protocols.netty.CommandInjectionDetectedException;

public class AllButStartTlsLineBasedChannelHandler
extends LineBasedFrameDecoder {
    private static final Boolean FAIL_FAST = true;
    private static final CharMatcher CRLF_MATCHER = CharMatcher.anyOf((CharSequence)"\r\n");
    private static final Splitter CRLF_SPLITTER = Splitter.on((CharMatcher)CRLF_MATCHER).omitEmptyStrings();
    private static final AttributeKey<Object> ATTRIBUTE_KEY = AttributeKey.valueOf((String)"startTlsInFlight");
    private final ChannelPipeline pipeline;
    private final String pattern;
    private static final AttributeKey<CommandDetectionSession> sessionAttributeKey = AttributeKey.valueOf((String)"session");

    public AllButStartTlsLineBasedChannelHandler(ChannelPipeline pipeline, int maxFrameLength, boolean stripDelimiter, String pattern) {
        super(maxFrameLength, stripDelimiter, FAIL_FAST == false);
        this.pipeline = pipeline;
        this.pattern = pattern;
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        CommandDetectionSession session = this.retrieveSession(ctx);
        if (session == null || session.needsCommandInjectionDetection()) {
            String trimedLowerCasedInput = this.readAll(buffer).trim().toLowerCase(Locale.US);
            Boolean startTlsInFlight = Optional.ofNullable(ctx.channel().attr(ATTRIBUTE_KEY)).map(attr -> attr.get()).filter(Boolean.class::isInstance).map(Boolean.class::cast).orElse(false);
            if (this.hasCommandInjection(trimedLowerCasedInput) || startTlsInFlight.booleanValue()) {
                throw new CommandInjectionDetectedException();
            }
            if (this.hasStartTLS(trimedLowerCasedInput)) {
                ctx.channel().attr(ATTRIBUTE_KEY).set((Object)true);
            }
        }
        return super.decode(ctx, buffer);
    }

    protected CommandDetectionSession retrieveSession(ChannelHandlerContext ctx) {
        return (CommandDetectionSession)this.pipeline.context("coreHandler").channel().attr(sessionAttributeKey).get();
    }

    protected boolean hasStartTLS(String trimedLowerCasedInput) {
        return CRLF_SPLITTER.splitToStream((CharSequence)trimedLowerCasedInput).anyMatch(s -> s.equalsIgnoreCase(this.pattern));
    }

    private String readAll(ByteBuf buffer) {
        return buffer.toString(StandardCharsets.US_ASCII);
    }

    private boolean hasCommandInjection(String trimedLowerCasedInput) {
        List parts = CRLF_SPLITTER.splitToList((CharSequence)trimedLowerCasedInput);
        return this.hasInvalidStartTlsPart(parts) || this.multiPartsAndOneStartTls(parts);
    }

    protected boolean multiPartsAndOneStartTls(List<String> parts) {
        return parts.stream().anyMatch(line -> line.startsWith(this.pattern)) && parts.size() > 1;
    }

    protected boolean hasInvalidStartTlsPart(List<String> parts) {
        return parts.stream().anyMatch(line -> line.startsWith(this.pattern) && !line.endsWith(this.pattern));
    }
}

