/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.jms;

import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.jms.JMSCacheableMailQueue;
import org.apache.mailet.Mail;

public class JMSMailQueueItem
implements MailQueue.MailQueueItem {
    protected final Mail mail;
    protected final Session session;
    protected final MessageConsumer consumer;

    public JMSMailQueueItem(Mail mail, Session session, MessageConsumer consumer) {
        this.mail = mail;
        this.session = session;
        this.consumer = consumer;
    }

    public void done(MailQueue.MailQueueItem.CompletionStatus success) throws MailQueue.MailQueueException {
        try {
            if (success == MailQueue.MailQueueItem.CompletionStatus.SUCCESS) {
                this.session.commit();
            } else {
                JMSCacheableMailQueue.rollback(this.session);
            }
        }
        catch (JMSException ex) {
            throw new MailQueue.MailQueueException("Unable to commit dequeue operation for mail " + this.mail.getName(), (Exception)((Object)ex));
        }
        finally {
            JMSCacheableMailQueue.closeConsumer(this.consumer);
            JMSCacheableMailQueue.closeSession(this.session);
        }
    }

    public Mail getMail() {
        return this.mail;
    }
}

