/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.store.legacy;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem2.spliterator.ArraySpliterator;
import org.apache.jena.mem2.store.legacy.TripleBunch;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;

public class ArrayBunch
implements TripleBunch {
    private static final int INITIAL_SIZE = 5;
    protected int size = 0;
    protected Triple[] elements;

    public ArrayBunch() {
        this.elements = new Triple[5];
    }

    private ArrayBunch(ArrayBunch bunchToCopy) {
        this.elements = new Triple[bunchToCopy.size];
        System.arraycopy(bunchToCopy.elements, 0, this.elements, 0, bunchToCopy.size);
        this.size = bunchToCopy.size;
    }

    @Override
    public boolean containsKey(Triple t) {
        int i = this.size;
        while (i > 0) {
            if (!t.equals(this.elements[--i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean anyMatch(Predicate<Triple> predicate) {
        int i = this.size;
        while (i > 0) {
            if (!predicate.test(this.elements[--i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.elements = new Triple[5];
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean tryAdd(Triple t) {
        if (this.containsKey(t)) {
            return false;
        }
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = t;
        return true;
    }

    @Override
    public void addUnchecked(Triple t) {
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = t;
    }

    protected void grow() {
        Triple[] oldElements = this.elements;
        this.elements = new Triple[this.size + 4];
        System.arraycopy(oldElements, 0, this.elements, 0, this.size);
    }

    @Override
    public boolean tryRemove(Triple t) {
        for (int i = 0; i < this.size; ++i) {
            if (!t.equals(this.elements[i])) continue;
            this.elements[i] = this.elements[--this.size];
            return true;
        }
        return false;
    }

    @Override
    public void removeUnchecked(Triple t) {
        for (int i = 0; i < this.size; ++i) {
            if (!t.equals(this.elements[i])) continue;
            this.elements[i] = this.elements[--this.size];
            return;
        }
    }

    @Override
    public ExtendedIterator<Triple> keyIterator() {
        return new NiceIterator<Triple>(){
            private final int initialSize;
            private int i;
            {
                this.initialSize = ArrayBunch.this.size;
                this.i = ArrayBunch.this.size;
            }

            @Override
            public boolean hasNext() {
                return 0 < this.i;
            }

            @Override
            public Triple next() {
                if (ArrayBunch.this.size != this.initialSize) {
                    throw new ConcurrentModificationException();
                }
                if (this.i == 0) {
                    throw new NoSuchElementException();
                }
                return ArrayBunch.this.elements[--this.i];
            }

            public void forEachRemaining(Consumer<? super Triple> action) {
                while (0 < this.i--) {
                    action.accept(ArrayBunch.this.elements[this.i]);
                }
                if (ArrayBunch.this.size != this.initialSize) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    @Override
    public Spliterator<Triple> keySpliterator() {
        int initialSize = this.size;
        Runnable checkForConcurrentModification = () -> {
            if (this.size != initialSize) {
                throw new ConcurrentModificationException();
            }
        };
        return new ArraySpliterator<Triple>(this.elements, this.size, checkForConcurrentModification);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    public ArrayBunch copy() {
        return new ArrayBunch(this);
    }
}

