/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.jena.rfc3986.IRI3986;
import org.apache.jena.rfc3986.IRIParseException;

public class ParseOID {
    private static final String NUM = "(0|[1-9][0-9]*)";
    private static final String OID_URN = "^(?:urn:oid|oid):(0|[1-9][0-9]*)(\\.(0|[1-9][0-9]*))*$";
    private static final Pattern OID_URN_RE = Pattern.compile("^(?:urn:oid|oid):(0|[1-9][0-9]*)(\\.(0|[1-9][0-9]*))*$", 2);
    private static final int pathOffset = "urn:".length();

    public static void check(String string) {
        ParseOID.parse(string);
    }

    public static IRI3986 parse(String string) {
        Objects.requireNonNull(string);
        if (!OID_URN_RE.matcher(string).matches()) {
            throw new OIDParseException(string, "Not a match");
        }
        IRI3986 iri = IRI3986.build("urn", null, string.substring(pathOffset), null, null);
        return iri;
    }

    static class OIDParseException
    extends IRIParseException {
        OIDParseException(String entity, String msg) {
            super((CharSequence)entity, msg);
        }
    }
}

