/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.impl.dv.xs;

import org.apache.jena.ext.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.jena.ext.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.jena.ext.xerces.impl.dv.xs.SchemaDateTimeException;

public class DayDV
extends AbstractDateTimeDV {
    private static final int DAY_SIZE = 5;

    @Override
    public Object getActualValue(String content) throws InvalidDatatypeValueException {
        try {
            return this.parse(content);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "gDay"});
        }
    }

    protected AbstractDateTimeDV.DateTimeData parse(String str2) throws SchemaDateTimeException {
        AbstractDateTimeDV.DateTimeData date2 = new AbstractDateTimeDV.DateTimeData(str2, this);
        int len = str2.length();
        if (str2.charAt(0) != '-' || str2.charAt(1) != '-' || str2.charAt(2) != '-') {
            throw new SchemaDateTimeException("Error in day parsing");
        }
        date2.year = 2000;
        date2.month = 1;
        date2.day = this.parseInt(str2, 3, 5);
        if (5 < len) {
            if (!this.isNextCharUTCSign(str2, 5, len)) {
                throw new SchemaDateTimeException("Error in day parsing");
            }
            this.getTimeZone(str2, date2, 5, len);
        }
        this.validateDateTime(date2);
        this.saveUnnormalized(date2);
        if (date2.utc != 0 && date2.utc != 90) {
            this.normalize(date2);
        }
        date2.position = 2;
        return date2;
    }

    @Override
    protected String dateToString(AbstractDateTimeDV.DateTimeData date2) {
        StringBuilder message = new StringBuilder(6);
        message.append('-');
        message.append('-');
        message.append('-');
        this.append(message, date2.day, 2);
        this.append(message, (char)date2.utc, 0);
        return message.toString();
    }
}

