/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process.normalize;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.langtagx.LangTagX;
import org.apache.jena.riot.process.normalize.DatatypeHandler;
import org.apache.jena.riot.process.normalize.NormalizeTerm;
import org.apache.jena.riot.process.normalize.NormalizeValue;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.vocabulary.RDF;

public class NormalizeRDFTerms
implements NormalizeTerm {
    private static final NormalizeRDFTerms mapGeneral = NormalizeRDFTerms.mappingGeneral();
    private static final NormalizeRDFTerms mapTTL = NormalizeRDFTerms.mappingTTL();
    private static final NormalizeRDFTerms mapXSD11 = NormalizeRDFTerms.mappingXSD11();
    private static final NormalizeRDFTerms mapXSD10 = NormalizeRDFTerms.mappingXSD10();
    private final Map<RDFDatatype, DatatypeHandler> dispatchMapping;
    private static final RDFDatatype dtPlainLiteral = NodeFactory.getType(RDF.PlainLiteral.getURI());

    public static NormalizeRDFTerms get() {
        return mapGeneral;
    }

    public static NormalizeRDFTerms getTTL() {
        return mapGeneral;
    }

    public static NormalizeRDFTerms getXSD() {
        return mapXSD11;
    }

    public static NormalizeRDFTerms getXSD11() {
        return mapXSD11;
    }

    public static NormalizeRDFTerms getXSD10() {
        return mapXSD10;
    }

    private static NormalizeRDFTerms mappingGeneral() {
        Map<RDFDatatype, DatatypeHandler> mapping = NormalizeRDFTerms.baseMap();
        return new NormalizeRDFTerms(mapping);
    }

    private static NormalizeRDFTerms mappingTTL() {
        Map<RDFDatatype, DatatypeHandler> mapping = NormalizeRDFTerms.baseMap();
        mapping.put(XSDDatatype.XSDdecimal, NormalizeValue.dtDecimalTTL);
        mapping.put(XSDDatatype.XSDdouble, NormalizeValue.dtDoubleTTL);
        mapping.put(XSDDatatype.XSDfloat, NormalizeValue.dtFloatTTL);
        return new NormalizeRDFTerms(mapping);
    }

    private static NormalizeRDFTerms mappingXSD11() {
        Map<RDFDatatype, DatatypeHandler> mapping = NormalizeRDFTerms.baseMap();
        mapping.put(XSDDatatype.XSDdecimal, NormalizeValue.dtDecimalXSD);
        mapping.put(XSDDatatype.XSDdouble, NormalizeValue.dtDoubleXSD);
        mapping.put(XSDDatatype.XSDfloat, NormalizeValue.dtFloatXSD);
        return new NormalizeRDFTerms(mapping);
    }

    private static NormalizeRDFTerms mappingXSD10() {
        Map<RDFDatatype, DatatypeHandler> mapping = NormalizeRDFTerms.baseMap();
        mapping.put(XSDDatatype.XSDdecimal, NormalizeValue.dtDecimalXSD10);
        mapping.put(XSDDatatype.XSDdouble, NormalizeValue.dtDoubleXSD);
        mapping.put(XSDDatatype.XSDfloat, NormalizeValue.dtFloatXSD);
        return new NormalizeRDFTerms(mapping);
    }

    private NormalizeRDFTerms(Map<RDFDatatype, DatatypeHandler> mapping) {
        this.dispatchMapping = Map.copyOf(mapping);
    }

    public static Node normalizeValue(Node node) {
        return NormalizeRDFTerms.get().normalize(node);
    }

    @Override
    public Node normalize(Node node) {
        return NormalizeRDFTerms.normalizeTerm(this.dispatchMapping, node);
    }

    static Node normalizeTerm(Map<RDFDatatype, DatatypeHandler> dispatchMap, Node node) {
        if (!node.isLiteral()) {
            return node;
        }
        if (NodeUtils.isLangString(node)) {
            return NormalizeRDFTerms.canonicalLangtag(node);
        }
        if (NodeUtils.isSimpleString(node)) {
            return node;
        }
        if (!node.getLiteralDatatype().isValid(node.getLiteralLexicalForm())) {
            return node;
        }
        RDFDatatype dt = node.getLiteralDatatype();
        DatatypeHandler handler = dispatchMap.get(dt);
        if (handler == null) {
            return node;
        }
        Node n2 = handler.handle(node, node.getLiteralLexicalForm(), dt);
        if (n2 == null) {
            return node;
        }
        return n2;
    }

    private static Node canonicalLangtag(Node node) {
        String langTag = node.getLiteralLanguage();
        String langTag2 = LangTagX.formatLanguageTag(langTag);
        if (langTag2.equals(langTag)) {
            return node;
        }
        String lexicalForm = node.getLiteralLexicalForm();
        return NodeFactory.createLiteralLang(lexicalForm, langTag2);
    }

    private static Map<RDFDatatype, DatatypeHandler> baseMap() {
        HashMap<RDFDatatype, DatatypeHandler> map = new HashMap<RDFDatatype, DatatypeHandler>();
        NormalizeRDFTerms.addBaseAll(map);
        return map;
    }

    private static Map<RDFDatatype, DatatypeHandler> turtleMap() {
        HashMap<RDFDatatype, DatatypeHandler> map = new HashMap<RDFDatatype, DatatypeHandler>();
        NormalizeRDFTerms.addBaseAll(map);
        map.put(XSDDatatype.XSDdecimal, NormalizeValue.dtDecimalTTL);
        map.put(XSDDatatype.XSDfloat, NormalizeValue.dtFloatTTL);
        map.put(XSDDatatype.XSDdouble, NormalizeValue.dtDoubleTTL);
        return map;
    }

    private static Map<RDFDatatype, DatatypeHandler> xsdMap() {
        HashMap<RDFDatatype, DatatypeHandler> map = new HashMap<RDFDatatype, DatatypeHandler>();
        NormalizeRDFTerms.addBaseAll(map);
        map.put(XSDDatatype.XSDdecimal, NormalizeValue.dtDecimalXSD);
        map.put(XSDDatatype.XSDfloat, NormalizeValue.dtFloatXSD);
        map.put(XSDDatatype.XSDdouble, NormalizeValue.dtDoubleXSD);
        return map;
    }

    private static void addBaseAll(Map<RDFDatatype, DatatypeHandler> map) {
        map.put(XSDDatatype.XSDinteger, NormalizeValue.dtInteger);
        map.put(XSDDatatype.XSDdecimal, NormalizeValue.dtDecimalTTL);
        map.put(XSDDatatype.XSDfloat, NormalizeValue.dtFloatTTL);
        map.put(XSDDatatype.XSDdouble, NormalizeValue.dtDoubleTTL);
        map.put(XSDDatatype.XSDint, NormalizeValue.dtInteger);
        map.put(XSDDatatype.XSDlong, NormalizeValue.dtInteger);
        map.put(XSDDatatype.XSDshort, NormalizeValue.dtInteger);
        map.put(XSDDatatype.XSDbyte, NormalizeValue.dtInteger);
        map.put(XSDDatatype.XSDunsignedInt, NormalizeValue.dtInteger);
        map.put(XSDDatatype.XSDunsignedLong, NormalizeValue.dtInteger);
        map.put(XSDDatatype.XSDunsignedShort, NormalizeValue.dtInteger);
        map.put(XSDDatatype.XSDunsignedByte, NormalizeValue.dtInteger);
        map.put(XSDDatatype.XSDnonPositiveInteger, NormalizeValue.dtInteger);
        map.put(XSDDatatype.XSDnonNegativeInteger, NormalizeValue.dtInteger);
        map.put(XSDDatatype.XSDpositiveInteger, NormalizeValue.dtInteger);
        map.put(XSDDatatype.XSDnegativeInteger, NormalizeValue.dtInteger);
        map.put(XSDDatatype.XSDdateTime, NormalizeValue.dtDateTime);
        map.put(XSDDatatype.XSDboolean, NormalizeValue.dtBoolean);
    }

    static enum Style {
        General,
        XSD,
        XSD11,
        XSD10;

    }
}

