/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Node_Triple;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFApply;
import org.apache.jena.riot.system.StreamRDFBase;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.riot.system.StreamRDFWrapper;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.system.G;
import org.apache.jena.vocabulary.RDF;

public class RDFStar {
    private static final Node rdfSubject = RDF.Nodes.subject;
    private static final Node rdfPredicate = RDF.Nodes.predicate;
    private static final Node rdfObject = RDF.Nodes.object;
    private static final boolean USE_REIF_URIS = true;
    private static String URN_TRIPLE = "urn:triple:";
    private static String BNODE_TRIPLE = "_:T";

    public static Graph encodeAsRDF(Graph graph) {
        Graph output = GraphFactory.createDefaultGraph();
        StreamRDF dest = StreamRDFLib.graph(output);
        StreamRDF process = RDFStar.encodeAsRDF(dest);
        StreamRDFOps.graphToStream(graph, process);
        output.getPrefixMapping().samePrefixMappingAs(graph.getPrefixMapping());
        output.getPrefixMapping().setNsPrefix("rdf", RDF.getURI());
        return output;
    }

    public static void encodeAsRDF(Graph graph, StreamRDF dest) {
        StreamRDFOps.sendPrefixesToStream(graph.getPrefixMapping(), dest);
        dest.prefix("rdf", RDF.getURI());
        StreamRDF process = RDFStar.encodeAsRDF(dest);
        StreamRDFOps.graphToStream(graph, process);
    }

    public static Graph decodeFromRDF(Graph graph) {
        Graph gx = GraphFactory.createDefaultGraph();
        RDFStar.decodeFromRDF(graph, StreamRDFLib.graph(gx));
        gx.getPrefixMapping().setNsPrefixes(graph.getPrefixMapping());
        return gx;
    }

    public static void decodeFromRDF(Graph graph, StreamRDF dest) {
        Map<Node, Node> map = RDFStar.decodeBuildTerms(graph);
        RDFStar.decodeProcessGraph(graph, map, dest);
    }

    private static StreamRDF encodeAsRDF(StreamRDF dest) {
        return new ConvertToReified(dest);
    }

    public static Graph encodeAsRDFInPlace(Graph graph) {
        Graph gx = graph;
        ArrayList<Triple> inserts = new ArrayList<Triple>();
        final ArrayList<Triple> deletes = new ArrayList<Triple>();
        final StreamRDFApply insertStream = new StreamRDFApply(inserts::add, null);
        StreamRDFWrapper process = new StreamRDFWrapper(insertStream){
            private Cache<Node_Triple, Node> cache;
            {
                super(other);
                this.cache = CacheFactory.createCache(1000);
            }

            @Override
            public void triple(Triple triple) {
                Triple triple2 = RDFStar.encode(triple, this.cache, insertStream);
                if (triple2 != null) {
                    insertStream.triple(triple2);
                    deletes.add(triple);
                }
            }
        };
        StreamRDFOps.sendTriplesToStream(graph, (StreamRDF)process);
        RDFStar.update(gx, deletes, inserts);
        return gx;
    }

    public static Graph decodeFromRDFInPlace(Graph graph) {
        Graph gx = RDFStar.copyGraph(graph);
        graph.find(null, rdfPredicate, null).toList().forEach(t -> {
            ArrayList<Triple> inserts = new ArrayList<Triple>();
            ArrayList<Triple> deletes = new ArrayList<Triple>();
            RDFStar.decode(gx, t, deletes, inserts);
            RDFStar.update(gx, deletes, inserts);
        });
        return gx;
    }

    private static Triple encode(Triple triple, Cache<Node_Triple, Node> cache, StreamRDF stream) {
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        Node s1 = RDFStar.nodeReif(s, cache, stream);
        Node o1 = RDFStar.nodeReif(o, cache, stream);
        if (s1 == s && o1 == o) {
            return null;
        }
        if (s1 == null) {
            s1 = s;
        }
        if (o1 == null) {
            o1 = o;
        }
        return Triple.create(s1, p, o1);
    }

    private static Quad encode(Quad quad, Cache<Node_Triple, Node> cache, StreamRDF stream) {
        Node g = quad.getGraph();
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node s1 = RDFStar.nodeReif(s, cache, stream);
        Node o1 = RDFStar.nodeReif(o, cache, stream);
        if (s1 == s && o1 == o) {
            return null;
        }
        if (s1 == null) {
            s1 = s;
        }
        if (o1 == null) {
            o1 = o;
        }
        return Quad.create(g, s1, p, o1);
    }

    private static Node nodeReif(Node x, Cache<Node_Triple, Node> cache, StreamRDF output) {
        if (!x.isTripleTerm()) {
            return x;
        }
        Triple t = x.getTriple();
        Triple t2 = RDFStar.encode(t, cache, output);
        Node_Triple nt = t2 == null ? (Node_Triple)x : (Node_Triple)NodeFactory.createTripleTerm(t2);
        return cache.get(nt, key -> RDFStar.genReif(key, output));
    }

    private static Map<Node, Node> decodeBuildTerms(final Graph graph) {
        final HashMap<Node, Node> map = new HashMap<Node, Node>();
        StreamRDFBase builder = new StreamRDFBase(){

            @Override
            public void triple(Triple triple) {
                if (!rdfPredicate.equals(triple.getPredicate())) {
                    return;
                }
                Node reif = triple.getSubject();
                Node s = G.getOneSP(graph, reif, rdfSubject);
                Node p = G.getOneSP(graph, reif, rdfPredicate);
                Node o = G.getOneSP(graph, reif, rdfObject);
                Node tripleTerm = NodeFactory.createTripleTerm(s, p, o);
                map.put(reif, tripleTerm);
            }
        };
        StreamRDFOps.sendTriplesToStream(graph, (StreamRDF)builder);
        return map;
    }

    private static void decodeProcessGraph(Graph graph, final Map<Node, Node> map, StreamRDF dest) {
        StreamRDFWrapper translate = new StreamRDFWrapper(dest){

            @Override
            public void triple(Triple triple) {
                Node s = triple.getSubject();
                Node p = triple.getPredicate();
                Node o = triple.getObject();
                if (p.equals(rdfSubject) || p.equals(rdfPredicate) || p.equals(rdfObject)) {
                    return;
                }
                Node s1 = this.translate(s, map);
                Node o1 = this.translate(o, map);
                if (s == s1 && o == o1) {
                    super.triple(triple);
                } else {
                    Triple t = Triple.create(s1, p, o1);
                    super.triple(t);
                }
            }

            private Node translate(Node x, Map<Node, Node> map2) {
                Node x1 = map2.get(x);
                if (x1 == null) {
                    return x;
                }
                if (x1.isTripleTerm()) {
                    Triple triple = x1.getTriple();
                    Node s = triple.getSubject();
                    Node p = triple.getPredicate();
                    Node o = triple.getObject();
                    Node s1 = this.translate(s, map2);
                    Node o1 = this.translate(o, map2);
                    if (s == s1 && o == o1) {
                        return x1;
                    }
                    x1 = NodeFactory.createTripleTerm(s1, p, o1);
                }
                return x1;
            }
        };
        StreamRDFOps.sendTriplesToStream(graph, (StreamRDF)translate);
    }

    static boolean tripleHasNodeTriple(Triple triple) {
        return triple.getSubject().isTripleTerm() || triple.getObject().isTripleTerm();
    }

    private static Graph copyGraph(Graph graph) {
        Graph gx = GraphFactory.createDefaultGraph();
        gx.getPrefixMapping().setNsPrefixes(graph.getPrefixMapping());
        graph.find().forEachRemaining(gx::add);
        return gx;
    }

    private static void update(Graph graph, List<Triple> deletes, List<Triple> inserts) {
        deletes.forEach(graph::delete);
        inserts.forEach(graph::add);
    }

    private static Node genReif(Node_Triple nt, StreamRDF output) {
        Triple t = nt.getTriple();
        Node n = RDFStar.reificationSubject(nt);
        output.triple(Triple.create(n, rdfSubject, t.getSubject()));
        output.triple(Triple.create(n, rdfPredicate, t.getPredicate()));
        output.triple(Triple.create(n, rdfObject, t.getObject()));
        return n;
    }

    private static void decode(Graph graph, Triple pReifTriple, List<Triple> deletes, List<Triple> inserts) {
        Node reif = pReifTriple.getSubject();
        Triple sReifTriple = G.getOne(graph, reif, rdfSubject, null);
        Triple oReifTriple = G.getOne(graph, reif, rdfObject, null);
        Node s = sReifTriple.getObject();
        Node p = pReifTriple.getObject();
        Node o = oReifTriple.getObject();
        Node nodeTriple = NodeFactory.createTripleTerm(s, p, o);
        deletes.add(sReifTriple);
        deletes.add(pReifTriple);
        deletes.add(oReifTriple);
        G.find(graph, reif, null, reif).forEachRemaining(t -> {
            Triple tx = Triple.create(nodeTriple, t.getPredicate(), nodeTriple);
            deletes.add((Triple)t);
            inserts.add(tx);
        });
        G.find(graph, null, null, reif).forEachRemaining(t -> {
            if (!t.getSubject().equals(reif)) {
                Triple tx = Triple.create(t.getSubject(), t.getPredicate(), nodeTriple);
                deletes.add((Triple)t);
                inserts.add(tx);
            }
        });
        G.find(graph, reif, null, null).forEachRemaining(t -> {
            Node pred = t.getPredicate();
            if (!(pred.equals(rdfSubject) || pred.equals(rdfPredicate) || pred.equals(rdfObject) || t.getObject().equals(reif))) {
                Triple tx = Triple.create(nodeTriple, pred, t.getObject());
                deletes.add((Triple)t);
                inserts.add(tx);
            }
        });
    }

    public static Node reificationSubject(Node_Triple nodeTriple) {
        Triple t = nodeTriple.getTriple();
        String x = RDFStar.reifStr(t);
        x = Lib.murmurHashHex(x);
        return NodeFactory.createURI(URN_TRIPLE + x);
    }

    private static String reifStr(Triple triple) {
        return RDFStar.reifStr(triple.getSubject()) + RDFStar.reifStr(triple.getPredicate()) + RDFStar.reifStr(triple.getObject());
    }

    private static String reifStr(Node node) {
        if (node.isURI()) {
            return node.getURI();
        }
        if (node.isBlank()) {
            return node.getBlankNodeLabel();
        }
        if (node.isLiteral()) {
            if (!StringUtils.isEmpty(node.getLiteralLanguage())) {
                return node.getLiteralLexicalForm() + " @" + node.getLiteralLanguage();
            }
            return node.getLiteralLexicalForm() + " " + node.getLiteralDatatypeURI();
        }
        if (node.isTripleTerm()) {
            return RDFStar.reifStr(node.getTriple());
        }
        throw new JenaException("Node type not supported in Node_Triple: " + String.valueOf(node));
    }

    private static class ConvertToReified
    extends StreamRDFWrapper {
        private Cache<Node_Triple, Node> cache = CacheFactory.createCache(1000);

        public ConvertToReified(StreamRDF other) {
            super(other);
        }

        @Override
        public void triple(Triple triple) {
            Triple replacement = RDFStar.encode(triple, this.cache, this.other);
            if (replacement == null) {
                this.other.triple(triple);
            } else {
                this.other.triple(replacement);
            }
        }

        @Override
        public void quad(Quad quad) {
            Quad replacement = RDFStar.encode(quad, this.cache, this.other);
            if (replacement == null) {
                this.other.quad(quad);
            } else {
                this.other.quad(replacement);
            }
        }
    }
}

