/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.objecttools;

import java.util.LinkedList;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.commons.lang.AsciiSet;
import org.apache.juneau.commons.lang.StateEnum;
import org.apache.juneau.objecttools.AbstractMatcher;
import org.apache.juneau.objecttools.Equality;
import org.apache.juneau.objecttools.MatcherFactory;
import org.apache.juneau.objecttools.PatternException;

public class NumberMatcherFactory
extends MatcherFactory {
    public static final NumberMatcherFactory DEFAULT = new NumberMatcherFactory();

    @Override
    public boolean canMatch(ClassMeta<?> cm) {
        return cm.isNumber();
    }

    @Override
    public AbstractMatcher create(String pattern) {
        return new NumberMatcher(pattern);
    }

    private static class NumberMatcher
    extends AbstractMatcher {
        private static final AsciiSet SNUM = AsciiSet.of("-0123456789.");
        private static final AsciiSet NUM = AsciiSet.of("0123456789.");
        private static final AsciiSet WS = AsciiSet.of(" \t");
        NumberRange[] numberRanges;
        String pattern;

        public NumberMatcher(String s) {
            int i;
            this.pattern = s = s.trim();
            LinkedList<NumberRange> l = new LinkedList<NumberRange>();
            StateEnum state = StateEnum.S1;
            int mark = 0;
            boolean isNot = false;
            Equality eq = Equality.NONE;
            Integer n1 = null;
            Integer n2 = null;
            for (i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (state == StateEnum.S1) {
                    if (c == '!') {
                        isNot = true;
                        continue;
                    }
                    if (WS.contains(c)) {
                        state = StateEnum.S1;
                        continue;
                    }
                    if (c == '>') {
                        state = StateEnum.S2;
                        eq = Equality.GT;
                        continue;
                    }
                    if (c == '<') {
                        state = StateEnum.S3;
                        eq = Equality.LT;
                        continue;
                    }
                    if (!SNUM.contains(c)) break;
                    state = StateEnum.S6;
                    mark = i;
                    continue;
                }
                if (state == StateEnum.S2) {
                    if (c == '=') {
                        state = StateEnum.S4;
                        eq = Equality.GTE;
                        continue;
                    }
                    if (WS.contains(c)) {
                        state = StateEnum.S5;
                        continue;
                    }
                    if (!SNUM.contains(c)) break;
                    state = StateEnum.S6;
                    mark = i;
                    continue;
                }
                if (state == StateEnum.S3) {
                    if (c == '=') {
                        state = StateEnum.S4;
                        eq = Equality.LTE;
                        continue;
                    }
                    if (WS.contains(c)) {
                        state = StateEnum.S5;
                        continue;
                    }
                    if (!SNUM.contains(c)) break;
                    state = StateEnum.S6;
                    mark = i;
                    continue;
                }
                if (state == StateEnum.S4) {
                    if (WS.contains(c)) {
                        state = StateEnum.S5;
                        continue;
                    }
                    if (!SNUM.contains(c)) break;
                    mark = i;
                    state = StateEnum.S6;
                    continue;
                }
                if (state == StateEnum.S5) {
                    if (WS.contains(c)) {
                        state = StateEnum.S5;
                        continue;
                    }
                    if (!SNUM.contains(c)) break;
                    state = StateEnum.S6;
                    mark = i;
                    continue;
                }
                if (state == StateEnum.S6) {
                    if (NUM.contains(c)) {
                        state = StateEnum.S6;
                        continue;
                    }
                    if (WS.contains(c)) {
                        state = StateEnum.S7;
                        n1 = Integer.parseInt(s.substring(mark, i));
                        continue;
                    }
                    if (c != '-') break;
                    state = StateEnum.S8;
                    n1 = Integer.parseInt(s.substring(mark, i));
                    continue;
                }
                if (state == StateEnum.S7) {
                    if (WS.contains(c)) {
                        state = StateEnum.S7;
                        continue;
                    }
                    if (c == '-') {
                        state = StateEnum.S9;
                        continue;
                    }
                    if (!SNUM.contains(c)) break;
                    state = StateEnum.S6;
                    l.add(new NumberRange(eq, n1, isNot));
                    eq = Equality.NONE;
                    n1 = null;
                    isNot = false;
                    mark = i;
                    continue;
                }
                if (state == StateEnum.S8) {
                    if (WS.contains(c)) {
                        state = StateEnum.S8;
                        continue;
                    }
                    if (!SNUM.contains(c)) break;
                    state = StateEnum.S11;
                    mark = i;
                    continue;
                }
                if (state == StateEnum.S9) {
                    if (WS.contains(c)) {
                        state = StateEnum.S10;
                        continue;
                    }
                    if (!NUM.contains(c)) break;
                    state = StateEnum.S6;
                    l.add(new NumberRange(eq, n1, isNot));
                    eq = Equality.NONE;
                    n1 = null;
                    isNot = false;
                    mark = i - 1;
                    continue;
                }
                if (state == StateEnum.S10) {
                    if (WS.contains(c)) {
                        state = StateEnum.S10;
                        continue;
                    }
                    if (!SNUM.contains(c)) break;
                    state = StateEnum.S11;
                    mark = i;
                    continue;
                }
                if (SNUM.contains(c)) {
                    state = StateEnum.S11;
                    continue;
                }
                if (!WS.contains(c)) break;
                state = StateEnum.S1;
                n2 = Integer.parseInt(s.substring(mark, i));
                l.add(new NumberRange(eq, n1, n2, isNot));
                eq = Equality.NONE;
                n2 = null;
                n1 = null;
                isNot = false;
            }
            if (i != s.length()) {
                throw new PatternException("Invalid range pattern ({0}): {1}", new Object[]{state, s});
            }
            if (state != StateEnum.S1) {
                if (state == StateEnum.S2 || state == StateEnum.S3 || state == StateEnum.S4 || state == StateEnum.S8 || state == StateEnum.S9) {
                    throw new PatternException("Invalid range pattern (E{0}): {1}", new Object[]{state, s});
                }
                if (state == StateEnum.S6) {
                    n1 = Integer.parseInt(s.substring(mark).trim());
                    l.add(new NumberRange(eq, n1, isNot));
                } else {
                    n2 = Integer.parseInt(s.substring(mark).trim());
                    l.add(new NumberRange(eq, n1, n2, isNot));
                }
            }
            this.numberRanges = l.toArray(new NumberRange[l.size()]);
        }

        @Override
        public boolean matches(ClassMeta<?> cm, Object o) {
            Number n = (Number)o;
            if (this.numberRanges.length == 0) {
                return true;
            }
            for (NumberRange numberRange : this.numberRanges) {
                if (!numberRange.matches(n)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.pattern;
        }
    }

    private static class NumberRange {
        int start;
        int end;
        boolean isNot;

        public NumberRange(Equality eq, Integer num, boolean isNot) {
            this(eq, num, null, isNot);
        }

        public NumberRange(Equality eq, Integer start, Integer end, boolean isNot) {
            this.isNot = isNot;
            if (eq == Equality.NONE && end == null) {
                this.end = this.start = start.intValue();
            } else if (eq == Equality.GT) {
                this.start = start + 1;
                this.end = Integer.MAX_VALUE;
            } else if (eq == Equality.GTE) {
                this.start = start;
                this.end = Integer.MAX_VALUE;
            } else if (eq == Equality.LT) {
                this.start = Integer.MIN_VALUE;
                this.end = start - 1;
            } else if (eq == Equality.LTE) {
                this.start = Integer.MIN_VALUE;
                this.end = start;
            } else {
                this.start = start;
                this.end = end;
            }
        }

        public boolean matches(Number n) {
            boolean b;
            long i = n.longValue();
            boolean bl = b = i >= (long)this.start && i <= (long)this.end;
            if (this.isNot) {
                b = !b;
            }
            return b;
        }
    }
}

