/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.connection;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import org.apache.polaris.core.admin.model.SigV4AuthenticationParameters;
import org.apache.polaris.core.connection.AuthenticationParametersDpo;
import org.apache.polaris.core.connection.AuthenticationType;
import org.apache.polaris.core.credentials.PolarisCredentialManager;

public class SigV4AuthenticationParametersDpo
extends AuthenticationParametersDpo {
    @JsonProperty(value="roleArn")
    private final String roleArn;
    @JsonProperty(value="roleSessionName")
    private final String roleSessionName;
    @JsonProperty(value="externalId")
    private final String externalId;
    @JsonProperty(value="signingRegion")
    private final String signingRegion;
    @JsonProperty(value="signingName")
    private final String signingName;

    public SigV4AuthenticationParametersDpo(@JsonProperty(value="roleArn", required=true) String roleArn, @JsonProperty(value="roleSessionName", required=false) String roleSessionName, @JsonProperty(value="externalId", required=false) String externalId, @JsonProperty(value="signingRegion", required=true) String signingRegion, @JsonProperty(value="signingName", required=false) String signingName) {
        super(AuthenticationType.SIGV4.getCode());
        this.roleArn = roleArn;
        this.roleSessionName = roleSessionName;
        this.externalId = externalId;
        this.signingRegion = signingRegion;
        this.signingName = signingName;
    }

    @Nonnull
    public String getRoleArn() {
        return this.roleArn;
    }

    @Nullable
    public String getRoleSessionName() {
        return this.roleSessionName;
    }

    @Nullable
    public String getExternalId() {
        return this.externalId;
    }

    @Nonnull
    public String getSigningRegion() {
        return this.signingRegion;
    }

    @Nullable
    public String getSigningName() {
        return this.signingName;
    }

    @Override
    @Nonnull
    public Map<String, String> asIcebergCatalogProperties(PolarisCredentialManager credentialManager) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"rest.auth.type", (Object)"sigv4");
        builder.put((Object)"rest.signing-region", (Object)this.getSigningRegion());
        if (this.getSigningName() != null) {
            builder.put((Object)"rest.signing-name", (Object)this.getSigningName());
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public AuthenticationParameters asAuthenticationParametersModel() {
        return SigV4AuthenticationParameters.builder().setAuthenticationType(AuthenticationParameters.AuthenticationTypeEnum.SIGV4).setRoleArn(this.getRoleArn()).setRoleSessionName(this.getRoleSessionName()).setExternalId(this.getExternalId()).setSigningRegion(this.getSigningRegion()).setSigningName(this.getSigningName()).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authenticationTypeCode", this.getAuthenticationTypeCode()).add("roleArn", (Object)this.getRoleArn()).add("roleSessionName", (Object)this.getRoleSessionName()).add("externalId", (Object)this.getExternalId()).add("signingRegion", (Object)this.getSigningRegion()).add("signingName", (Object)this.getSigningName()).toString();
    }
}

