/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.ReplicatedDatabaseConfig;
import com.sleepycat.je.log.DbOpReplicationContext;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.VersionedWriteLoggable;
import com.sleepycat.je.log.entry.DbOperationType;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.txn.Txn;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class NameLNLogEntry
extends LNLogEntry<NameLN> {
    private static final int LAST_FORMAT_CHANGE = 12;
    private DbOperationType operationType;
    private DatabaseId truncateOldDbId;
    private ReplicatedDatabaseConfig replicatedCreateConfig;

    public NameLNLogEntry() {
        super(NameLN.class);
    }

    public NameLNLogEntry(LogEntryType entryType, DatabaseId dbId, Txn txn, long abortLsn, boolean abortKD, byte[] key, NameLN nameLN, ReplicationContext repContext) {
        super(entryType, dbId, txn, abortLsn, abortKD, null, null, -1L, 0, false, key, nameLN, false, 0, false);
        ReplicationContext operationContext = repContext;
        this.operationType = repContext.getDbOperationType();
        if (DbOperationType.isWriteConfigType(this.operationType)) {
            this.replicatedCreateConfig = ((DbOpReplicationContext)operationContext).getCreateConfig();
        }
        if (this.operationType == DbOperationType.TRUNCATE) {
            this.truncateOldDbId = ((DbOpReplicationContext)operationContext).getTruncateOldDbId();
        }
    }

    @Override
    public void readEntry(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer entryBuffer) {
        this.readBaseLNEntry(envImpl, header, entryBuffer, false);
        int version = header.getVersion();
        if (version >= 6) {
            this.operationType = DbOperationType.readTypeFromLog(entryBuffer, version);
            if (DbOperationType.isWriteConfigType(this.operationType)) {
                this.replicatedCreateConfig = new ReplicatedDatabaseConfig();
                this.replicatedCreateConfig.readFromLog(entryBuffer, version);
            }
            if (this.operationType == DbOperationType.TRUNCATE) {
                this.truncateOldDbId = new DatabaseId();
                this.truncateOldDbId.readFromLog(entryBuffer, version);
            }
        } else {
            this.operationType = DbOperationType.NONE;
        }
    }

    @Override
    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        super.dumpEntry(sb, verbose);
        this.operationType.dumpLog(sb, verbose);
        if (this.replicatedCreateConfig != null) {
            this.replicatedCreateConfig.dumpLog(sb, verbose);
        }
        if (this.truncateOldDbId != null) {
            this.truncateOldDbId.dumpLog(sb, verbose);
        }
        return sb;
    }

    @Override
    public int getLastFormatChange() {
        return 12;
    }

    @Override
    public Collection<VersionedWriteLoggable> getEmbeddedLoggables() {
        ArrayList<VersionedWriteLoggable> list = new ArrayList<VersionedWriteLoggable>(super.getEmbeddedLoggables());
        list.addAll(Arrays.asList(new NameLN(), DbOperationType.NONE, new ReplicatedDatabaseConfig()));
        return list;
    }

    @Override
    public int getSize(int logVersion, boolean forReplication) {
        int size = this.getBaseLNEntrySize(logVersion, false, forReplication);
        size += this.operationType.getLogSize(logVersion, forReplication);
        if (DbOperationType.isWriteConfigType(this.operationType)) {
            size += this.replicatedCreateConfig.getLogSize(logVersion, forReplication);
        }
        if (this.operationType == DbOperationType.TRUNCATE) {
            size += this.truncateOldDbId.getLogSize(logVersion, forReplication);
        }
        return size;
    }

    @Override
    public void writeEntry(ByteBuffer destBuffer, int logVersion, boolean forReplication) {
        this.writeBaseLNEntry(destBuffer, logVersion, false, forReplication);
        this.operationType.writeToLog(destBuffer, logVersion, forReplication);
        if (DbOperationType.isWriteConfigType(this.operationType)) {
            this.replicatedCreateConfig.writeToLog(destBuffer, logVersion, forReplication);
        }
        if (this.operationType == DbOperationType.TRUNCATE) {
            this.truncateOldDbId.writeToLog(destBuffer, logVersion, forReplication);
        }
    }

    @Override
    public boolean logicalEquals(LogEntry other) {
        if (!super.logicalEquals(other)) {
            return false;
        }
        NameLNLogEntry otherEntry = (NameLNLogEntry)other;
        if (!this.operationType.logicalEquals(otherEntry.operationType)) {
            return false;
        }
        if (this.truncateOldDbId != null && !this.truncateOldDbId.logicalEquals(otherEntry.truncateOldDbId)) {
            return false;
        }
        return this.replicatedCreateConfig == null || this.replicatedCreateConfig.logicalEquals(otherEntry.replicatedCreateConfig);
    }

    public DbOperationType getOperationType() {
        return this.operationType;
    }

    public ReplicatedDatabaseConfig getReplicatedCreateConfig() {
        return this.replicatedCreateConfig;
    }

    public DatabaseId getTruncateOldDbId() {
        return this.truncateOldDbId;
    }

    @Override
    public void dumpRep(StringBuilder sb) {
        super.dumpRep(sb);
        sb.append(" dbop=").append(this.operationType);
    }
}

