/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.net.URI;
import java.util.Collection;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.gcx.MimeFileTypeAdapter;
import org.opengis.metadata.distribution.DataFile;
import org.opengis.metadata.distribution.Format;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;

@XmlType(name="MX_DataFile_Type", namespace="http://standards.iso.org/iso/19115/-3/mdt/1.0", propOrder={"fileName", "fileDescription", "fileType", "featureTypes", "fileFormat"})
@XmlRootElement(name="MX_DataFile", namespace="http://standards.iso.org/iso/19115/-3/mdt/1.0")
public class DefaultDataFile
extends ISOMetadata
implements DataFile {
    private static final long serialVersionUID = -4556006719009557349L;
    private URI fileName;
    private InternationalString fileDescription;
    private String fileType;
    private Collection<LocalName> featureTypes;
    @Deprecated(since="1.0")
    private Format fileFormat;

    public DefaultDataFile() {
    }

    public DefaultDataFile(DataFile object) {
        super(object);
        if (object != null) {
            if (object instanceof DefaultDataFile) {
                DefaultDataFile df = (DefaultDataFile)object;
                this.fileName = df.getFileName();
                this.fileDescription = df.getFileDescription();
                this.fileType = df.getFileType();
            }
            this.featureTypes = DefaultDataFile.copyCollection(object.getFeatureTypes(), LocalName.class);
            this.fileFormat = object.getFileFormat();
        }
    }

    public static DefaultDataFile castOrCopy(DataFile object) {
        if (object == null || object instanceof DefaultDataFile) {
            return (DefaultDataFile)object;
        }
        return new DefaultDataFile(object);
    }

    @XmlElement(name="fileName", required=true)
    public URI getFileName() {
        return this.fileName;
    }

    public void setFileName(URI newValue) {
        this.checkWritePermission(this.fileName);
        this.fileName = newValue;
    }

    @XmlElement(name="fileDescription", required=true)
    public InternationalString getFileDescription() {
        return this.fileDescription;
    }

    public void setFileDescription(InternationalString newValue) {
        this.checkWritePermission(this.fileDescription);
        this.fileDescription = newValue;
    }

    @XmlElement(name="fileType", required=true)
    @XmlJavaTypeAdapter(value=MimeFileTypeAdapter.class)
    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String newValue) {
        this.checkWritePermission(this.fileType);
        this.fileType = newValue;
    }

    @XmlElement(name="featureTypes")
    public Collection<LocalName> getFeatureTypes() {
        this.featureTypes = this.nonNullCollection(this.featureTypes, LocalName.class);
        return this.featureTypes;
    }

    public void setFeatureTypes(Collection<? extends LocalName> newValues) {
        this.featureTypes = this.writeCollection(newValues, this.featureTypes, LocalName.class);
    }

    @Deprecated(since="1.0")
    @XmlElement(name="fileFormat", namespace="http://www.isotc211.org/2005/gmx")
    public Format getFileFormat() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.fileFormat : null;
    }

    @Deprecated(since="1.0")
    public void setFileFormat(Format newValue) {
        this.checkWritePermission(this.fileFormat);
        this.fileFormat = newValue;
    }
}

