/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.export.spi.ModelExporter;
import org.apache.sling.models.factory.ExportException;
import org.apache.sling.models.factory.InvalidAdaptableException;
import org.apache.sling.models.factory.MissingElementsException;
import org.apache.sling.models.factory.MissingExporterException;
import org.apache.sling.models.factory.ModelClassException;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.ModelAdapterFactoryConfiguration;
import org.apache.sling.models.impl.Result;
import org.apache.sling.models.impl.injectors.SelfInjector;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.testmodels.classes.CachedModelWithSelfReference;
import org.apache.sling.models.testmodels.classes.ConstructorWithExceptionModel;
import org.apache.sling.models.testmodels.classes.DefaultStringModel;
import org.apache.sling.models.testmodels.classes.InvalidModelWithMissingAnnotation;
import org.apache.sling.models.testmodels.classes.ResourceModelWithRequiredField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.converter.Converter;
import org.osgi.util.converter.Converters;

@ExtendWith(value={MockitoExtension.class})
public class AdapterFactoryTest {
    @Mock
    private Resource resource;
    @Mock
    private SlingJakartaHttpServletRequest request;
    private ModelAdapterFactory factory;

    public static ModelAdapterFactory createModelAdapterFactory() {
        BundleContext bundleContext = (BundleContext)Mockito.mock(BundleContext.class);
        return AdapterFactoryTest.createModelAdapterFactory(bundleContext);
    }

    public static ModelAdapterFactory createModelAdapterFactory(BundleContext bundleContext) {
        ComponentContext componentCtx = (ComponentContext)Mockito.mock(ComponentContext.class);
        Mockito.when((Object)componentCtx.getBundleContext()).thenReturn((Object)bundleContext);
        ModelAdapterFactory factory = new ModelAdapterFactory();
        Converter c = Converters.standardConverter();
        HashMap map = new HashMap();
        ModelAdapterFactoryConfiguration config = (ModelAdapterFactoryConfiguration)c.convert(map).to(ModelAdapterFactoryConfiguration.class);
        factory.activate(componentCtx, config);
        factory.injectAnnotationProcessorFactories = Collections.emptyList();
        factory.injectAnnotationProcessorFactories2 = Collections.emptyList();
        factory.injectors = Collections.emptyList();
        factory.implementationPickers = Collections.emptyList();
        return factory;
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Arrays.asList(new ValueMapInjector(), new SelfInjector());
        this.factory.modelExporters = Arrays.asList(new FirstStringExporter(), new SecondStringExporter(), new FirstIntegerExporter());
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{DefaultStringModel.class, ConstructorWithExceptionModel.class, NestedModel.class, NestedModelWithInvalidAdaptable.class, NestedModelWithInvalidAdaptable2.class, ResourceModelWithRequiredField.class, CachedModelWithSelfReference.class});
    }

    @Test
    void testIsModelClass() {
        Assertions.assertTrue((boolean)this.factory.isModelClass(DefaultStringModel.class));
        Assertions.assertFalse((boolean)this.factory.isModelClass(InvalidModelWithMissingAnnotation.class));
    }

    @Test
    void testCanCreateFromAdaptable() {
        Assertions.assertTrue((boolean)this.factory.canCreateFromAdaptable((Object)this.resource, DefaultStringModel.class));
        Assertions.assertFalse((boolean)this.factory.canCreateFromAdaptable((Object)this.request, DefaultStringModel.class));
    }

    @Test
    void testCanCreateFromAdaptableWithInvalidModel() {
        Assertions.assertFalse((boolean)this.factory.canCreateFromAdaptable((Object)this.resource, InvalidModelWithMissingAnnotation.class));
    }

    @Test
    void testCreateFromNonModelClass() {
        Assertions.assertThrows(ModelClassException.class, () -> this.factory.createModel((Object)this.resource, InvalidModelWithMissingAnnotation.class));
    }

    @Test
    void testCreateFromInvalidAdaptable() {
        Assertions.assertThrows(InvalidAdaptableException.class, () -> this.factory.createModel((Object)this.request, DefaultStringModel.class));
    }

    @Test
    void testCreateWithConstructorException() {
        Assertions.assertThrows(RuntimeException.class, () -> this.factory.createModel((Object)this.resource, ConstructorWithExceptionModel.class));
    }

    @Test
    void testCreatedNestedModelWithInvalidAdaptable() {
        Assertions.assertThrows(MissingElementsException.class, () -> this.factory.createModel((Object)this.request, NestedModelWithInvalidAdaptable.class));
    }

    @Test
    void testCreatedNestedModelWithInvalidAdaptable2() {
        Assertions.assertThrows(MissingElementsException.class, () -> this.factory.createModel((Object)this.request, NestedModelWithInvalidAdaptable2.class));
    }

    @Test
    void testCreatedNestedModel() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("required", "required");
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Mockito.when((Object)((ValueMap)this.resource.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        NestedModel model = (NestedModel)this.factory.createModel((Object)this.resource, NestedModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"required", (Object)model.getNestedModel().getRequired());
    }

    @Test
    void testCreatedNestedModelWithMissingElements() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("invalid", "required");
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Mockito.when((Object)((ValueMap)this.resource.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        Assertions.assertThrows(MissingElementsException.class, () -> this.factory.createModel((Object)this.resource, NestedModel.class));
    }

    @Test
    void testSelectExporterByName() {
        Result result = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)result.wasSuccessful()).thenReturn((Object)true);
        Mockito.when((Object)result.getValue()).thenReturn(new Object());
        String exported = (String)Assertions.assertDoesNotThrow(() -> (String)this.factory.handleAndExportResult(result, "second", String.class, Collections.emptyMap()));
        Assertions.assertEquals((Object)"Export from second", (Object)exported);
    }

    @Test
    void testSelectExporterByType() {
        Result result = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)result.wasSuccessful()).thenReturn((Object)true);
        Mockito.when((Object)result.getValue()).thenReturn(new Object());
        Integer exported = (Integer)Assertions.assertDoesNotThrow(() -> (Integer)this.factory.handleAndExportResult(result, "first", Integer.class, Collections.emptyMap()));
        Assertions.assertEquals((Integer)42, (Integer)exported);
    }

    @Test
    void testSelectExporterByNameAndWrongType() {
        Result result = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)result.wasSuccessful()).thenReturn((Object)true);
        Mockito.when((Object)result.getValue()).thenReturn(new Object());
        Assertions.assertThrows(MissingExporterException.class, () -> this.factory.handleAndExportResult(result, "second", Integer.class, Collections.emptyMap()));
    }

    @Test
    void testCreateCachedModelWillNotCrashTheVMWithOOM() {
        double LOAD_FACTOR = 2.0;
        long SIZE_OF_LONG = 8L;
        long instanceSize = SIZE_OF_LONG * (long)CachedModelWithSelfReference.numberOfLongs;
        long maxHeapSize = Runtime.getRuntime().maxMemory();
        long maxInstances = (long)((double)(maxHeapSize / instanceSize) * LOAD_FACTOR);
        Assertions.assertDoesNotThrow(() -> {
            for (long i = 0L; i < maxInstances; ++i) {
                CachedModelWithSelfReference model = (CachedModelWithSelfReference)this.factory.createModel(Mockito.mock(SlingJakartaHttpServletRequest.class), CachedModelWithSelfReference.class);
                for (int j = 0; j < model.longs.length; ++j) {
                    model.longs[j] = j;
                }
            }
        });
        Assertions.assertTrue((maxInstances > 0L ? 1 : 0) != 0);
    }

    private static class FirstStringExporter
    implements ModelExporter {
        private FirstStringExporter() {
        }

        public boolean isSupported(@NotNull Class<?> aClass) {
            return aClass == String.class;
        }

        @Nullable
        public <T> T export(@NotNull Object o, @NotNull Class<T> aClass, @NotNull Map<String, String> map) throws ExportException {
            if (aClass == String.class) {
                return (T)"Export from first";
            }
            throw new ExportException(String.format("%s is not supported.", aClass));
        }

        @NotNull
        public String getName() {
            return "first";
        }
    }

    private static class SecondStringExporter
    implements ModelExporter {
        private SecondStringExporter() {
        }

        public boolean isSupported(@NotNull Class<?> aClass) {
            return aClass == String.class;
        }

        @Nullable
        public <T> T export(@NotNull Object o, @NotNull Class<T> aClass, @NotNull Map<String, String> map) throws ExportException {
            if (aClass == String.class) {
                return (T)"Export from second";
            }
            throw new ExportException(String.format("%s is not supported.", aClass));
        }

        @NotNull
        public String getName() {
            return "second";
        }
    }

    private static class FirstIntegerExporter
    implements ModelExporter {
        private FirstIntegerExporter() {
        }

        public boolean isSupported(@NotNull Class<?> aClass) {
            return aClass == Integer.class;
        }

        @Nullable
        public <T> T export(@NotNull Object o, @NotNull Class<T> aClass, @NotNull Map<String, String> map) throws ExportException {
            if (aClass == Integer.class) {
                return (T)Integer.valueOf(42);
            }
            throw new ExportException(String.format("%s is not supported.", aClass));
        }

        @NotNull
        public String getName() {
            return "first";
        }
    }

    @Model(adaptables={Resource.class})
    public static class NestedModel {
        @Self
        ResourceModelWithRequiredField nestedModel;

        public ResourceModelWithRequiredField getNestedModel() {
            return this.nestedModel;
        }
    }

    @Model(adaptables={SlingJakartaHttpServletRequest.class})
    public static class NestedModelWithInvalidAdaptable {
        @Self
        DefaultStringModel nestedModel;
    }

    @Model(adaptables={SlingJakartaHttpServletRequest.class})
    public static class NestedModelWithInvalidAdaptable2 {
        @Self
        InvalidModelWithMissingAnnotation nestedModel;
    }
}

