/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.JakartaToJavaxRequestWrapper;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ValueMapInjectorTest {
    private ValueMapInjector injector = new ValueMapInjector();
    @Mock
    private ValueMap valueMap;
    @Mock
    private AnnotatedElement element;
    @Mock
    private DisposalCallbackRegistry registry;
    @Mock
    private Resource resource;
    @Mock
    private SlingJakartaHttpServletRequest jakartaRequest;
    private static final String STRING_PARAM = "param1";
    private static final String INTEGER_PARAM = "param2";
    private static final String CLASS_PARAM = "param3";
    private static final String STRING_VALUE = "myValue";
    private static final int INTEGER_VALUE = 42;
    private static final ResourceResolver CLASS_INSTANCE = (ResourceResolver)Mockito.mock(ResourceResolver.class);

    ValueMapInjectorTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.lenient().when((Object)((String)this.valueMap.get(STRING_PARAM, String.class))).thenReturn((Object)STRING_VALUE);
        Mockito.lenient().when((Object)((Integer)this.valueMap.get(INTEGER_PARAM, Integer.class))).thenReturn((Object)42);
        Mockito.lenient().when((Object)((ResourceResolver)this.valueMap.get(CLASS_PARAM, ResourceResolver.class))).thenReturn((Object)CLASS_INSTANCE);
        Mockito.lenient().when((Object)((ValueMap)this.resource.adaptTo(ValueMap.class))).thenReturn((Object)this.valueMap);
        Mockito.lenient().when((Object)this.jakartaRequest.getResource()).thenReturn((Object)this.resource);
    }

    @Test
    void testStringParam() {
        Object result = this.injector.getValue((Object)this.valueMap, STRING_PARAM, String.class, this.element, this.registry);
        Assertions.assertEquals((Object)STRING_VALUE, (Object)result);
    }

    @Test
    void testIntegerParam() {
        Object result = this.injector.getValue((Object)this.valueMap, INTEGER_PARAM, Integer.class, this.element, this.registry);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    void testClassInstance() {
        Object result = this.injector.getValue((Object)this.valueMap, CLASS_PARAM, ResourceResolver.class, this.element, this.registry);
        Assertions.assertSame((Object)CLASS_INSTANCE, (Object)result);
    }

    @Test
    void testNonMatchingClassInstance() {
        Object result = this.injector.getValue((Object)this.valueMap, CLASS_PARAM, Resource.class, this.element, this.registry);
        Assertions.assertNull((Object)result);
    }

    @Test
    void testNonValueMapAdaptable() {
        Object result = this.injector.getValue(Mockito.mock(ResourceResolver.class), STRING_PARAM, String.class, this.element, this.registry);
        Assertions.assertNull((Object)result);
    }

    @Test
    void testStringParamFromJakartaRequest() {
        Object result = this.injector.getValue((Object)this.jakartaRequest, STRING_PARAM, String.class, this.element, this.registry);
        Assertions.assertEquals((Object)STRING_VALUE, (Object)result);
    }

    @Deprecated(since="2.0.0")
    @Test
    void testStringParamFromJavaxRequest() {
        SlingHttpServletRequest javaxRequest = JakartaToJavaxRequestWrapper.toJavaxRequest((SlingJakartaHttpServletRequest)this.jakartaRequest);
        Object result = this.injector.getValue((Object)javaxRequest, STRING_PARAM, String.class, this.element, this.registry);
        Assertions.assertEquals((Object)STRING_VALUE, (Object)result);
    }
}

