/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.it.testing;

import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.junit.rules.TeleporterRule;
import org.apache.sling.models.it.testbundle.models.SlingPropertyAnnotationTestModel;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class InjectorSpecificAnnotationIT {
    @Rule
    public final TeleporterRule teleporter = TeleporterRule.forClass(this.getClass(), (String)"SM_Teleporter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        ResourceResolverFactory rrFactory = (ResourceResolverFactory)this.teleporter.getService(ResourceResolverFactory.class);
        String value = RandomStringUtils.secure().nextAlphanumeric(10);
        ResourceResolver resolver = null;
        Node createdNode = null;
        try {
            resolver = rrFactory.getServiceResourceResolver(null);
            Session session = (Session)resolver.adaptTo(Session.class);
            Node rootNode = session.getRootNode();
            createdNode = rootNode.addNode("test_" + RandomStringUtils.secure().nextAlphanumeric(10));
            createdNode.setProperty("testProperty", value);
            session.save();
            Resource resource = resolver.getResource(createdNode.getPath());
            SlingPropertyAnnotationTestModel model = (SlingPropertyAnnotationTestModel)resource.adaptTo(SlingPropertyAnnotationTestModel.class);
            Assert.assertNotNull((String)"Model is null", (Object)model);
            Assert.assertEquals((String)"Test Property is not set correctly", (Object)value, (Object)model.getTestProperty());
        }
        finally {
            if (createdNode != null) {
                createdNode.remove();
            }
            if (resolver != null) {
                resolver.close();
            }
        }
    }
}

