/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.storm.messaging.netty.Login;
import org.apache.storm.messaging.netty.SaslMessageToken;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosSaslNettyClient {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosSaslNettyClient.class);
    private SaslClient saslClient;
    private Subject subject;
    private String jaasSection;

    public KerberosSaslNettyClient(Map<String, Object> topoConf, String jaasSection, String host) {
        LOG.debug("KerberosSaslNettyClient: Creating SASL {} client to authenticate to server ", (Object)"GSSAPI");
        LOG.info("Creating Kerberos Client.");
        LOG.debug("KerberosSaslNettyClient: authmethod {}", (Object)"GSSAPI");
        SaslClientCallbackHandler ch = new SaslClientCallbackHandler();
        String jaasConfFile = ClientAuthUtils.getJaasConf(topoConf);
        this.subject = null;
        try {
            LOG.debug("Trying to login using {}.", (Object)jaasConfFile);
            Login login = new Login(jaasSection, ch, jaasConfFile);
            this.subject = login.getSubject();
            LOG.debug("Got Subject: {}", (Object)this.subject.toString());
        }
        catch (LoginException ex) {
            LOG.error("Client failed to login in principal:" + String.valueOf(ex), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        if (this.subject.getPrivateCredentials(KerberosTicket.class).isEmpty()) {
            LOG.error("Failed to verify user principal.");
            throw new RuntimeException("Fail to verify user principal with section \"" + jaasSection + "\" in login configuration file " + jaasConfFile);
        }
        String serviceName = null;
        try {
            serviceName = ClientAuthUtils.get(topoConf, jaasSection, "serviceName");
        }
        catch (IOException e) {
            LOG.error("Failed to get service name.", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            Principal principal = (Principal)this.subject.getPrincipals().toArray()[0];
            final String fPrincipalName = principal.getName();
            final String fHost = host;
            final String fServiceName = serviceName;
            final SaslClientCallbackHandler fch = ch;
            LOG.debug("Kerberos Client with principal: {}, host: {}", (Object)fPrincipalName, (Object)fHost);
            this.saslClient = Subject.doAs(this.subject, new PrivilegedExceptionAction<SaslClient>(){

                @Override
                public SaslClient run() {
                    try {
                        TreeMap<String, String> props = new TreeMap<String, String>();
                        props.put("javax.security.sasl.qop", "auth");
                        props.put("javax.security.sasl.server.authentication", "false");
                        return Sasl.createSaslClient(new String[]{"GSSAPI"}, fPrincipalName, fServiceName, fHost, props, fch);
                    }
                    catch (Exception e) {
                        LOG.error("Subject failed to create sasl client.", (Throwable)e);
                        return null;
                    }
                }
            });
            LOG.info("Got Client: {}", (Object)this.saslClient);
        }
        catch (PrivilegedActionException e) {
            LOG.error("KerberosSaslNettyClient: Could not create Sasl Netty Client.");
            throw new RuntimeException(e);
        }
    }

    public boolean isComplete() {
        return this.saslClient.isComplete();
    }

    public byte[] saslResponse(SaslMessageToken saslTokenMessage) {
        try {
            final SaslMessageToken fSaslTokenMessage = saslTokenMessage;
            byte[] retval = Subject.doAs(this.subject, new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() {
                    try {
                        byte[] retval = KerberosSaslNettyClient.this.saslClient.evaluateChallenge(fSaslTokenMessage.getSaslToken());
                        return retval;
                    }
                    catch (SaslException e) {
                        LOG.error("saslResponse: Failed to respond to SASL server's token:", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
            return retval;
        }
        catch (PrivilegedActionException e) {
            LOG.error("Failed to generate response for token: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static class SaslClientCallbackHandler
    implements CallbackHandler {
        private SaslClientCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                LOG.info("Kerberos Client Callback Handler got callback: {}", callback.getClass());
            }
        }
    }
}

