/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.messaging.netty.ISaslClient;
import org.apache.storm.messaging.netty.SaslMessageToken;
import org.apache.storm.messaging.netty.SaslNettyClient;
import org.apache.storm.messaging.netty.SaslNettyClientState;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelHandler;
import org.apache.storm.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslStormClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SaslStormClientHandler.class);
    private final long startTime;
    private final ISaslClient client;
    private byte[] token;
    private String name;

    public SaslStormClientHandler(ISaslClient client) throws IOException {
        this.client = client;
        this.startTime = System.currentTimeMillis();
        this.getSASLCredentials();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        LOG.info("Connection established from " + String.valueOf(channel.localAddress()) + " to " + String.valueOf(channel.remoteAddress()));
        try {
            SaslNettyClient saslNettyClient = (SaslNettyClient)channel.attr(SaslNettyClientState.SASL_NETTY_CLIENT).get();
            if (saslNettyClient == null) {
                LOG.debug("Creating saslNettyClient now for channel: " + String.valueOf(channel));
                saslNettyClient = new SaslNettyClient(this.name, this.token);
                channel.attr(SaslNettyClientState.SASL_NETTY_CLIENT).set((Object)saslNettyClient);
            }
            LOG.debug("Sending SASL_TOKEN_MESSAGE_REQUEST");
            channel.writeAndFlush((Object)ControlMessage.SASL_TOKEN_MESSAGE_REQUEST, channel.voidPromise());
        }
        catch (Exception e) {
            LOG.error("Failed to authenticate with server due to error: ", (Throwable)e);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object message) throws Exception {
        LOG.debug("send/recv time (ms): {}", (Object)(System.currentTimeMillis() - this.startTime));
        if (message instanceof ControlMessage) {
            this.handleControlMessage(ctx, (ControlMessage)message);
        } else if (message instanceof SaslMessageToken) {
            this.handleSaslMessageToken(ctx, (SaslMessageToken)message);
        } else {
            LOG.error("Unexpected message from server: {}", message);
        }
    }

    private SaslNettyClient getChannelSaslNettyClient(Channel channel) throws Exception {
        SaslNettyClient saslNettyClient = (SaslNettyClient)channel.attr(SaslNettyClientState.SASL_NETTY_CLIENT).get();
        if (saslNettyClient == null) {
            throw new Exception("saslNettyClient was unexpectedly null for channel: " + String.valueOf(channel));
        }
        return saslNettyClient;
    }

    private void handleControlMessage(ChannelHandlerContext ctx, ControlMessage controlMessage) throws Exception {
        SaslNettyClient saslNettyClient = this.getChannelSaslNettyClient(ctx.channel());
        if (controlMessage == ControlMessage.SASL_COMPLETE_REQUEST) {
            LOG.debug("Server has sent us the SaslComplete message. Allowing normal work to proceed.");
            if (!saslNettyClient.isComplete()) {
                LOG.error("Server returned a Sasl-complete message, but as far as we can tell, we are not authenticated yet.");
                throw new Exception("Server returned a Sasl-complete message, but as far as we can tell, we are not authenticated yet.");
            }
            ctx.pipeline().remove((ChannelHandler)this);
            this.client.channelReady(ctx.channel());
            ctx.fireChannelRead((Object)controlMessage);
        } else {
            LOG.warn("Unexpected control message: {}", (Object)controlMessage);
        }
    }

    private void handleSaslMessageToken(ChannelHandlerContext ctx, SaslMessageToken saslMessageToken) throws Exception {
        Channel channel = ctx.channel();
        SaslNettyClient saslNettyClient = this.getChannelSaslNettyClient(channel);
        LOG.debug("Responding to server's token of length: " + saslMessageToken.getSaslToken().length);
        byte[] responseToServer = saslNettyClient.saslResponse(saslMessageToken);
        if (responseToServer == null) {
            LOG.debug("Response to server is null: authentication should now be complete.");
            if (!saslNettyClient.isComplete()) {
                LOG.warn("Generated a null response, but authentication is not complete.");
                throw new Exception("Server response is null, but as far as we can tell, we are not authenticated yet.");
            }
            this.client.channelReady(channel);
            return;
        }
        LOG.debug("Response to server token has length:" + responseToServer.length);
        SaslMessageToken saslResponse = new SaslMessageToken(responseToServer);
        channel.writeAndFlush((Object)saslResponse, channel.voidPromise());
    }

    private void getSASLCredentials() throws IOException {
        this.name = this.client.name();
        String secretKey = this.client.secretKey();
        if (secretKey != null) {
            this.token = secretKey.getBytes();
        }
        LOG.debug("SASL credentials for storm topology " + this.name + " is " + secretKey);
    }
}

