/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.storm.metric.internal.LatencyStat;

public class MultiLatencyStat<T> {
    private final int numBuckets;
    private ConcurrentHashMap<T, LatencyStat> lat = new ConcurrentHashMap();

    public MultiLatencyStat(int numBuckets) {
        this.numBuckets = numBuckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LatencyStat get(T key) {
        LatencyStat c = this.lat.get(key);
        if (c == null) {
            MultiLatencyStat multiLatencyStat = this;
            synchronized (multiLatencyStat) {
                c = this.lat.get(key);
                if (c == null) {
                    c = new LatencyStat(this.numBuckets);
                    this.lat.put(key, c);
                }
            }
        }
        return c;
    }

    public void record(T key, long latency) {
        this.get(key).record(latency);
    }

    public Map<String, Map<T, Double>> getTimeLatAvg() {
        HashMap<String, Map<T, Double>> ret = new HashMap<String, Map<T, Double>>();
        for (Map.Entry<T, LatencyStat> entry : this.lat.entrySet()) {
            T key = entry.getKey();
            Map<String, Double> toFlip = entry.getValue().getTimeLatAvg();
            for (Map.Entry<String, Double> subEntry : toFlip.entrySet()) {
                String time = subEntry.getKey();
                HashMap<T, Double> tmp = (HashMap<T, Double>)ret.get(time);
                if (tmp == null) {
                    tmp = new HashMap<T, Double>();
                    ret.put(time, tmp);
                }
                tmp.put(key, subEntry.getValue());
            }
        }
        return ret;
    }

    public void close() {
        for (LatencyStat l : this.lat.values()) {
            l.close();
        }
    }
}

