/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.io.IOException;
import org.apache.storm.security.auth.ITransportPlugin;
import org.apache.storm.thrift.transport.TTransport;
import org.apache.storm.thrift.transport.TTransportException;
import org.apache.storm.utils.StormBoundedExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TBackoffConnect {
    private static final Logger LOG = LoggerFactory.getLogger(TBackoffConnect.class);
    private int completedRetries = 0;
    private int retryTimes;
    private StormBoundedExponentialBackoffRetry waitGrabber;
    private boolean retryForever = false;

    public TBackoffConnect(int retryTimes, int retryInterval, int retryIntervalCeiling, boolean retryForever) {
        this.retryForever = retryForever;
        this.retryTimes = retryTimes;
        this.waitGrabber = new StormBoundedExponentialBackoffRetry(retryInterval, retryIntervalCeiling, retryTimes);
    }

    public TBackoffConnect(int retryTimes, int retryInterval, int retryIntervalCeiling) {
        this(retryTimes, retryInterval, retryIntervalCeiling, false);
    }

    public TTransport doConnectWithRetry(ITransportPlugin transportPlugin, TTransport underlyingTransport, String host, String asUser) throws IOException {
        boolean connected = false;
        TTransport transportResult = null;
        while (!connected) {
            try {
                transportResult = transportPlugin.connect(underlyingTransport, host, asUser);
                connected = true;
            }
            catch (TTransportException ex) {
                this.retryNext(ex);
            }
        }
        return transportResult;
    }

    private void retryNext(TTransportException ex) {
        if (!this.canRetry()) {
            throw new RuntimeException(ex);
        }
        try {
            long sleeptime = this.waitGrabber.getSleepTimeMs(this.completedRetries, 0L);
            LOG.debug("Failed to connect. Retrying... (" + Integer.toString(this.completedRetries) + ") in " + Long.toString(sleeptime) + "ms");
            Thread.sleep(sleeptime);
        }
        catch (InterruptedException e) {
            LOG.info("Nimbus connection retry interrupted.");
        }
        ++this.completedRetries;
    }

    private boolean canRetry() {
        return this.retryForever || this.completedRetries < this.retryTimes;
    }
}

