/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.storm.serialization.SerializationDelegate;

public class GzipSerializationDelegate
implements SerializationDelegate {
    @Override
    public void prepare(Map<String, Object> topoConf) {
    }

    @Override
    public byte[] serialize(Object object) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(bos);
            ObjectOutputStream oos = new ObjectOutputStream(gos);
            oos.writeObject(object);
            oos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> clazz) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            GZIPInputStream gis = new GZIPInputStream(bis);
            ObjectInputStream ois = new ObjectInputStream(gis);
            Object ret = ois.readObject();
            ois.close();
            return (T)ret;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

