/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.HashSet;
import java.util.Set;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.ComponentCommon;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StateSpoutSpec;
import org.apache.storm.generated.StormTopology;

public class ThriftTopologyUtils {
    public static boolean isWorkerHook(StormTopology._Fields f) {
        return f.equals((Object)StormTopology._Fields.WORKER_HOOKS);
    }

    public static boolean isDependencies(StormTopology._Fields f) {
        return f.equals((Object)StormTopology._Fields.DEPENDENCY_JARS) || f.equals((Object)StormTopology._Fields.DEPENDENCY_ARTIFACTS);
    }

    public static Set<String> getComponentIds(StormTopology topology) {
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(topology.get_bolts().keySet());
        ret.addAll(topology.get_spouts().keySet());
        ret.addAll(topology.get_state_spouts().keySet());
        return ret;
    }

    public static ComponentCommon getComponentCommon(StormTopology topology, String componentId) {
        Bolt b = topology.get_bolts().get(componentId);
        if (b != null) {
            return b.get_common();
        }
        SpoutSpec s = topology.get_spouts().get(componentId);
        if (s != null) {
            return s.get_common();
        }
        StateSpoutSpec ss = topology.get_state_spouts().get(componentId);
        if (ss != null) {
            return ss.get_common();
        }
        throw new IllegalArgumentException("Could not find component common for " + componentId);
    }
}

