/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cluster;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.storm.callback.DefaultWatcherCallBack;
import org.apache.storm.callback.WatcherCallBack;
import org.apache.storm.callback.ZKStateChangedCallback;
import org.apache.storm.cluster.ClusterStateContext;
import org.apache.storm.cluster.DaemonType;
import org.apache.storm.cluster.IStateStorage;
import org.apache.storm.cluster.VersionedData;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.storm.shade.org.apache.zookeeper.CreateMode;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;
import org.apache.storm.shade.org.apache.zookeeper.Watcher;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.apache.storm.utils.Utils;
import org.apache.storm.zookeeper.ClientZookeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKStateStorage
implements IStateStorage {
    private static Logger LOG = LoggerFactory.getLogger(ZKStateStorage.class);
    private ConcurrentHashMap<String, ZKStateChangedCallback> callbacks = new ConcurrentHashMap();
    private CuratorFramework zkWriter;
    private CuratorFramework zkReader;
    private AtomicBoolean active;
    private boolean isNimbus;
    private Map<String, Object> authConf;
    private Map<String, Object> conf;

    public ZKStateStorage(Map<String, Object> conf, Map<String, Object> authConf, ClusterStateContext context) throws Exception {
        this.conf = conf;
        this.authConf = authConf;
        if (context.getDaemonType().equals((Object)DaemonType.NIMBUS)) {
            this.isNimbus = true;
        }
        CuratorFramework zkTemp = this.mkZk(context.getDaemonType());
        String rootPath = String.valueOf(conf.get("storm.zookeeper.root"));
        ClientZookeeper.mkdirs(zkTemp, rootPath, context.getDefaultZkAcls());
        zkTemp.close();
        this.active = new AtomicBoolean(true);
        this.zkWriter = this.mkZk(new ZkWatcherCallBack(), context.getDaemonType());
        this.zkReader = this.isNimbus ? this.mkZk(new ZkWatcherCallBack(), context.getDaemonType()) : this.zkWriter;
    }

    private CuratorFramework mkZk(DaemonType type) {
        return ClientZookeeper.mkClient(this.conf, (List)this.conf.get("storm.zookeeper.servers"), this.conf.get("storm.zookeeper.port"), "", new DefaultWatcherCallBack(), this.authConf, type);
    }

    private CuratorFramework mkZk(WatcherCallBack watcher, DaemonType type) throws NumberFormatException {
        return ClientZookeeper.mkClient(this.conf, (List)this.conf.get("storm.zookeeper.servers"), this.conf.get("storm.zookeeper.port"), String.valueOf(this.conf.get("storm.zookeeper.root")), watcher, this.authConf, type);
    }

    @Override
    public void delete_node_blobstore(String path, String nimbusHostPortInfo) {
        ClientZookeeper.deleteNodeBlobstore(this.zkWriter, path, nimbusHostPortInfo);
    }

    @Override
    public String register(ZKStateChangedCallback callback) {
        String id = UUID.randomUUID().toString();
        this.callbacks.put(id, callback);
        return id;
    }

    @Override
    public void unregister(String id) {
        this.callbacks.remove(id);
    }

    @Override
    public String create_sequential(String path, byte[] data, List<ACL> acls) {
        return ClientZookeeper.createNode(this.zkWriter, path, data, CreateMode.EPHEMERAL_SEQUENTIAL, acls);
    }

    @Override
    public void mkdirs(String path, List<ACL> acls) {
        ClientZookeeper.mkdirs(this.zkWriter, path, acls);
    }

    @Override
    public void delete_node(String path) {
        ClientZookeeper.deleteNode(this.zkWriter, path);
    }

    @Override
    public void set_ephemeral_node(String path, byte[] data, List<ACL> acls) {
        ClientZookeeper.mkdirs(this.zkWriter, ClientZookeeper.parentPath(path), acls);
        if (ClientZookeeper.exists(this.zkWriter, path, false)) {
            try {
                ClientZookeeper.setData(this.zkWriter, path, data);
            }
            catch (RuntimeException e) {
                if (Utils.exceptionCauseIsInstanceOf(KeeperException.NoNodeException.class, e)) {
                    ClientZookeeper.createNode(this.zkWriter, path, data, CreateMode.EPHEMERAL, acls);
                }
                throw e;
            }
        } else {
            ClientZookeeper.createNode(this.zkWriter, path, data, CreateMode.EPHEMERAL, acls);
        }
    }

    @Override
    public Integer get_version(String path, boolean watch) throws Exception {
        Integer ret = ClientZookeeper.getVersion(this.zkReader, path, watch);
        return ret;
    }

    @Override
    public boolean node_exists(String path, boolean watch) {
        return ClientZookeeper.existsNode(this.zkReader, path, watch);
    }

    @Override
    public List<String> get_children(String path, boolean watch) {
        return ClientZookeeper.getChildren(this.zkReader, path, watch);
    }

    @Override
    public void close() {
        this.active.set(false);
        this.zkWriter.close();
        if (this.isNimbus) {
            this.zkReader.close();
        }
    }

    @Override
    public void set_data(String path, byte[] data, List<ACL> acls) {
        if (ClientZookeeper.exists(this.zkWriter, path, false)) {
            ClientZookeeper.setData(this.zkWriter, path, data);
        } else {
            ClientZookeeper.mkdirs(this.zkWriter, ClientZookeeper.parentPath(path), acls);
            try {
                ClientZookeeper.createNode(this.zkWriter, path, data, CreateMode.PERSISTENT, acls);
            }
            catch (RuntimeException e) {
                if (Utils.exceptionCauseIsInstanceOf(KeeperException.NodeExistsException.class, e)) {
                    ClientZookeeper.setData(this.zkWriter, path, data);
                }
                throw e;
            }
        }
    }

    @Override
    public byte[] get_data(String path, boolean watch) {
        byte[] ret = null;
        ret = ClientZookeeper.getData(this.zkReader, path, watch);
        return ret;
    }

    @Override
    public VersionedData<byte[]> get_data_with_version(String path, boolean watch) {
        return ClientZookeeper.getDataWithVersion(this.zkReader, path, watch);
    }

    @Override
    public void set_worker_hb(String path, byte[] data, List<ACL> acls) {
        this.set_data(path, data, acls);
    }

    @Override
    public byte[] get_worker_hb(String path, boolean watch) {
        return ClientZookeeper.getData(this.zkReader, path, watch);
    }

    @Override
    public List<String> get_worker_hb_children(String path, boolean watch) {
        return this.get_children(path, watch);
    }

    @Override
    public void delete_worker_hb(String path) {
        this.delete_node(path);
    }

    @Override
    public void add_listener(ConnectionStateListener listener) {
        ClientZookeeper.addListener(this.zkReader, (curatorFramework, connectionState) -> listener.stateChanged(curatorFramework, connectionState));
    }

    @Override
    public void sync_path(String path) {
        ClientZookeeper.syncPath(this.zkWriter, path);
    }

    private class ZkWatcherCallBack
    implements WatcherCallBack {
        private ZkWatcherCallBack() {
        }

        @Override
        public void execute(Watcher.Event.KeeperState state, Watcher.Event.EventType type, String path) {
            if (ZKStateStorage.this.active.get()) {
                if (!state.equals((Object)Watcher.Event.KeeperState.SyncConnected)) {
                    LOG.debug("Received event {} : {}: {} with disconnected Zookeeper.", new Object[]{state, type, path});
                } else {
                    LOG.debug("Received event {} : {} : {}", new Object[]{state, type, path});
                }
                if (!type.equals((Object)Watcher.Event.EventType.None)) {
                    for (Map.Entry<String, ZKStateChangedCallback> e : ZKStateStorage.this.callbacks.entrySet()) {
                        ZKStateChangedCallback fn = e.getValue();
                        fn.changed(type, path);
                    }
                }
            }
        }
    }
}

