/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.generated;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.storm.generated.HBNodes;
import org.apache.storm.generated.HBPulse;
import org.apache.storm.generated.HBRecords;
import org.apache.storm.thrift.TBaseHelper;
import org.apache.storm.thrift.TEnum;
import org.apache.storm.thrift.TException;
import org.apache.storm.thrift.TFieldIdEnum;
import org.apache.storm.thrift.TUnion;
import org.apache.storm.thrift.annotation.Nullable;
import org.apache.storm.thrift.meta_data.FieldMetaData;
import org.apache.storm.thrift.meta_data.FieldValueMetaData;
import org.apache.storm.thrift.meta_data.StructMetaData;
import org.apache.storm.thrift.protocol.TCompactProtocol;
import org.apache.storm.thrift.protocol.TField;
import org.apache.storm.thrift.protocol.TProtocol;
import org.apache.storm.thrift.protocol.TProtocolException;
import org.apache.storm.thrift.protocol.TProtocolUtil;
import org.apache.storm.thrift.protocol.TStruct;
import org.apache.storm.thrift.transport.TIOStreamTransport;
import org.apache.storm.thrift.transport.TTransport;

public class HBMessageData
extends TUnion<HBMessageData, _Fields> {
    private static final TStruct STRUCT_DESC = new TStruct("HBMessageData");
    private static final TField PATH_FIELD_DESC = new TField("path", 11, 1);
    private static final TField PULSE_FIELD_DESC = new TField("pulse", 12, 2);
    private static final TField BOOLVAL_FIELD_DESC = new TField("boolval", 2, 3);
    private static final TField RECORDS_FIELD_DESC = new TField("records", 12, 4);
    private static final TField NODES_FIELD_DESC = new TField("nodes", 12, 5);
    private static final TField MESSAGE_BLOB_FIELD_DESC = new TField("message_blob", 11, 7);
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public HBMessageData() {
    }

    public HBMessageData(_Fields setField, Object value) {
        super((TFieldIdEnum)setField, value);
    }

    public HBMessageData(HBMessageData other) {
        super((TUnion)other);
    }

    public HBMessageData deepCopy() {
        return new HBMessageData(this);
    }

    public static HBMessageData path(String value) {
        HBMessageData x = new HBMessageData();
        x.set_path(value);
        return x;
    }

    public static HBMessageData pulse(HBPulse value) {
        HBMessageData x = new HBMessageData();
        x.set_pulse(value);
        return x;
    }

    public static HBMessageData boolval(boolean value) {
        HBMessageData x = new HBMessageData();
        x.set_boolval(value);
        return x;
    }

    public static HBMessageData records(HBRecords value) {
        HBMessageData x = new HBMessageData();
        x.set_records(value);
        return x;
    }

    public static HBMessageData nodes(HBNodes value) {
        HBMessageData x = new HBMessageData();
        x.set_nodes(value);
        return x;
    }

    public static HBMessageData message_blob(ByteBuffer value) {
        HBMessageData x = new HBMessageData();
        x.set_message_blob(value);
        return x;
    }

    public static HBMessageData message_blob(byte[] value) {
        HBMessageData x = new HBMessageData();
        x.set_message_blob(ByteBuffer.wrap((byte[])value.clone()));
        return x;
    }

    protected void checkType(_Fields setField, Object value) throws ClassCastException {
        switch (setField) {
            case PATH: {
                if (value instanceof String) break;
                throw new ClassCastException("Was expecting value of type java.lang.String for field 'path', but got " + value.getClass().getSimpleName());
            }
            case PULSE: {
                if (value instanceof HBPulse) break;
                throw new ClassCastException("Was expecting value of type HBPulse for field 'pulse', but got " + value.getClass().getSimpleName());
            }
            case BOOLVAL: {
                if (value instanceof Boolean) break;
                throw new ClassCastException("Was expecting value of type java.lang.Boolean for field 'boolval', but got " + value.getClass().getSimpleName());
            }
            case RECORDS: {
                if (value instanceof HBRecords) break;
                throw new ClassCastException("Was expecting value of type HBRecords for field 'records', but got " + value.getClass().getSimpleName());
            }
            case NODES: {
                if (value instanceof HBNodes) break;
                throw new ClassCastException("Was expecting value of type HBNodes for field 'nodes', but got " + value.getClass().getSimpleName());
            }
            case MESSAGE_BLOB: {
                if (value instanceof ByteBuffer) break;
                throw new ClassCastException("Was expecting value of type java.nio.ByteBuffer for field 'message_blob', but got " + value.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unknown field id " + String.valueOf((Object)setField));
            }
        }
    }

    protected Object standardSchemeReadValue(TProtocol iprot, TField field) throws TException {
        _Fields setField = _Fields.findByThriftId(field.id);
        if (setField != null) {
            switch (setField) {
                case PATH: {
                    if (field.type == HBMessageData.PATH_FIELD_DESC.type) {
                        String path = iprot.readString();
                        return path;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case PULSE: {
                    if (field.type == HBMessageData.PULSE_FIELD_DESC.type) {
                        HBPulse pulse = new HBPulse();
                        pulse.read(iprot);
                        return pulse;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case BOOLVAL: {
                    if (field.type == HBMessageData.BOOLVAL_FIELD_DESC.type) {
                        Boolean boolval = iprot.readBool();
                        return boolval;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case RECORDS: {
                    if (field.type == HBMessageData.RECORDS_FIELD_DESC.type) {
                        HBRecords records = new HBRecords();
                        records.read(iprot);
                        return records;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case NODES: {
                    if (field.type == HBMessageData.NODES_FIELD_DESC.type) {
                        HBNodes nodes = new HBNodes();
                        nodes.read(iprot);
                        return nodes;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case MESSAGE_BLOB: {
                    if (field.type == HBMessageData.MESSAGE_BLOB_FIELD_DESC.type) {
                        ByteBuffer message_blob = iprot.readBinary();
                        return message_blob;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
            }
            throw new IllegalStateException("setField wasn't null, but didn't match any of the case statements!");
        }
        TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
        return null;
    }

    protected void standardSchemeWriteValue(TProtocol oprot) throws TException {
        switch ((_Fields)this.setField_) {
            case PATH: {
                String path = (String)this.value_;
                oprot.writeString(path);
                return;
            }
            case PULSE: {
                HBPulse pulse = (HBPulse)this.value_;
                pulse.write(oprot);
                return;
            }
            case BOOLVAL: {
                Boolean boolval = (Boolean)this.value_;
                oprot.writeBool(boolval.booleanValue());
                return;
            }
            case RECORDS: {
                HBRecords records = (HBRecords)this.value_;
                records.write(oprot);
                return;
            }
            case NODES: {
                HBNodes nodes = (HBNodes)this.value_;
                nodes.write(oprot);
                return;
            }
            case MESSAGE_BLOB: {
                ByteBuffer message_blob = (ByteBuffer)this.value_;
                oprot.writeBinary(message_blob);
                return;
            }
        }
        throw new IllegalStateException("Cannot write union with unknown field " + String.valueOf(this.setField_));
    }

    protected Object tupleSchemeReadValue(TProtocol iprot, short fieldID) throws TException {
        _Fields setField = _Fields.findByThriftId(fieldID);
        if (setField != null) {
            switch (setField) {
                case PATH: {
                    String path = iprot.readString();
                    return path;
                }
                case PULSE: {
                    HBPulse pulse = new HBPulse();
                    pulse.read(iprot);
                    return pulse;
                }
                case BOOLVAL: {
                    Boolean boolval = iprot.readBool();
                    return boolval;
                }
                case RECORDS: {
                    HBRecords records = new HBRecords();
                    records.read(iprot);
                    return records;
                }
                case NODES: {
                    HBNodes nodes = new HBNodes();
                    nodes.read(iprot);
                    return nodes;
                }
                case MESSAGE_BLOB: {
                    ByteBuffer message_blob = iprot.readBinary();
                    return message_blob;
                }
            }
            throw new IllegalStateException("setField wasn't null, but didn't match any of the case statements!");
        }
        throw new TProtocolException("Couldn't find a field with field id " + fieldID);
    }

    protected void tupleSchemeWriteValue(TProtocol oprot) throws TException {
        switch ((_Fields)this.setField_) {
            case PATH: {
                String path = (String)this.value_;
                oprot.writeString(path);
                return;
            }
            case PULSE: {
                HBPulse pulse = (HBPulse)this.value_;
                pulse.write(oprot);
                return;
            }
            case BOOLVAL: {
                Boolean boolval = (Boolean)this.value_;
                oprot.writeBool(boolval.booleanValue());
                return;
            }
            case RECORDS: {
                HBRecords records = (HBRecords)this.value_;
                records.write(oprot);
                return;
            }
            case NODES: {
                HBNodes nodes = (HBNodes)this.value_;
                nodes.write(oprot);
                return;
            }
            case MESSAGE_BLOB: {
                ByteBuffer message_blob = (ByteBuffer)this.value_;
                oprot.writeBinary(message_blob);
                return;
            }
        }
        throw new IllegalStateException("Cannot write union with unknown field " + String.valueOf(this.setField_));
    }

    protected TField getFieldDesc(_Fields setField) {
        switch (setField) {
            case PATH: {
                return PATH_FIELD_DESC;
            }
            case PULSE: {
                return PULSE_FIELD_DESC;
            }
            case BOOLVAL: {
                return BOOLVAL_FIELD_DESC;
            }
            case RECORDS: {
                return RECORDS_FIELD_DESC;
            }
            case NODES: {
                return NODES_FIELD_DESC;
            }
            case MESSAGE_BLOB: {
                return MESSAGE_BLOB_FIELD_DESC;
            }
        }
        throw new IllegalArgumentException("Unknown field id " + String.valueOf((Object)setField));
    }

    protected TStruct getStructDesc() {
        return STRUCT_DESC;
    }

    protected _Fields enumForId(short id) {
        return _Fields.findByThriftIdOrThrow(id);
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public String get_path() {
        if (this.getSetField() == _Fields.PATH) {
            return (String)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'path' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void set_path(String value) {
        this.setField_ = _Fields.PATH;
        this.value_ = Objects.requireNonNull(value, "_Fields.PATH");
    }

    public HBPulse get_pulse() {
        if (this.getSetField() == _Fields.PULSE) {
            return (HBPulse)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'pulse' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void set_pulse(HBPulse value) {
        this.setField_ = _Fields.PULSE;
        this.value_ = Objects.requireNonNull(value, "_Fields.PULSE");
    }

    public boolean get_boolval() {
        if (this.getSetField() == _Fields.BOOLVAL) {
            return (Boolean)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'boolval' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void set_boolval(boolean value) {
        this.setField_ = _Fields.BOOLVAL;
        this.value_ = value;
    }

    public HBRecords get_records() {
        if (this.getSetField() == _Fields.RECORDS) {
            return (HBRecords)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'records' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void set_records(HBRecords value) {
        this.setField_ = _Fields.RECORDS;
        this.value_ = Objects.requireNonNull(value, "_Fields.RECORDS");
    }

    public HBNodes get_nodes() {
        if (this.getSetField() == _Fields.NODES) {
            return (HBNodes)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'nodes' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void set_nodes(HBNodes value) {
        this.setField_ = _Fields.NODES;
        this.value_ = Objects.requireNonNull(value, "_Fields.NODES");
    }

    public byte[] get_message_blob() {
        this.set_message_blob(TBaseHelper.rightSize((ByteBuffer)this.buffer_for_message_blob()));
        ByteBuffer b = this.buffer_for_message_blob();
        return b == null ? null : b.array();
    }

    public ByteBuffer buffer_for_message_blob() {
        if (this.getSetField() == _Fields.MESSAGE_BLOB) {
            return TBaseHelper.copyBinary((ByteBuffer)((ByteBuffer)this.getFieldValue()));
        }
        throw new RuntimeException("Cannot get field 'message_blob' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void set_message_blob(byte[] value) {
        this.set_message_blob(ByteBuffer.wrap((byte[])value.clone()));
    }

    public void set_message_blob(ByteBuffer value) {
        this.setField_ = _Fields.MESSAGE_BLOB;
        this.value_ = Objects.requireNonNull(value, "_Fields.MESSAGE_BLOB");
    }

    public boolean is_set_path() {
        return this.setField_ == _Fields.PATH;
    }

    public boolean is_set_pulse() {
        return this.setField_ == _Fields.PULSE;
    }

    public boolean is_set_boolval() {
        return this.setField_ == _Fields.BOOLVAL;
    }

    public boolean is_set_records() {
        return this.setField_ == _Fields.RECORDS;
    }

    public boolean is_set_nodes() {
        return this.setField_ == _Fields.NODES;
    }

    public boolean is_set_message_blob() {
        return this.setField_ == _Fields.MESSAGE_BLOB;
    }

    public boolean equals(Object other) {
        if (other instanceof HBMessageData) {
            return this.equals((HBMessageData)((Object)other));
        }
        return false;
    }

    public boolean equals(HBMessageData other) {
        return other != null && this.getSetField() == other.getSetField() && this.getFieldValue().equals(other.getFieldValue());
    }

    public int compareTo(HBMessageData other) {
        int lastComparison = TBaseHelper.compareTo((Comparable)((Comparable)this.getSetField()), (Comparable)((Comparable)other.getSetField()));
        if (lastComparison == 0) {
            return TBaseHelper.compareTo((Object)this.getFieldValue(), (Object)other.getFieldValue());
        }
        return lastComparison;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(((Object)((Object)this)).getClass().getName());
        TFieldIdEnum setField = this.getSetField();
        if (setField != null) {
            list.add(setField.getThriftFieldId());
            Object value = this.getFieldValue();
            if (value instanceof TEnum) {
                list.add(((TEnum)this.getFieldValue()).getValue());
            } else {
                list.add(value);
            }
        }
        return list.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.PATH, new FieldMetaData("path", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PULSE, new FieldMetaData("pulse", 2, (FieldValueMetaData)new StructMetaData(12, HBPulse.class)));
        tmpMap.put(_Fields.BOOLVAL, new FieldMetaData("boolval", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.RECORDS, new FieldMetaData("records", 2, (FieldValueMetaData)new StructMetaData(12, HBRecords.class)));
        tmpMap.put(_Fields.NODES, new FieldMetaData("nodes", 2, (FieldValueMetaData)new StructMetaData(12, HBNodes.class)));
        tmpMap.put(_Fields.MESSAGE_BLOB, new FieldMetaData("message_blob", 2, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(HBMessageData.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        PATH(1, "path"),
        PULSE(2, "pulse"),
        BOOLVAL(3, "boolval"),
        RECORDS(4, "records"),
        NODES(5, "nodes"),
        MESSAGE_BLOB(7, "message_blob");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return PATH;
                }
                case 2: {
                    return PULSE;
                }
                case 3: {
                    return BOOLVAL;
                }
                case 4: {
                    return RECORDS;
                }
                case 5: {
                    return NODES;
                }
                case 7: {
                    return MESSAGE_BLOB;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

