/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.tls;

import java.io.FileInputStream;
import java.net.Socket;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.storm.daemon.common.FileWatcher;
import org.apache.storm.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadableX509KeyManager
implements X509KeyManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadableX509KeyManager.class);
    private static final String KEYSTORE_RUNTIME_FORMAT = "JKS";
    private static final String CERTIFICATE_ENTRY_FORMAT = "X.509";
    private volatile X509KeyManager keyManager;

    public ReloadableX509KeyManager(String keystorePath, String keystorePassword) throws Exception {
        this.keyManager = this.createKeyManager(this.getKeyStore(keystorePath, keystorePassword), keystorePassword);
        FileWatcher.Callback keyStoreWatcherCallback = () -> this.reloadCert(keystorePath, keystorePassword);
        FileWatcher keyStoreWatcher = new FileWatcher(Paths.get(keystorePath, new String[0]), keyStoreWatcherCallback);
        keyStoreWatcher.start();
    }

    public X509KeyManager createKeyManager(KeyStore keystore, String keystorePassword) throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keystore, keystorePassword.toCharArray());
        X509KeyManager x509KeyManager = null;
        for (KeyManager tm : kmf.getKeyManagers()) {
            if (!(tm instanceof X509KeyManager)) continue;
            x509KeyManager = (X509KeyManager)tm;
            break;
        }
        if (x509KeyManager == null) {
            throw new IllegalStateException("No x509KeyManager found");
        }
        LOG.info(" createKeyManager x509KeyManager {} ", x509KeyManager);
        return x509KeyManager;
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        return this.keyManager.getClientAliases(s, principals);
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        return this.keyManager.chooseClientAlias(strings, principals, socket);
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return this.keyManager.getServerAliases(s, principals);
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return this.keyManager.chooseServerAlias(s, principals, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        return this.keyManager.getCertificateChain(s);
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        return this.keyManager.getPrivateKey(s);
    }

    private synchronized void reloadCert(String keystorePath, String keystorePassword) {
        try {
            LOG.info("Reloading KeyManager");
            this.keyManager = this.createKeyManager(this.getKeyStore(keystorePath, keystorePassword), keystorePassword);
            LOG.info("Reloading KeyManager - Done");
        }
        catch (Exception e) {
            LOG.error("Error reloading KeyManager. Setting keyManager to null", (Throwable)e);
            this.keyManager = null;
        }
    }

    public KeyStore getKeyStore(String keystorePath, String keystorePassword) throws Exception {
        String type = SecurityUtils.inferKeyStoreTypeFromPath(keystorePath);
        if (type == null) {
            type = KEYSTORE_RUNTIME_FORMAT;
        }
        LOG.info("Creating keystore with keystorePath {} type {} ", (Object)keystorePath, (Object)type);
        KeyStore keystore = KeyStore.getInstance(type);
        try (FileInputStream keystoreStream = new FileInputStream(keystorePath);){
            keystore.load(keystoreStream, keystorePassword.toCharArray());
        }
        return keystore;
    }
}

