/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams.processors;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.streams.Pair;
import org.apache.storm.streams.operations.CombinerAggregator;
import org.apache.storm.streams.processors.BaseProcessor;
import org.apache.storm.streams.processors.BatchProcessor;

public class MergeAggregateByKeyProcessor<K, V, A, R>
extends BaseProcessor<Pair<K, A>>
implements BatchProcessor {
    protected final CombinerAggregator<V, A, R> aggregator;
    protected final Map<K, A> state = new HashMap<K, A>();

    public MergeAggregateByKeyProcessor(CombinerAggregator<V, A, R> aggregator) {
        this.aggregator = aggregator;
    }

    @Override
    public void execute(Pair<K, A> input) {
        K key = input.getFirst();
        A val = input.getSecond();
        A accumulator = this.state.get(key);
        if (accumulator == null) {
            accumulator = this.aggregator.init();
        }
        this.state.put(key, this.aggregator.merge(accumulator, val));
        this.mayBeForwardAggUpdate(() -> Pair.of(key, this.aggregator.result(this.state.get(key))));
    }

    @Override
    public void finish() {
        for (Map.Entry<K, A> entry : this.state.entrySet()) {
            this.context.forward(Pair.of(entry.getKey(), this.aggregator.result(entry.getValue())));
        }
        this.state.clear();
    }
}

