/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.spout.CheckPointState;
import org.apache.storm.spout.CheckpointSpout;
import org.apache.storm.task.IOutputCollector;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStatefulBoltExecutor
implements IRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(BaseStatefulBoltExecutor.class);
    private final Map<TransactionRequest, Integer> transactionRequestCount;
    protected OutputCollector collector;
    private int checkPointInputTaskCount;
    private long lastTxid = Long.MIN_VALUE;

    public BaseStatefulBoltExecutor() {
        this.transactionRequestCount = new HashMap<TransactionRequest, Integer>();
    }

    protected void init(TopologyContext context, OutputCollector collector) {
        this.collector = collector;
        this.checkPointInputTaskCount = this.getCheckpointInputTaskCount(context);
    }

    private int getCheckpointInputTaskCount(TopologyContext context) {
        int count = 0;
        for (GlobalStreamId inputStream : context.getThisSources().keySet()) {
            if (!"$checkpoint".equals(inputStream.get_streamId())) continue;
            count += context.getComponentTasks(inputStream.get_componentId()).size();
        }
        return count;
    }

    @Override
    public void execute(Tuple input) {
        if (CheckpointSpout.isCheckpoint(input)) {
            this.processCheckpoint(input);
        } else {
            this.handleTuple(input);
        }
    }

    private void processCheckpoint(Tuple input) {
        block5: {
            long txid;
            CheckPointState.Action action = (CheckPointState.Action)((Object)input.getValueByField("action"));
            if (this.shouldProcessTransaction(action, txid = input.getLongByField("txid").longValue())) {
                LOG.debug("Processing action {}, txid {}", (Object)action, (Object)txid);
                try {
                    if (txid >= this.lastTxid) {
                        this.handleCheckpoint(input, action, txid);
                        this.lastTxid = action == CheckPointState.Action.ROLLBACK ? txid - 1L : txid;
                        break block5;
                    }
                    LOG.debug("Ignoring old transaction. Action {}, txid {}", (Object)action, (Object)txid);
                    this.collector.ack(input);
                }
                catch (Throwable th) {
                    LOG.error("Got error while processing checkpoint tuple", th);
                    this.collector.fail(input);
                    this.collector.reportError(th);
                }
            } else {
                LOG.debug("Waiting for action {}, txid {} from all input tasks. checkPointInputTaskCount {}, transactionRequestCount {}", new Object[]{action, txid, this.checkPointInputTaskCount, this.transactionRequestCount});
                this.collector.ack(input);
            }
        }
    }

    private boolean shouldProcessTransaction(CheckPointState.Action action, long txid) {
        TransactionRequest request = new TransactionRequest(action, txid);
        Integer count = this.transactionRequestCount.get(request);
        if (count == null) {
            this.transactionRequestCount.put(request, 1);
            count = 1;
        } else {
            count = count + 1;
            this.transactionRequestCount.put(request, count);
        }
        if (count == this.checkPointInputTaskCount) {
            this.transactionRequestCount.remove(request);
            return true;
        }
        return false;
    }

    protected void declareCheckpointStream(OutputFieldsDeclarer declarer) {
        declarer.declareStream("$checkpoint", new Fields("txid", "action"));
    }

    protected abstract void handleTuple(Tuple var1);

    protected abstract void handleCheckpoint(Tuple var1, CheckPointState.Action var2, long var3);

    private static class TransactionRequest {
        private final CheckPointState.Action action;
        private final long txid;

        TransactionRequest(CheckPointState.Action action, long txid) {
            this.action = action;
            this.txid = txid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionRequest that = (TransactionRequest)o;
            if (this.txid != that.txid) {
                return false;
            }
            return !(this.action == null ? that.action != null : !this.action.equals((Object)that.action));
        }

        public int hashCode() {
            int result2 = this.action != null ? this.action.hashCode() : 0;
            result2 = 31 * result2 + (int)(this.txid ^ this.txid >>> 32);
            return result2;
        }

        public String toString() {
            return "TransactionRequest{action='" + String.valueOf((Object)this.action) + "', txid=" + this.txid + "}";
        }
    }

    protected static class AnchoringOutputCollector
    extends OutputCollector {
        AnchoringOutputCollector(IOutputCollector delegate) {
            super(delegate);
        }

        @Override
        public List<Integer> emit(String streamId, List<Object> tuple) {
            throw new UnsupportedOperationException("Bolts in a stateful topology must emit anchored tuples.");
        }

        @Override
        public void emitDirect(int taskId, String streamId, List<Object> tuple) {
            throw new UnsupportedOperationException("Bolts in a stateful topology must emit anchored tuples.");
        }
    }
}

