/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology;

import java.util.Map;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.BasicOutputCollector;
import org.apache.storm.topology.FailedException;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.ReportedFailedException;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicBoltExecutor
implements IRichBolt {
    public static final Logger LOG = LoggerFactory.getLogger(BasicBoltExecutor.class);
    private IBasicBolt bolt;
    private transient BasicOutputCollector collector;

    public BasicBoltExecutor(IBasicBolt bolt) {
        this.bolt = bolt;
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.bolt.declareOutputFields(declarer);
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        this.bolt.prepare(topoConf, context);
        this.collector = new BasicOutputCollector(collector);
    }

    @Override
    public void execute(Tuple input) {
        this.collector.setContext(input);
        try {
            this.bolt.execute(input, this.collector);
            this.collector.getOutputter().ack(input);
        }
        catch (FailedException e) {
            if (e instanceof ReportedFailedException) {
                this.collector.reportError(e);
            }
            this.collector.getOutputter().fail(input);
        }
    }

    @Override
    public void cleanup() {
        this.bolt.cleanup();
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.bolt.getComponentConfiguration();
    }
}

