/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.storm.daemon.supervisor.AdvancedFSOps;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.shade.com.google.common.collect.Maps;
import org.apache.storm.shade.org.apache.commons.io.FileUtils;
import org.apache.storm.utils.LocalState;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Utils;
import org.apache.storm.validation.ConfigValidation;
import org.apache.storm.validation.ConfigValidationAnnotations;

public class ConfigUtils {
    public static final String FILE_SEPARATOR = File.separator;
    public static final String STORM_HOME = "storm.home";
    public static final String RESOURCES_SUBDIR = "resources";
    private static final Set<String> passwordConfigKeys = new HashSet<String>();
    private static ConfigUtils instance;

    public static ConfigUtils setInstance(ConfigUtils u) {
        ConfigUtils oldInstance = instance;
        instance = u;
        return oldInstance;
    }

    public static Map<String, Object> maskPasswords(Map<String, Object> conf) {
        Maps.EntryTransformer<String, Object, Object> maskPasswords = new Maps.EntryTransformer<String, Object, Object>(){

            public Object transformEntry(String key, Object value) {
                return passwordConfigKeys.contains(key) ? "*****" : value;
            }
        };
        return Maps.transformEntries(conf, (Maps.EntryTransformer)maskPasswords);
    }

    public static boolean isLocalMode(Map<String, Object> conf) {
        String mode = (String)conf.get("storm.cluster.mode");
        if (mode != null) {
            if ("local".equals(mode)) {
                return true;
            }
            if ("distributed".equals(mode)) {
                return false;
            }
            throw new IllegalArgumentException("Illegal cluster mode in conf: " + mode);
        }
        return true;
    }

    public static Collection<String> readDirContents(String dir) {
        Collection<File> ret = ConfigUtils.readDirFiles(dir);
        return ret.stream().map(car -> car.getName()).collect(Collectors.toList());
    }

    public static Collection<File> readDirFiles(String dir) {
        HashSet<File> ret = new HashSet<File>();
        File[] files = new File(dir).listFiles();
        if (files != null) {
            for (File f : files) {
                ret.add(f);
            }
        }
        return ret;
    }

    public static String workerArtifactsRoot(Map<String, Object> conf) {
        return instance.workerArtifactsRootImpl(conf);
    }

    public static String workerArtifactsRoot(Map<String, Object> conf, String id) {
        return ConfigUtils.workerArtifactsRoot(conf) + FILE_SEPARATOR + id;
    }

    public static String workerArtifactsRoot(Map<String, Object> conf, String id, Integer port) {
        return ConfigUtils.workerArtifactsRoot(conf, id) + FILE_SEPARATOR + port;
    }

    public static String getLogDir() {
        Map<String, Object> conf;
        Object dir = System.getProperty("storm.log.dir") != null ? System.getProperty("storm.log.dir") : ((conf = ConfigUtils.readStormConfig()).get("storm.log.dir") != null ? String.valueOf(conf.get("storm.log.dir")) : (System.getProperty(STORM_HOME) != null ? System.getProperty(STORM_HOME) + FILE_SEPARATOR + "logs" : "logs"));
        try {
            return new File((String)dir).getCanonicalPath();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Illegal storm.log.dir in conf: " + (String)dir);
        }
    }

    public static Map<String, Object> readStormConfig() {
        return instance.readStormConfigImpl();
    }

    public static int samplingRate(Map<String, Object> conf) {
        double rate = ObjectReader.getDouble(conf.get("topology.stats.sample.rate"));
        if (rate != 0.0) {
            return (int)(1.0 / rate);
        }
        throw new IllegalArgumentException("Illegal topology.stats.sample.rate in conf: " + rate);
    }

    public static BooleanSupplier mkStatsSampler(Map<String, Object> conf) {
        return ConfigUtils.evenSampler(ConfigUtils.samplingRate(conf));
    }

    public static BooleanSupplier evenSampler(final int samplingFreq) {
        final Random random = new Random();
        return new BooleanSupplier(){
            private int curr = -1;
            private int target = random.nextInt(samplingFreq);

            @Override
            public boolean getAsBoolean() {
                ++this.curr;
                if (this.curr >= samplingFreq) {
                    this.curr = 0;
                    this.target = random.nextInt(samplingFreq);
                }
                return this.curr == this.target;
            }
        };
    }

    public static StormTopology readSupervisorTopology(Map<String, Object> conf, String stormId, AdvancedFSOps ops) throws IOException {
        return instance.readSupervisorTopologyImpl(conf, stormId, ops);
    }

    public static String supervisorStormCodePath(String stormRoot) {
        return ConfigUtils.concatIfNotNull(stormRoot) + FILE_SEPARATOR + "stormcode.ser";
    }

    public static String concatIfNotNull(String dir) {
        String ret = "";
        if (dir != null) {
            ret = dir;
        }
        return ret;
    }

    public static String supervisorStormDistRoot(Map<String, Object> conf) throws IOException {
        return instance.supervisorStormDistRootImpl(conf);
    }

    public static String supervisorStormDistRoot(Map<String, Object> conf, String stormId) throws IOException {
        return instance.supervisorStormDistRootImpl(conf, stormId);
    }

    public static String sharedByTopologyDir(Map<String, Object> conf, String stormId) throws IOException {
        return ConfigUtils.supervisorStormDistRoot(conf, stormId) + FILE_SEPARATOR + "shared_by_topology";
    }

    public static String supervisorStormJarPath(String stormRoot) {
        return ConfigUtils.concatIfNotNull(stormRoot) + FILE_SEPARATOR + "stormjar.jar";
    }

    public static String supervisorStormConfPath(String stormRoot) {
        return ConfigUtils.concatIfNotNull(stormRoot) + FILE_SEPARATOR + "stormconf.ser";
    }

    public static String absoluteStormLocalDir(Map<String, Object> conf) {
        String stormHome = System.getProperty(STORM_HOME);
        String localDir = (String)conf.get("storm.local.dir");
        if (localDir == null) {
            return stormHome + FILE_SEPARATOR + "storm-local";
        }
        if (new File(localDir).isAbsolute()) {
            return localDir;
        }
        return stormHome + FILE_SEPARATOR + localDir;
    }

    public static String absoluteStormBlobStoreDir(Map<String, Object> conf) {
        String blobStoreDir = (String)conf.get("blobstore.dir");
        if (blobStoreDir == null) {
            return ConfigUtils.absoluteStormLocalDir(conf);
        }
        if (new File(blobStoreDir).isAbsolute()) {
            return blobStoreDir;
        }
        String stormHome = System.getProperty(STORM_HOME);
        return stormHome + FILE_SEPARATOR + blobStoreDir;
    }

    public static StormTopology readSupervisorStormCodeGivenPath(String stormCodePath, AdvancedFSOps ops) throws IOException {
        return Utils.deserialize(ops.slurp(new File(stormCodePath)), StormTopology.class);
    }

    public static String supervisorStormResourcesPath(String stormRoot) {
        return ConfigUtils.concatIfNotNull(stormRoot) + FILE_SEPARATOR + RESOURCES_SUBDIR;
    }

    public static String workerRoot(Map<String, Object> conf) {
        return instance.workerRootImpl(conf);
    }

    public static String workerRoot(Map<String, Object> conf, String id) {
        return ConfigUtils.workerRoot(conf) + FILE_SEPARATOR + id;
    }

    public static String workerArtifactsSymlink(Map<String, Object> conf, String id) {
        return ConfigUtils.workerRoot(conf, id) + FILE_SEPARATOR + "artifacts";
    }

    public static String workerPidsRoot(Map<String, Object> conf, String id) {
        return ConfigUtils.workerRoot(conf, id) + FILE_SEPARATOR + "pids";
    }

    public static String workerPidPath(Map<String, Object> conf, String id, String pid) {
        return ConfigUtils.workerPidsRoot(conf, id) + FILE_SEPARATOR + pid;
    }

    public static String workerPidPath(Map<String, Object> conf, String id, long pid) {
        return ConfigUtils.workerPidPath(conf, id, String.valueOf(pid));
    }

    public static String workerArtifactsPidPath(Map<String, Object> conf, String id, Integer port) {
        return ConfigUtils.workerArtifactsRoot(conf, id, port) + FILE_SEPARATOR + "worker.pid";
    }

    public static Map<String, Object> readSupervisorStormConf(Map<String, Object> conf, String stormId) throws IOException {
        return instance.readSupervisorStormConfImpl(conf, stormId);
    }

    public static Map<String, Object> readSupervisorStormConfGivenPath(Map<String, Object> conf, String topoConfPath) throws IOException {
        HashMap<String, Object> ret = new HashMap<String, Object>(conf);
        ret.putAll(Utils.fromCompressedJsonConf(FileUtils.readFileToByteArray((File)new File(topoConfPath))));
        return ret;
    }

    public static Map<String, Object> overrideLoginConfigWithSystemProperty(Map<String, Object> conf) {
        String loginConfFile = System.getProperty("java.security.auth.login.config");
        if (loginConfFile != null) {
            conf.put("java.security.auth.login.config", loginConfFile);
        }
        return conf;
    }

    public static String workerHeartbeatsRoot(Map<String, Object> conf, String id) {
        return ConfigUtils.workerRoot(conf, id) + FILE_SEPARATOR + "heartbeats";
    }

    public static LocalState workerState(Map<String, Object> conf, String id) throws IOException {
        return new LocalState(ConfigUtils.workerHeartbeatsRoot(conf, id), false);
    }

    public static String masterStormCodeKey(String topologyId) {
        return topologyId + "-stormcode.ser";
    }

    public static String masterStormConfKey(String topologyId) {
        return topologyId + "-stormconf.ser";
    }

    public static String getIdFromBlobKey(String key) {
        if (key == null) {
            return null;
        }
        String stormJarSuffix = "-stormjar.jar";
        String stormCodeSuffix = "-stormcode.ser";
        String stormConfSuffix = "-stormconf.ser";
        String ret = null;
        if (key.endsWith("-stormjar.jar")) {
            ret = key.substring(0, key.length() - "-stormjar.jar".length());
        } else if (key.endsWith("-stormcode.ser")) {
            ret = key.substring(0, key.length() - "-stormcode.ser".length());
        } else if (key.endsWith("-stormconf.ser")) {
            ret = key.substring(0, key.length() - "-stormconf.ser".length());
        }
        return ret;
    }

    public static String masterStormJarKey(String topologyId) {
        return topologyId + "-stormjar.jar";
    }

    public static Map<String, Object> readYamlConfig(String name, boolean mustExist) {
        Map<String, Object> conf = Utils.findAndReadConfigFile(name, mustExist);
        ConfigValidation.validateFields(conf);
        return conf;
    }

    public static Map<String, Object> readYamlConfig(String name) {
        return ConfigUtils.readYamlConfig(name, true);
    }

    public static String stormDistPath(String stormRoot) {
        String ret = "";
        if (stormRoot != null) {
            ret = stormRoot;
        }
        return ret + FILE_SEPARATOR + "stormdist";
    }

    public static String supervisorLocalDir(Map<String, Object> conf) throws IOException {
        return instance.supervisorLocalDirImpl(conf);
    }

    public static String workerTmpRoot(Map<String, Object> conf, String id) {
        return ConfigUtils.workerRoot(conf, id) + FILE_SEPARATOR + "tmp";
    }

    public static String workerUserRoot(Map<String, Object> conf) {
        return ConfigUtils.absoluteStormLocalDir(conf) + FILE_SEPARATOR + "workers-users";
    }

    public static String workerUserFile(Map<String, Object> conf, String workerId) {
        return ConfigUtils.workerUserRoot(conf) + FILE_SEPARATOR + workerId;
    }

    public static File getWorkerDirFromRoot(String logRoot, String id, Integer port) {
        return new File(logRoot + FILE_SEPARATOR + id + FILE_SEPARATOR + port);
    }

    public static List<String> getValueAsList(String name, Map<String, Object> conf) {
        if (null == conf) {
            throw new IllegalArgumentException("Conf is required");
        }
        Object value = conf.get(name);
        List<Object> listValue = value == null ? null : (value instanceof Collection ? ((Collection)value).stream().map(ObjectReader::getString).collect(Collectors.toList()) : Arrays.asList(ObjectReader.getString(value).split("\\s+")));
        return listValue;
    }

    public StormTopology readSupervisorTopologyImpl(Map<String, Object> conf, String stormId, AdvancedFSOps ops) throws IOException {
        String stormRoot = ConfigUtils.supervisorStormDistRoot(conf, stormId);
        String topologyPath = ConfigUtils.supervisorStormCodePath(stormRoot);
        return ConfigUtils.readSupervisorStormCodeGivenPath(topologyPath, ops);
    }

    public Map<String, Object> readStormConfigImpl() {
        Map<String, Object> conf = Utils.readStormConfig();
        ConfigValidation.validateFields(conf);
        return conf;
    }

    public String workerArtifactsRootImpl(Map<String, Object> conf) {
        String artifactsDir = (String)conf.get("storm.workers.artifacts.dir");
        if (artifactsDir == null) {
            return ConfigUtils.getLogDir() + FILE_SEPARATOR + "workers-artifacts";
        }
        if (new File(artifactsDir).isAbsolute()) {
            return artifactsDir;
        }
        return ConfigUtils.getLogDir() + FILE_SEPARATOR + artifactsDir;
    }

    public String supervisorStormDistRootImpl(Map<String, Object> conf, String stormId) throws IOException {
        return ConfigUtils.supervisorStormDistRoot(conf) + FILE_SEPARATOR + Utils.urlEncodeUtf8(stormId);
    }

    public String supervisorStormDistRootImpl(Map<String, Object> conf) throws IOException {
        return ConfigUtils.stormDistPath(ConfigUtils.supervisorLocalDir(conf));
    }

    public String workerRootImpl(Map<String, Object> conf) {
        return ConfigUtils.absoluteStormLocalDir(conf) + FILE_SEPARATOR + "workers";
    }

    public Map<String, Object> readSupervisorStormConfImpl(Map<String, Object> conf, String stormId) throws IOException {
        String stormRoot = ConfigUtils.supervisorStormDistRoot(conf, stormId);
        String confPath = ConfigUtils.supervisorStormConfPath(stormRoot);
        return ConfigUtils.readSupervisorStormConfGivenPath(conf, confPath);
    }

    public String supervisorLocalDirImpl(Map<String, Object> conf) throws IOException {
        String ret = ConfigUtils.absoluteStormLocalDir(conf) + FILE_SEPARATOR + "supervisor";
        FileUtils.forceMkdir((File)new File(ret));
        return ret;
    }

    static {
        for (Class<?> clazz : ConfigValidation.getConfigClasses()) {
            for (Field field : clazz.getFields()) {
                for (Annotation annotation : field.getAnnotations()) {
                    boolean isPassword = annotation.annotationType().getName().equals(ConfigValidationAnnotations.Password.class.getName());
                    if (!isPassword) continue;
                    try {
                        passwordConfigKeys.add((String)field.get(null));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
        }
        instance = new ConfigUtils();
    }
}

