/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.google.common.cache.CacheBuilderSpec;
import java.io.IOException;

public class GuavaExtrasModule
extends Module {
    public String getModuleName() {
        return "guava-extras";
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(Module.SetupContext context) {
        context.addDeserializers((Deserializers)new GuavaExtrasDeserializers());
        context.addSerializers((Serializers)new GuavaExtrasSerializers());
    }

    private static class GuavaExtrasDeserializers
    extends Deserializers.Base {
        private GuavaExtrasDeserializers() {
        }

        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
            if (CacheBuilderSpec.class.isAssignableFrom(type.getRawClass())) {
                return new CacheBuilderSpecDeserializer();
            }
            return super.findBeanDeserializer(type, config, beanDesc);
        }
    }

    private static class GuavaExtrasSerializers
    extends Serializers.Base {
        private GuavaExtrasSerializers() {
        }

        public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
            if (CacheBuilderSpec.class.isAssignableFrom(type.getRawClass())) {
                return new CacheBuilderSpecSerializer();
            }
            return super.findSerializer(config, type, beanDesc);
        }
    }

    private static class CacheBuilderSpecSerializer
    extends JsonSerializer<CacheBuilderSpec> {
        private CacheBuilderSpecSerializer() {
        }

        public void serialize(CacheBuilderSpec value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.toParsableString());
        }
    }

    private static class CacheBuilderSpecDeserializer
    extends JsonDeserializer<CacheBuilderSpec> {
        private CacheBuilderSpecDeserializer() {
        }

        public CacheBuilderSpec deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String text = jp.getText();
            boolean disabled = "off".equalsIgnoreCase(text) || "disabled".equalsIgnoreCase(text);
            return disabled ? CacheBuilderSpec.disableCaching() : CacheBuilderSpec.parse((String)text);
        }
    }
}

