/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DigestCalculator;
import org.apache.zookeeper.server.NodeHashMap;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.util.AdHash;

public class NodeHashMapImpl
implements NodeHashMap {
    private final ConcurrentHashMap<String, DataNode> nodes;
    private final boolean digestEnabled;
    private final DigestCalculator digestCalculator;
    private final AdHash hash;

    public NodeHashMapImpl(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
        this.nodes = new ConcurrentHashMap();
        this.hash = new AdHash();
        this.digestEnabled = ZooKeeperServer.isDigestEnabled();
    }

    @Override
    public DataNode put(String path, DataNode node) {
        DataNode oldNode = this.nodes.put(path, node);
        this.addDigest(path, node);
        if (oldNode != null) {
            this.removeDigest(path, oldNode);
        }
        return oldNode;
    }

    @Override
    public DataNode putWithoutDigest(String path, DataNode node) {
        return this.nodes.put(path, node);
    }

    @Override
    public DataNode get(String path) {
        return this.nodes.get(path);
    }

    @Override
    public DataNode remove(String path) {
        DataNode oldNode = this.nodes.remove(path);
        if (oldNode != null) {
            this.removeDigest(path, oldNode);
        }
        return oldNode;
    }

    @Override
    public Set<Map.Entry<String, DataNode>> entrySet() {
        return this.nodes.entrySet();
    }

    @Override
    public void clear() {
        this.nodes.clear();
        this.hash.clear();
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public void preChange(String path, DataNode node) {
        this.removeDigest(path, node);
    }

    @Override
    public void postChange(String path, DataNode node) {
        node.digestCached = false;
        this.addDigest(path, node);
    }

    private void addDigest(String path, DataNode node) {
        if (path.startsWith("/zookeeper/")) {
            return;
        }
        if (this.digestEnabled) {
            this.hash.addDigest(this.digestCalculator.calculateDigest(path, node));
        }
    }

    private void removeDigest(String path, DataNode node) {
        if (path.startsWith("/zookeeper/")) {
            return;
        }
        if (this.digestEnabled) {
            this.hash.removeDigest(this.digestCalculator.calculateDigest(path, node));
        }
    }

    @Override
    public long getDigest() {
        return this.hash.getHash();
    }
}

