/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.command;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.storm.command.CLI;
import org.apache.storm.generated.KillOptions;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillTopology {
    private static final Logger LOG = LoggerFactory.getLogger(KillTopology.class);
    private static int errorCount;

    public static void main(String[] args) throws Exception {
        Map<String, Object> cl = CLI.opt("w", "wait", null, CLI.AS_INT).boolOpt("i", "ignore-errors").arg("TOPO", CLI.INTO_LIST).parse(args);
        List names = (List)cl.get("TOPO");
        Boolean continueOnError = (Boolean)cl.get("i");
        errorCount = 0;
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            try {
                Utils.validateTopologyName((String)name);
            }
            catch (IllegalArgumentException e) {
                if (!continueOnError.booleanValue()) {
                    throw e;
                }
                iterator.remove();
                ++errorCount;
                LOG.error("Format of topology name {} is not valid ", (Object)name);
            }
        }
        if (names.isEmpty()) {
            throw new RuntimeException("Failed to successfully kill " + errorCount + " topologies.");
        }
        Integer wait = (Integer)cl.get("w");
        KillOptions opts = new KillOptions();
        if (wait != null) {
            opts.set_wait_secs(wait.intValue());
        }
        NimbusClient.withConfiguredClient(nimbus -> {
            for (String name : names) {
                try {
                    nimbus.killTopologyWithOpts(name, opts);
                    LOG.info("Killed topology: {}", (Object)name);
                }
                catch (Exception e) {
                    ++errorCount;
                    if (continueOnError.booleanValue()) {
                        LOG.error("Caught error killing topology '{}'; continuing as -i was passed.", (Object)name, (Object)e);
                        continue;
                    }
                    throw e;
                }
            }
            if (errorCount > 0) {
                throw new RuntimeException("Failed to successfully kill " + errorCount + " topologies.");
            }
        });
    }
}

