/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.commons.collections4.functors;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.apache.storm.shade.org.apache.commons.collections4.Transformer;
import org.apache.storm.shade.org.apache.commons.collections4.functors.FunctorUtils;
import org.apache.storm.shade.org.apache.commons.collections4.functors.NOPTransformer;

public class ChainedTransformer<T>
implements Transformer<T, T>,
Serializable {
    private static final Transformer[] EMPTY_TRANSFORMER_ARRAY = new Transformer[0];
    private static final long serialVersionUID = 3514945074733160196L;
    private final Transformer<? super T, ? extends T>[] iTransformers;

    public static <T> Transformer<T, T> chainedTransformer(Collection<? extends Transformer<? super T, ? extends T>> transformers) {
        Objects.requireNonNull(transformers, "transformers");
        if (transformers.isEmpty()) {
            return NOPTransformer.nopTransformer();
        }
        Transformer[] cmds = transformers.toArray(EMPTY_TRANSFORMER_ARRAY);
        FunctorUtils.validate(cmds);
        return new ChainedTransformer<T>(false, cmds);
    }

    public static <T> Transformer<T, T> chainedTransformer(Transformer<? super T, ? extends T> ... transformers) {
        FunctorUtils.validate(transformers);
        if (transformers.length == 0) {
            return NOPTransformer.nopTransformer();
        }
        return new ChainedTransformer<T>(transformers);
    }

    private ChainedTransformer(boolean clone, Transformer<? super T, ? extends T>[] transformers) {
        this.iTransformers = clone ? (Transformer[])FunctorUtils.copy((Function[])transformers) : transformers;
    }

    public ChainedTransformer(Transformer<? super T, ? extends T> ... transformers) {
        this(true, transformers);
    }

    public Transformer<? super T, ? extends T>[] getTransformers() {
        return (Transformer[])FunctorUtils.copy((Function[])this.iTransformers);
    }

    @Override
    public T transform(T object) {
        for (Transformer<T, T> transformer : this.iTransformers) {
            object = transformer.apply(object);
        }
        return object;
    }
}

